package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.plat.Constants;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.rss.RssAction;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.*;

public class CreateTaskListAction extends RssAction {

	private SysWorkFlowDefineService workFlowDefineService;
    
	private String rid;

    private Set<Map.Entry<String,List<PfWorkFlowDefineVo>>> setWorkFlowDefine;
    
	private boolean taskHandle;

    private List<PfWorkFlowDefineVo> lstWorkFlowDefine;

    private String businessType;
    
	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public String execute() throws Exception {
//		UserInfo userInfo = SessionUtil.getCurrentUser();
//
//		List<PfWorkFlowDefineVo> lstWorkFlowDefine = null;
//
//		if (userInfo.isAdmin())
//			lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineList();
//		else
//			lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);
//
//		Map<String,List<PfWorkFlowDefineVo>> mapWorkFlowDefine = new LinkedHashMap<String,List<PfWorkFlowDefineVo>>();
//		for(PfWorkFlowDefineVo wfd : lstWorkFlowDefine){
//			String businessName = wfd.getBusinessVo().getBusinessName();
//            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
//            wfd.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
//            //wfd.setCreateUrl(AppConfig.getPlaceholderValue(wfd.getCreateUrl()));
//			if(mapWorkFlowDefine.get(businessName) != null){
//				mapWorkFlowDefine.get(businessName).add(wfd);
//			}else {
//				List<PfWorkFlowDefineVo> wfdList = new ArrayList<PfWorkFlowDefineVo>();
//				wfdList.add(wfd);
//				mapWorkFlowDefine.put(businessName, wfdList);
//			}
//		}
//		setWorkFlowDefine = mapWorkFlowDefine.entrySet();
//
//		return Action.SUCCESS;
        UserInfo userInfo = SessionUtil.getCurrentUser();

        List<PfWorkFlowDefineVo> lstWorkFlowDefine = null;

        if (userInfo.isAdmin())
            lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineList();
        else
            lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);

        Map<String,List<PfWorkFlowDefineVo>> mapWorkFlowDefine = new LinkedHashMap<String,List<PfWorkFlowDefineVo>>();
        for(PfWorkFlowDefineVo wfd : lstWorkFlowDefine){
            String businessName = wfd.getBusinessVo().getBusinessName();
            String groupId = wfd.getGroupId();
            String categoryName =  businessName;
            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
            wfd.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
            if(StringUtils.isNotBlank(groupId))
                categoryName = wfd.getResourceGroupVo().getGroupName();
            if(mapWorkFlowDefine.get(categoryName) != null){
                mapWorkFlowDefine.get(categoryName).add(wfd);
            }else {
                List<PfWorkFlowDefineVo> wfdList = new ArrayList<PfWorkFlowDefineVo>();
                wfdList.add(wfd);
                mapWorkFlowDefine.put(categoryName, wfdList);
            }
        }
        setWorkFlowDefine = mapWorkFlowDefine.entrySet();

        return Action.SUCCESS;
	}


//    public String businessTaskList() throws Exception {
//        UserInfo userInfo = SessionUtil.getCurrentUser();
//
//        List<PfWorkFlowDefineVo> lstWorkFlowDefine = null;
//
//        if (userInfo.isAdmin())
//            lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineList();
//        else
//            lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);
//
//        Map<String,List<Map<String,List<PfWorkFlowDefineVo>>>> mapWorkFlowDefine = new LinkedHashMap<String,List<Map<String,List<PfWorkFlowDefineVo>>>>();
//        for(PfWorkFlowDefineVo wfd : lstWorkFlowDefine){
//            String businessName = wfd.getBusinessVo().getBusinessName();
//            String groupName = null;
//            if(wfd.getResourceGroupVo()!=null)
//                groupName = wfd.getResourceGroupVo().getGroupName();
//            else
//                groupName="其他";
//            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
//            wfd.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
//            if(mapWorkFlowDefine.get(businessName) != null){
//                boolean isExistedGroup = false;
//                for(int i =0;i<mapWorkFlowDefine.get(businessName).size();i++){
//                    if(mapWorkFlowDefine.get(businessName).get(i).containsKey(groupName)){
//                        mapWorkFlowDefine.get(businessName).get(i).get(groupName).add(wfd);
//                        isExistedGroup = true;
//                        break;
//                    }
//                }
//                if(!isExistedGroup){
//                    List<PfWorkFlowDefineVo> wfdList = new ArrayList<PfWorkFlowDefineVo>();
//                    wfdList.add(wfd);
//                    Map<String,List<PfWorkFlowDefineVo>> tmpGroup =  new LinkedHashMap<String,List<PfWorkFlowDefineVo>>();
//                    tmpGroup.put(groupName,wfdList);
//                    mapWorkFlowDefine.get(businessName).add(tmpGroup);
//                }
//            }else {
//                List<PfWorkFlowDefineVo> wfdList = new ArrayList<PfWorkFlowDefineVo>();
//                wfdList.add(wfd);
//                Map<String,List<PfWorkFlowDefineVo>> tmpGroup =  new LinkedHashMap<String,List<PfWorkFlowDefineVo>>();
//                tmpGroup.put(groupName,wfdList);
//                List<Map<String,List<PfWorkFlowDefineVo>>> tmpBusinessGroup = new ArrayList<Map<String,List<PfWorkFlowDefineVo>>>();
//                tmpBusinessGroup.add(tmpGroup);
//                mapWorkFlowDefine.put(businessName,tmpBusinessGroup);
//            }
//        }
//        //setWorkFlowDefine = mapWorkFlowDefine.entrySet();
//        return Action.SUCCESS;
//    }

	public String rss() throws Exception {
		UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo.isAdmin())
			lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineList();
		else
			lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(),Constants.CREATE_TASK_RESOURCE_ID,null);

        super.buildEntry(lstWorkFlowDefine);

        return "RSS";
	}

	public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
		return lstWorkFlowDefine;
	}

	public void setLstWorkFlowDefine(List<PfWorkFlowDefineVo> lstWorkFlowDefine) {
		this.lstWorkFlowDefine = lstWorkFlowDefine;
	}

	public boolean isTaskHandle() {
		return taskHandle;
	}

	public void setTaskHandle(boolean taskHandle) {
		this.taskHandle = taskHandle;
	}

    public Set<Map.Entry<String, List<PfWorkFlowDefineVo>>> getSetWorkFlowDefine() {
		return setWorkFlowDefine;
	}

	public void setSetWorkFlowDefine(
			Set<Map.Entry<String, List<PfWorkFlowDefineVo>>> setWorkFlowDefine) {
		this.setWorkFlowDefine = setWorkFlowDefine;
	}

    public String getRid() {
		return rid;
	}

	public void setRid(String rid) {
		this.rid = rid;
	}

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
}
