package com.gtis.web.action;

import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.Date;
import java.util.List;

/**
 * User: JIFF
 * Date: 2014/10/15
 */
public class CalendarAction {
    SysCalendarService calendarService;
    SysTaskService taskService;
    SysWorkFlowInstanceService workFlowInstanceService;
    /** 分页 */
    private String pageInfo;

    private String overTime;

    public String getPageInfo() {
        return pageInfo;
    }

    public String getOverTime() {
        return overTime;
    }

    public void setOverTime(String overTime) {
        this.overTime = overTime;
    }

    public SysCalendarService getCalendarService() {
        return calendarService;
    }

    public void setCalendarService(SysCalendarService calendarService) {
        this.calendarService = calendarService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setWorkFlowInstanceService(SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public String execute() throws Exception {
        SplitParam splitParam=new SplitParamImpl();
        splitParam.setQueryString("getProjectList");
        pageInfo=ByteObjectAccess.objectToString(splitParam);
        return Action.SUCCESS;
    }

    public String refresh() throws Exception {
        calendarService.reloadWorkdaysAndHolidays();
        return Action.NONE;
    }

    public String calWorkDay() throws Exception {
        String[] wiids= ServletActionContext.getRequest().getParameterValues("wiid");
        if (wiids!=null && wiids.length>0){
            String wiid=wiids[0];
            PfWorkFlowInstanceVo workFlowInstanceVo= workFlowInstanceService.getWorkflowInstance(wiid);
            if (workFlowInstanceVo!=null) {
                //////
                if (workFlowInstanceVo.getOverTime() == null) {
                    Date overTime = calendarService.getOverTime(workFlowInstanceVo.getCreateTime(), workFlowInstanceVo.getTimeLimit());
                    workFlowInstanceService.updateWorkFlowIntanceOverTime(workFlowInstanceVo.getWorkflowIntanceId(), overTime);
                }
                List<PfActivityVo> activityVoList = taskService.getWorkFlowInstanceAllActivityList(workFlowInstanceVo.getWorkflowIntanceId());
                for (PfActivityVo activityVo : activityVoList) {
                    Date overTime2 = calendarService.getOverTime(activityVo.getBeginTime(), activityVo.getTimeLimit());
                    List<PfTaskVo> taskVos = taskService.getTaskListByActivity(activityVo.getActivityId());
                    for (PfTaskVo taskVo : taskVos) {
                        if (taskVo.getOverTime() == null)
                            taskService.updateTaskOverTime(taskVo.getTaskId(), overTime2);
                    }
                    List<PfTaskVo> taskHisVos = taskService.getHistoryTaskListByActivity(activityVo.getActivityId());
                    for (PfTaskVo taskVo : taskHisVos) {
                        if (taskVo.getOverTime() == null)
                            taskService.updateTaskHistoryOverTime(taskVo.getTaskId(), overTime2);
                    }
                }
            }
        }
        return Action.NONE;
    }

    public String calLeftTime(){
        String result = "";
        if(StringUtils.isNotBlank(overTime)){
            Date overDate = CommonUtil.formateDateToStr(overTime);
            result = String.valueOf(calendarService.getTimeLeft(overDate));
        }
        Struts2Utils.renderJson(result);
        return Action.NONE;
    }
}
