package com.gtis.web.action;

import com.opensymphony.xwork2.ActionSupport;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 14-2-13
 */
public class CacheAction extends ActionSupport {
    private static final long serialVersionUID = -5343627826716102143L;

    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public List<Statistics> getCaches() {
        List<Statistics> caches = new ArrayList<Statistics>();
        for (String cacheName : cacheManager.getCacheNames()) {
            caches.add(cacheManager.getCache(cacheName).getStatistics());
        }
        return caches;
    }

    public String clean() throws Exception {
        if ("all".equals(name)) {
            cacheManager.clearAll();
        } else {
            Cache cache = cacheManager.getCache(name);
            cache.removeAll();
        }
        return "toIndex";
    }
}
