package com.gtis.plat.wf.count;

import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.CountProvider;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.UserUtil;
import com.gtis.spring.Container;
import org.springframework.security.context.SecurityContextHolder;

import java.util.HashMap;

/**
 * 显示在主界面上的，代办人物数量
 * <p/>
 *
 * @author <a href="mailto:jibo1024@gmail.com">boji</a>
 * @version V1.0, ${Date}
 */
public class TaskCountImpl implements CountProvider {

    
    String name;


    /**
     * 获取待办任务个数，通过多个userid（可能存在代理任务）
     * 如果userid为空，就返回所有的任务，管理员用
     * @return
     */
    public int getCount() {
        SysWorkFlowInstanceDao workFlowInstanceDao = (SysWorkFlowInstanceDao) Container.getBean("SysWorkFlowInstanceDao");
		HashMap<String,String> map=new HashMap<String,String>();
        //设置userids
        UserUtil.setTaskUserMapIds(map);
		String count= workFlowInstanceDao.getTaskCount(map);
        if (!org.apache.commons.lang.StringUtils.isBlank(count))
            return Integer.parseInt(count);
        else
            return 0;
    }

    
    public String getName() {
        return name;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public void setName(String name) {
        this.name = name;
    }
}
