package com.gtis.plat.wf.bean;

import java.util.ArrayList;
import java.util.List;

import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import com.gtis.util.StaticParamHelper;
import org.apache.commons.lang.StringUtils;

public class WorkFlowTaskTurnInfoBean extends WorkFlowBeanAbstract {

	/**
	 * 工作流的初始化工作
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		try {
			String activityDefinitionId = infoObj.getSourceActivity()
					.getActivityDefinitionId();
			// 活动模型
			WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(infoObj.getWorkFlowIntanceVo());
//			WorkFlowXml workXml =this.getWorFlowInstanceService().getWorkflowInstanceXmlModel(infoObj.getWorkFlowIntanceVo());
			ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
			// 获取当前活动的转发类型
			String transType = activityModel.getSplitType();
			// 设置转发信息
			WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
			transInfo.setTransType(transType);
			transInfo.setCanFinish(activityModel.isCanFinish());
			infoObj.setTransInfo(transInfo);
			
			// 定义转发列表
			List<TransitionModel> lstTrans = activityModel.getTransitionsList();
			List<ActivityModel> tranActivitys = new ArrayList<ActivityModel>();
			for (TransitionModel transModel : lstTrans) {
				String nextActivityDefineId = transModel.getToId();
				ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
				// 根据模型获取所有参与者
				nextModel.setPerformerModelList(buildPerformerList(infoObj,
						nextModel));
				tranActivitys.add(nextModel);
			}
			transInfo.setTranActivitys(tranActivitys);
		} catch (Exception e) {
            if (e instanceof WorkFlowException)
                throw e;
            else
			    throw new WorkFlowException(
					WorkFlowException.ExceptionNum.StadusChange);
		}
		return true;
	}

	/**
	 * 根据模型设置获取所有的参与者
	 * 
	 * @param nextModel
	 * @return
	 */
	private List<PerformerTaskModel> buildPerformerList(WorkFlowInfo infoObj,
			ActivityModel nextModel) throws Exception{
		String startUserId = null;
		List<String> startOragnList = null;

        if(isFullWorkflow(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId())&&nextModel.isFilterDistrictCode()){
            startOragnList = getOrganListByDistrict(infoObj);
            if(startOragnList==null||startOragnList.size()==0)
                throw new WorkFlowException(
                        WorkFlowException.ExceptionNum.NoUsers);
        }else if (nextModel.isFilterStartUser())
			startUserId = infoObj.getWorkFlowIntanceVo().getCreateUser();
		else if (nextModel.isFilterStartGroup()) {
			startUserId = infoObj.getWorkFlowIntanceVo().getCreateUser();
			List<PfOrganVo> lstOrgan = this.getUserService()
					.getOrganListByUser(startUserId);
			startOragnList = new ArrayList<String>();
			for (PfOrganVo vo : lstOrgan) {
				startOragnList.add(vo.getOrganId());
			}
			startUserId = null;
		}else if (nextModel.isFilterTransferGroup()){
			List<PfOrganVo> lstOrgan = this.getUserService()
					.getOrganListByUser(infoObj.getUserId());
			startOragnList = new ArrayList<String>();
			for (PfOrganVo vo : lstOrgan) {
				startOragnList.add(vo.getOrganId());
			}
		} else if (nextModel.isFilterTransferPerformer()){
			startOragnList = new ArrayList<String>();
            if (infoObj.getSourceTask().getPerformerId()!=null)
                startOragnList.add(infoObj.getSourceTask().getPerformerId());
		} else if (nextModel.isFilterStartRegionCode()){
            startUserId = infoObj.getWorkFlowIntanceVo().getCreateUser();
            String regionCode = getUserService().getRegionCodeByUserId(startUserId);
            startOragnList = new ArrayList<String>();
            List<PfOrganVo> organList = getUserService().getOrganByRegionCode(regionCode);
            if (organList.size()>0){
                for (PfOrganVo vo : organList) {
                    startOragnList.add(vo.getOrganId());
                }
            }else{
                throw new WorkFlowException(
                        WorkFlowException.ExceptionNum.NoUsers);
            }
        }else if (nextModel.isFilterRegionCode()){
            String regionCode = infoObj.getWorkFlowIntanceVo().getRegionCode();
            if (StringUtils.isNotBlank(regionCode)){
                startOragnList = new ArrayList<String>();
                List<PfOrganVo> organList = getUserService().getOrganByRegionCode(regionCode);
                if (organList.size()>0){
                    for (PfOrganVo vo : organList) {
                        startOragnList.add(vo.getOrganId());
                    }
                }else{
                    throw new WorkFlowException(
							WorkFlowException.ExceptionNum.NoUsers);
                }
            }
        }else if (nextModel.isFilterDistrictCode()){
            startOragnList = getOrganListByDistrict(infoObj);
            if(startOragnList==null||startOragnList.size()==0)
                throw new WorkFlowException(
                        WorkFlowException.ExceptionNum.NoUsers);
        }
        
		List<PerformerTaskModel> performerTaskModelList = new ArrayList<PerformerTaskModel>();
		List<PerformerModel> performerList = nextModel.getPerformerList();
		for (PerformerModel pModel : performerList) {
			PerformerTaskModel pTaskModel = buildPerformer(infoObj, pModel,
					startUserId, startOragnList);
			if (pTaskModel != null && pTaskModel.getUserList().size()>0 ){
				performerTaskModelList.add(pTaskModel);
			}
		}

		if(performerTaskModelList.size()==0)
			throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);

		return performerTaskModelList;
	}

	/**
	 * 将performerModel对象转换为PerformerTaskModel
	 * 
	 * @param infoObj
	 * @param performerModel
	 * @param startUserId
	 * @param startOragnList
	 * @return
	 */
	private PerformerTaskModel buildPerformer(WorkFlowInfo infoObj,
			PerformerModel performerModel, String startUserId,
			List<String> startOragnList) {
		PerformerTaskModel result=new PerformerTaskModel();
		if (!performerModel.getUserId().equals("")) {// 参与者是人
			String userId = performerModel.getUserId();
			PfUserVo userVo = this.getUserService().getUserVo(userId);
			List<PfOrganVo> organs=this.getUserService().getOrganListByUser(userVo.getUserId());
			result.setName(organs.get(0).getOrganName());
			result.setId("0");
			result.getUserList().add(userVo);
            result.setType("User");
		} else if (!performerModel.getOrganId().equals("")) {// 参与者是部门
			List<PfUserVo> users = this.getUserService().getUserListByOragn(performerModel
					.getOrganId());
			PfOrganVo organVo=this.getUserService().getOrganVo(performerModel.getOrganId());
            if (organVo!=null){
                result.setName(organVo.getOrganName());
                result.setId(organVo.getOrganId());
                for(PfUserVo vo:users){
                    result.getUserList().add(vo);
                }
            }
			if (startOragnList!=null && startOragnList.size()>0) {
				if (!startOragnList.contains(performerModel
						.getOrganId()))
					result=new PerformerTaskModel();
			}
            result.setType("Organ");
		} else if (!performerModel.getRoleId().equals("")) {// 参与者是角色
			List<PfUserVo> users = this.getUserService().getUserListByRole(performerModel
					.getRoleId());
			PfRoleVo roleVo = this.getUserService().getRoleVo(performerModel
					.getRoleId());
			result.setName(roleVo.getRoleName());
			result.setId(roleVo.getRoleId());
			if (startOragnList!=null && startOragnList.size()>0){
				List<PfUserVo> userList= this.getUserService().getUserListByRoleAndOrganIds(roleVo.getRoleId(),startOragnList);
				for(PfUserVo vo:userList){
					result.getUserList().add(vo);
				}
			}else{
				for(PfUserVo vo:users){
					result.getUserList().add(vo);
				}
			}
            result.setType("Role");
		}
		
		//办理人员为流程的发起人
		List<PfUserVo> userList=new ArrayList<PfUserVo>();
		if (startUserId!=null && !startUserId.equals("")){
			for(PfUserVo vo:result.getUserList()){
				if (vo.getUserId().equals(startUserId))
					userList.add(vo);
			}
			if (userList.size()==0){
				PfUserVo userStart=this.getUserService().getUserVo(startUserId);;
				userList.add(userStart);
			}
			result.setUserList(userList);
		}
		
		return result;
	}

    private List<String> getOrganListByDistrict(WorkFlowInfo infoObj){
        List startOragnList=null;
        String district = infoObj.getWorkFlowIntanceVo().getDistrict();
        if (StringUtils.isNotBlank(district)){
            startOragnList = new ArrayList<String>();
            List<PfOrganVo> organList = getUserService().getOrganByRegionCode(district);
            if (organList.size()>0){
                for (PfOrganVo vo : organList) {
                    startOragnList.add(vo.getOrganId());
                }
            }else{
                throw new WorkFlowException(
                        WorkFlowException.ExceptionNum.NoUsers);
            }
        }
        return startOragnList;
    }


}
