package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;

import java.util.List;

public class WorkFlowRetrieveBean extends WorkFlowBeanAbstract {
	/**
	 * 取回下个活动没有办理的任务
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        PfTaskVo taskVoSource= this.getTaskService().getHistoryTask(infoObj.getSourceTask().getTaskId());
        PfActivityVo activityVoSource=this.getTaskService().getActivity(taskVoSource.getActivityId());
        PfWorkFlowInstanceVo workFlowInstanceVo= this.getWorFlowInstanceService().getWorkflowInstance(activityVoSource.getWorkflowInstanceId());
        infoObj.setWorkFlowDefineVo(this.getWorkFlowDefineService().getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId()));
        PfTaskVo hisTaskVo=this.getTaskService().getHistoryTask(infoObj.getSourceTask().getTaskId());
        if (hisTaskVo!=null){
            PfActivityVo sourceActivity=this.getTaskService().getActivity(hisTaskVo.getActivityId());
            PfWorkFlowInstanceVo sourceInstance=this.getWorFlowInstanceService().getWorkflowInstance(sourceActivity.getWorkflowInstanceId());
            if (sourceInstance.getWorkflowState()!=WorkFlowEnum.WORKFLOW_START){
                 throw new WorkFlowException(WorkFlowException.ExceptionNum.NoStart);    //不在活动状态
            }

            List<PfTaskVo> tasks=this.getTaskService().getTasksByBefore(infoObj.getSourceTask().getTaskId());
            //判断活动是否办结
            List<PfActivityVo> activityVos=this.getTaskService().getActivityByBefore(hisTaskVo.getActivityId());

            //对于自己退回的项目，无法找到后续活动，因此无法取回
            if(activityVos==null||activityVos.size()==0)
                throw new WorkFlowException(WorkFlowException.ExceptionNum.NoRetrieve);
            for(PfActivityVo activityVo :activityVos){
                if (activityVo.getActivityState()!=WorkFlowEnum.ACTIVITY_START){
                   throw new WorkFlowException(WorkFlowException.ExceptionNum.AlreadyHandle);
                }
            }
            //判断任务是否接受
            boolean isAccepted=false;
            for(PfTaskVo taskVo :tasks){
                if (taskVo.isAccepted()){
                   throw new WorkFlowException(WorkFlowException.ExceptionNum.AlreadyHandle);
                }
            }
            //删除原转发任务
            for(PfTaskVo taskVo :tasks){
                this.getTaskService().deleteTask(taskVo.getTaskId());
                List<PfTaskVo> tasksAlready=this.getTaskService().getTaskListByActivity(taskVo.getActivityId());
                if (tasksAlready==null || tasksAlready.size()==0)
                    this.getTaskService().deleteActivity(taskVo.getActivityId());
            }
            this.getTaskService().createTaskByHistroy(hisTaskVo.getTaskId());
            this.getTaskService().updateActivityStadus(hisTaskVo.getActivityId(), WorkFlowEnum.ACTIVITY_START);
            this.getTaskService().deleteHistoryTask(hisTaskVo.getTaskId());
        }
		return true;
	}


}