package com.gtis.plat.wf.bean;

import java.util.Date;

import com.gtis.config.AppConfig;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.SysExceptionService;
import com.gtis.plat.service.SysSupervisorService;
import com.gtis.plat.vo.EcExceptionVo;
import com.gtis.plat.vo.EcSupervisorVo;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.util.UUIDGenerator;
import com.gtis.web.SessionUtil;

public class EcLockWorkFlowInstanceBean extends WorkFlowBeanAbstract{
	private SysExceptionService exceptionService;
	private SysSupervisorService supervisorService;
	
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		//if(infoObj.getWorkFlowDefineVo().getIsMonitor() == 1){
        String taskId = infoObj.getSourceTask().getTaskId();
        PfTaskVo taskVo = this.getTaskService().getTask(taskId);
        PfActivityVo activity = getTaskService().getActivity(taskVo.getActivityId());
        if (activity!=null) {
            //异常信息封装
            EcExceptionVo lockException = new EcExceptionVo();
            lockException.hold_exception(UUIDGenerator.generate(), activity.getWorkflowInstanceId(), activity.getActivityId(), SessionUtil.getUserId(ServletActionContext.getRequest()), activity.getOrganId(), null, 1, null, null);
            exceptionService.saveException(lockException);

            if (AppConfig.getBooleanProperty("exception.supervise.enable", false)) {
                //督办信息封装
                EcSupervisorVo lockSupervisorVo = new EcSupervisorVo();
                lockSupervisorVo.setSupervisorInfoId(UUIDGenerator.generate());
                lockSupervisorVo.setExceptionId(lockException.getExceptionId());
                lockSupervisorVo.setSupervisorUserId(infoObj.getUserId());
                lockSupervisorVo.setTargetType(EcSupervisorVo.ACTIVITY_TYPE);
                lockSupervisorVo.setWorkflowInstanceId(activity.getWorkflowInstanceId());
                lockSupervisorVo.setActivityId(activity.getActivityId());
                lockSupervisorVo.setTargetId(SessionUtil.getUserId(ServletActionContext.getRequest()));
                lockSupervisorVo.setSupervisorTime(new Date(System.currentTimeMillis()));
                supervisorService.saveEcSupervisorVo(lockSupervisorVo);
            }
        }
		//}
		return true;
	}
	
	public SysSupervisorService getSupervisorService() {
		return supervisorService;
	}

	public void setSupervisorService(SysSupervisorService supervisorService) {
		this.supervisorService = supervisorService;
	}

	public SysExceptionService getExceptionService() {
		return exceptionService;
	}

	public void setExceptionService(SysExceptionService exceptionService) {
		this.exceptionService = exceptionService;
	}
}
