package com.gtis.plat.wf.bean;

import java.util.List;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowInfo;

public class DeleteWorkFlowInstanceBean extends WorkFlowBeanAbstract {

	/**
	 * 刪除工作流
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		String workflowIntanceId = infoObj.getWorkFlowIntanceVo()
				.getWorkflowIntanceId();
		List<PfActivityVo> activityList = super.getTaskService()
				.getWorkFlowInstanceAllActivityList(workflowIntanceId);

		if (activityList.size() > 0) {
			// 删除活动下的任务
			for (PfActivityVo activity : activityList) {
				String activityId = activity.getActivityId();
				// 删除历史任务
				super.getTaskService()
						.deleteHistoryTaskByActivityId(activityId);
				super.getTaskService().deleteActivityTask(activityId);
			}
		}
		
		//删除活动
		super.getTaskService().deleteWorkFlowInstanceActivity(
				workflowIntanceId);
		//删除流程实例
		super.getWorFlowInstanceService().deleteWorkFlowIntance(
				workflowIntanceId);
		return true;
	}
}
