package com.gtis.plat.wf.bean;

import java.util.ArrayList;
import java.util.List;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysWorkFlowDefineDao;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.spring.Container;
import com.gtis.util.StaticParamHelper;
import org.apache.commons.lang.StringUtils;

public class CreateWorkFlowBean extends WorkFlowBeanAbstract {

	/**
	 * 创建工作流
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		// 获取模型
		WorkFlowXml xmlDao =WorkFlowXmlUtil.getDefineModel(infoObj.getWorkFlowDefineVo());
		// 获取首活动
		String activityDefinitionId = xmlDao.getBeginActivityDefine();
		// 获取首活动定义
		ActivityModel activityModel = xmlDao.getActivity(activityDefinitionId);
		PfActivityVo activityVo = WorkFlowBeanUtil.createActivityVoByModel(activityModel);
		String activityId = UUIDGenerator.generate();
		activityVo.setActivityId(activityId);
		activityVo.setWorkflowInstanceId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId());
		List<PfActivityVo> targetActivitys = new ArrayList<PfActivityVo>();
		targetActivitys.add(activityVo);
		infoObj.setTargetActivitys(targetActivitys);
		// 获取参与者
		List<String> lstUserIds = new ArrayList<String>();
		List<PerformerModel> lstPerformers = activityModel.getPerformerList();
		if (lstPerformers.size() == 0)
			throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);

        //专为四全服务平台修改，即在四全服务大流程的情况下优先使用District代码过滤
        if(isFullWorkflow(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId())&&activityModel.isFilterDistrictCode()){
            String district = infoObj.getWorkFlowIntanceVo().getDistrict();
            if (StringUtils.isNotBlank(district)){
                lstUserIds = this.getUserService().getUserListPerformersByDistrict(lstPerformers, district);
            }
        }else if (activityModel.isFilterStartUser()) { // 只创建当前用户
			lstUserIds.add(infoObj.getUserId());
		} else if (activityModel.isFilterStartGroup()) { // 和创建人在一个部门
			lstUserIds = this.getUserService().getUserListPerformersByUserOrgan(lstPerformers, infoObj.getUserId());
		}else if(activityModel.isFilterDistrictCode()){ //工作流项目所在区域内的用户
            String district = infoObj.getWorkFlowIntanceVo().getDistrict();
            if (StringUtils.isNotBlank(district)){
                lstUserIds = this.getUserService().getUserListPerformersByDistrict(lstPerformers, district);
            }
        } else {
			// 所有参与者
			lstUserIds = this.getUserService().getAllUserListPerformers(lstPerformers);
		}
		if (lstUserIds.size() == 0)
			throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
		// 创建任务
		List<PfTaskVo> targetTasks = new ArrayList<PfTaskVo>();
		for (String userId : lstUserIds) {
			PfTaskVo taskVo = createTaskVo(activityId);
			taskVo.setUserVo(createUserVo(userId));
			targetTasks.add(taskVo);
		}
		infoObj.setTargetTasks(targetTasks);
		return true;
	}

	private PfUserVo createUserVo(String userId) {
		PfUserVo userVo = new PfUserVo();
		userVo.setUserId(userId);
		return userVo;
	}

	private PfTaskVo createTaskVo(String activityId) {
		PfTaskVo taskVo = new PfTaskVo();
		String taskId = UUIDGenerator.generate();
		taskVo.setTaskId(taskId);
		taskVo.setActivityId(activityId);
		return taskVo;
	}
}
