package com.gtis.plat.wf;

import java.util.HashMap;
import java.util.LinkedHashMap;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;

public class WorkFlowXmlUtil {
//	static int MAPMAXSIZE = 100;
//	static HashMap<String, WorkFlowXml> workFlowDefineMap = new HashMap<String, WorkFlowXml>();
//	static LinkedHashMap<String, WorkFlowXml> workFlowInstanceMap = new LinkedHashMap<String, WorkFlowXml>(
//			100);
	SysWorkFlowInstanceService worFlowInstanceService;
	SysWorkFlowDefineService workFlowDefineService;

	public SysWorkFlowInstanceService getWorFlowInstanceService() {
		return worFlowInstanceService;
	}

	public void setWorFlowInstanceService(
			SysWorkFlowInstanceService worFlowInstanceService) {
		this.worFlowInstanceService = worFlowInstanceService;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public WorkFlowXml getWorkFlowDefineModel(PfWorkFlowDefineVo defineVo) {
//		WorkFlowXml modelXml = workFlowDefineMap.get(defineVo
//				.getWorkflowDefinitionId());
//		if (modelXml != null) {
//
//			if (modelXml.getModifyDate() != null
//					&& !modelXml.getModifyDate().equals(
//							defineVo.getModifyDate()))
//				modelXml = null;
//		}
//		if (modelXml == null) {
			String xml = workFlowDefineService.getWorkFlowDefineXml(defineVo);
            WorkFlowXml modelXml = new WorkFlowXml(xml);
			modelXml.setModifyDate(defineVo.getModifyDate());
//			workFlowDefineMap.put(defineVo.getWorkflowDefinitionId(), modelXml);
//		}
//		return modelXml;
        return modelXml;
	}

	public WorkFlowXml getWorkFlowInstanceModel(PfWorkFlowInstanceVo instanceVo) {
//		WorkFlowXml modelXml = workFlowInstanceMap.get(instanceVo
//				.getWorkflowIntanceId());
//		if (modelXml != null) {
//			if (modelXml.getModifyDate() != null
//					&& !modelXml.getModifyDate().equals(
//							instanceVo.getModifyDate()))
//				modelXml = null;
//		}
//		if (modelXml == null) {
//			if (workFlowInstanceMap.size() > MAPMAXSIZE) {
//				synchronized (workFlowInstanceMap) {
//					workFlowInstanceMap.remove(workFlowInstanceMap.keySet()
//							.iterator().next().toString());
//				}
//			}
			String xml = worFlowInstanceService
					.getWorkflowInstanceXml(instanceVo);
            WorkFlowXml modelXml = new WorkFlowXml(xml);
			modelXml.setModifyDate(instanceVo.getModifyDate());
//			workFlowInstanceMap
//					.put(instanceVo.getWorkflowIntanceId(), modelXml);
//		}
		return modelXml;
	}
	
	public void updateGobalValByProId(String proId, String valName,
			String val) {
		PfWorkFlowInstanceVo vo=worFlowInstanceService.getWorkflowInstanceByProId(proId);
		updateGobalVal(vo.getWorkflowIntanceId(),valName,val);
	}

	public HashMap<String, Object> getGobalValByProId(String proId) {
		PfWorkFlowInstanceVo vo=worFlowInstanceService.getWorkflowInstanceByProId(proId);
        if (vo!=null)
		    return getGobalVal(vo.getWorkflowIntanceId());
        else
            return new HashMap<String, Object>();
	}
	
	public void updateGobalVal(String workflowIntanceId, String valName,
			String val) {
		worFlowInstanceService.updateGobalVal(workflowIntanceId, valName, val);
	}

	public HashMap<String, Object> getGobalVal(String workflowIntanceId) {
		return worFlowInstanceService.getGobalVal(workflowIntanceId);
	}

	public static WorkFlowXml getDefineModel(PfWorkFlowDefineVo defineVo) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
				.getBean("WorkFlowXmlUtil");
		return factory.getWorkFlowDefineModel(defineVo);
	}

	public static WorkFlowXml getInstanceModel(PfWorkFlowInstanceVo instanceVo) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
				.getBean("WorkFlowXmlUtil");
		return factory.getWorkFlowInstanceModel(instanceVo);
	}
	
	
	
	public static void updateGobalVals(String workflowIntanceId, String valName,
			String val) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
		.getBean("WorkFlowXmlUtil");
		factory.updateGobalVal(workflowIntanceId,valName,val);
	}
	
	public static HashMap<String, Object> getGobalVals(String workflowIntanceId) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container.getBean("WorkFlowXmlUtil");
		return factory.getGobalVal(workflowIntanceId);
	}
	
	public static void updateGobalValsByProId(String proId, String valName,
			String val) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
		.getBean("WorkFlowXmlUtil");
		factory.updateGobalValByProId(proId,valName,val);
	}
	
	public static HashMap<String, Object> getGobalValsByProId(String proId) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
		.getBean("WorkFlowXmlUtil");
		return factory.getGobalValByProId(proId);
	}
}
