package com.gtis.plat.wf;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 将一个流程的任务列表排序
 * 按照TASK_BEFORE，排为：
 * 1
 * 2
 * 3
 * 2
 * 3
 * 4
 */
public class WorkFlowChartServiceImpl {
    SysWorkFlowInstanceService worFlowInstanceService;
    SysTaskService taskService;

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setWorFlowInstanceService(SysWorkFlowInstanceService worFlowInstanceService) {
        this.worFlowInstanceService = worFlowInstanceService;
    }

    public ActivityTask buildFirstTask(String workflowIntanceId){
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo=
                worFlowInstanceService.getWorkflowInstance(workflowIntanceId);
        WorkFlowXml xmlDao =WorkFlowXmlUtil.getInstanceModel(pfWorkFlowInstanceVo);
        String  beginActivityId=xmlDao.getBeginActivityDefine();
        PfActivityVo firstActivity=
                taskService.getActivityBywIdandadId(workflowIntanceId,beginActivityId);
        List<PfTaskVo> taskVos=taskService.getTaskListByActivity(firstActivity.getActivityId());
        List<PfTaskVo> taskHistoryVos=taskService.getHistoryTasks(firstActivity.getActivityId());

        ActivityTask activityTask=new ActivityTask(firstActivity);
        if (taskVos!=null){
            //正在办理的
            for(PfTaskVo task:taskVos){
                if (StringUtils.isBlank(task.getTaskBefore())){
                    activityTask.addTask(task);
                }
            }
        }
        if (taskHistoryVos!=null){
            //历史的任务
            for(PfTaskVo task:taskHistoryVos){
                if (StringUtils.isBlank(task.getTaskBefore())){
                    activityTask.addTask(task);
                }
            }
        }
        return activityTask;
    }

    /**
     * 后面的活动及任务
     * @param activityTask
     * @return
     */
    public List<ActivityTask> getNextActivityTask(ActivityTask activityTask){
        List<ActivityTask> activityTasks=new ArrayList<ActivityTask>();
        List<String> taskIds= activityTask.getTaskIds();
        List<PfTaskVo> tasks=
                taskService.getTaskListByInstance(activityTask.getActivityVo().getWorkflowInstanceId());
        List<PfTaskVo> hisoryTasks=
                taskService.getHistoryTaskListByInstance(activityTask.getActivityVo().getWorkflowInstanceId());
        tasks.addAll(hisoryTasks);

        for(PfTaskVo task:tasks){
            if (StringUtils.isNotBlank(task.getTaskBefore())){
                String[] beforeIds=task.getTaskBefore().split(",");
                for(String beforeId:beforeIds){
                    if (taskIds.contains(beforeId)){
                        buildActivitys(activityTasks,task);
                    }
                }
            }
        }
        return activityTasks;
    }

    private void buildActivitys(List<ActivityTask> activityTasks,PfTaskVo task){
        ActivityTask activityTaskNext=null;
        PfActivityVo activityVo=taskService.getActivity(task.getActivityId());
        if (activityTasks.size()==0){
            activityTaskNext=new ActivityTask(activityVo);
            activityTasks.add(activityTaskNext);
        }else{
            activityTaskNext=getActivityTask(activityTasks,task.getActivityId());
            if (activityTaskNext==null){
                activityTaskNext=new ActivityTask(activityVo);
                activityTasks.add(activityTaskNext);
            }
        }
        activityTaskNext.addTask(task);
    }

    private ActivityTask getActivityTask(List<ActivityTask> activityTasks,String activityId){
        if (activityTasks!=null){
            for (ActivityTask activityTask:activityTasks){
                if (activityTask.getActivityVo().getActivityId().equals(activityId))
                    return activityTask;
            }
        }
        return null;
    }
}
