package com.gtis.plat.service.impl.search;

import com.gtis.plat.datasource.BusinessDataSource;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.search.*;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-11
 */
public class WorkFlowCategoryFactory extends DefaultCategoryFactory {
    private SysMenuService sysMenuService;
    private SysWorkFlowDefineService sysWorkFlowDefineService;

    public void setSysMenuService(SysMenuService sysMenuService) {
        this.sysMenuService = sysMenuService;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService sysWorkFlowDefineService) {
        this.sysWorkFlowDefineService = sysWorkFlowDefineService;
    }

    @Override
    protected void prepareCategory(Business business, final Category category) {
        super.prepareCategory(business, category);
        List<String> ids = sysMenuService.getWorkFlowDefineRoleIds(category.getId());
        category.setRoleIds(ids.toArray(new String[ids.size()]));
    }

    @Override
    protected void prepareDataFetcher(Business business, final Category category, final DataFetcher dataFetcher) {
        super.prepareDataFetcher(business, category, dataFetcher);
        if (dataFetcher instanceof DatabaseDataFetcher) {
            DatabaseDataFetcher ddf = (DatabaseDataFetcher) dataFetcher;
            if (!ddf.hasDataSource()) {
                ddf.setDataSource(BusinessDataSource.getDataSourceByBusiness(sysWorkFlowDefineService.getBusiness(business.getId())));
            }
        }
    }
}
