package com.gtis.plat.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysWorkFlowPostDao;
import com.gtis.plat.service.SysWorkFlowPostService;
import com.gtis.plat.vo.PfWorkFlowPostVo;

import java.util.List;

/**
 * User: JIFF
 * Date: 2014/10/28
 */
public class SysWorkFlowPostServiceImpl implements SysWorkFlowPostService {

    SysWorkFlowPostDao workFlowPostDao;

    public void setWorkFlowPostDao(SysWorkFlowPostDao workFlowPostDao) {
        this.workFlowPostDao = workFlowPostDao;
    }

    @Override
    public void updatePost(PfWorkFlowPostVo workFlowPostVo) {
        workFlowPostDao.updatePost(workFlowPostVo);
    }

    @Override
    public PfWorkFlowPostVo getPost(String postId) {
        return workFlowPostDao.getPost(postId);
    }

    @Override
    public List<PfWorkFlowPostVo> getPostByTask(String taskId) {
        return workFlowPostDao.getPostByTask(taskId);
    }

    @Override
    public List<PfWorkFlowPostVo> getPostByInstance(String instanceId) {
        return workFlowPostDao.getPostByInstance(instanceId);
    }

    @Override
    public String createPost(PfWorkFlowPostVo workFlowPostVo) {
        String postId= UUIDGenerator.generate();
        workFlowPostVo.setPostId(postId);
        workFlowPostDao.createPost(workFlowPostVo);
        return postId;
    }
}
