package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Transactional(readOnly = true)
public class SysWorkFlowInstanceServiceImpl implements
        SysWorkFlowInstanceService {

    private static final Logger logger = LoggerFactory.getLogger(SysWorkFlowInstanceServiceImpl.class);

    private SysWorkFlowInstanceDao workFlowInstanceDao;

    private SysWorkFlowDefineService workFlowDefineService;

    private Map<String, String> workFlowDetailServerUrlMap;

    private static HttpClient httpClient;

    SysCalendarService sysCalendarService;

    static {
        HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
        connectionManager.getParams().setConnectionTimeout(10000);
        connectionManager.getParams().setSoTimeout(10000);
        httpClient = new HttpClient(connectionManager);
    }

    public void setSysCalendarService(SysCalendarService sysCalendarService) {
        this.sysCalendarService = sysCalendarService;
    }

    public SysWorkFlowInstanceDao getWorkFlowInstanceDao() {
        return workFlowInstanceDao;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public void setWorkFlowDetailServerUrlMap(Map<String, String> workFlowDetailServerUrlMap) {
        this.workFlowDetailServerUrlMap = workFlowDetailServerUrlMap;
    }

    public void setWorkFlowInstanceDao(
            SysWorkFlowInstanceDao workFlowInstanceDao) {
        this.workFlowInstanceDao = workFlowInstanceDao;
    }

    public HashMap<String, Object> getGobalVal(String workflowIntanceId) {
        String vals = this.workFlowInstanceDao.getWorkFlowVals(workflowIntanceId);
        if (vals != null && !vals.equals("")) {
            try {
                return (HashMap<String, Object>) JSONUtil.deserialize(vals);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return null;
    }

    @Transactional
    public void updateGobalVal(String workflowIntanceId, String valName, Object val) {
        HashMap<String, Object> mapVals = getGobalVal(workflowIntanceId);
        if (mapVals == null) mapVals = new HashMap<String, Object>();
        mapVals.put(valName, val);
        try {
            String jsonVals = JSONUtil.serialize(mapVals);
            this.workFlowInstanceDao.updateWorkFlowVals(workflowIntanceId, jsonVals);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
      * (non-Javadoc)
      *
      * @see
      * com.gtis.plat.service.SysWorkFlowInstanceService#getWorkflowInstanceXml
      * (java.lang.String)
      */
    public String getWorkflowInstanceXml(String workflowIntanceId) {
        return workFlowInstanceDao.getWorkflowInstanceXml(workflowIntanceId);
    }

    /*
      * (non-Javadoc)
      *
      * @see
      * com.gtis.plat.service.SysWorkFlowInstanceService#getWorkflowInstanceXmlModel
      * (com.gtis.plat.vo.PfWorkFlowInstanceVo)
      */

    public String getWorkflowInstanceXml(PfWorkFlowInstanceVo intanceVo) {
        return this.getWorkflowInstanceXml(intanceVo.getWorkflowIntanceId());
//        String instanceXml = workFlowInstanceDao
//                .getWorkflowInstanceXml(intanceVo.getWorkflowIntanceId());
//        return instanceXml;
    }

    /*
      * (non-Javadoc)
      *
      * @see
      * com.gtis.plat.service.SysWorkFlowInstanceService#createWorkFlowIntance
      * (com.gtis.plat.vo.PfWorkFlowInstanceVo)
      */

    @Transactional
    public void createWorkFlowIntance(PfWorkFlowInstanceVo intanceVo) {
        //开始时间
        Date beginDate=Calendar.getInstance().getTime();
        intanceVo.setCreateTime(beginDate);
        //计算截至时间
        intanceVo.setOverTime(sysCalendarService.getOverTime(beginDate,intanceVo.getTimeLimit()));
        workFlowInstanceDao.createWorkFlowIntance(intanceVo);
    }

    /*
      * (non-Javadoc)
      *
      * @see
      * com.gtis.plat.service.SysWorkFlowInstanceService#getWorkflowInstance(
      * java.lang.String)
      */

    public PfWorkFlowInstanceVo getWorkflowInstance(String workflowIntanceId) {
        return workFlowInstanceDao.getWorkflowInstance(workflowIntanceId);
    }

    /*
      * (non-Javadoc)
      *
      * @see
      * com.gtis.plat.service.SysWorkFlowInstanceService#updateWorkFlowIntanceStadus
      * (com.gtis.plat.vo.PfWorkFlowInstanceVo)
      */

    @Transactional
    public void updateWorkFlowIntanceStadus(PfWorkFlowInstanceVo intanceVo) {
        workFlowInstanceDao.updateWorkFlowIntanceStadus(intanceVo);
    }


    @Transactional
    public void updateWorkFlowInstanceRemark(PfWorkFlowInstanceVo intanceVo) {
        workFlowInstanceDao.updateWorkFlowInstanceRemark(intanceVo);
    }

    @Transactional
    public void updateWorkFlowIntanceOverTime(String wiid,Date overTime){
        workFlowInstanceDao.updateWorkFlowInstanceOverTime(wiid,overTime);
    }


     /*
      * (non-Javadoc)
      *
      * @see
      * com.gtis.plat.service.SysWorkFlowInstanceService#deleteWorkFlowIntance
      * (java.lang.String)
      */

    @Caching(evict={
            @CacheEvict(value="WorkFlowInstanceCache",key = "#workflowIntanceId + 'WorkflowInstanceXmlById'")
    })
    @Transactional
    public void deleteWorkFlowIntance(String workflowIntanceId) {
        workFlowInstanceDao.deleteWorkFlowIntance(workflowIntanceId);
    }

    @Transactional
    public void updateWorkFlowIntanceName(PfWorkFlowInstanceVo intanceVo) {
        workFlowInstanceDao.updateWorkFlowIntanceName(intanceVo);
    }

    public PfWorkFlowInstanceVo getWorkflowInstanceByProId(String proId) {
        return workFlowInstanceDao.getWorkflowInstanceByProId(proId);
    }

    public String getTaskCount(HashMap<String, String> map) {
        return workFlowInstanceDao.getTaskCount(map);
    }

    private String parseWorkFlowVo(PfWorkFlowInstanceVo wfi) {
        //将vo变成xml传出
        XStream xstream = new XStream(new DomDriver());
        xstream.alias("WorkFlowInstance", PfWorkFlowInstanceVo.class);
        String xml = xstream.toXML(wfi);
        return xml;
    }

    public String getWorkFlowInstanceDetailXml(String workflowIntanceId) {
        PfWorkFlowInstanceVo wfi = getWorkflowInstance(workflowIntanceId);
        PfWorkFlowDefineVo wfd = workFlowDefineService.getWorkFlowDefine(wfi.getWorkflowDefinitionId());
        PfBusinessVo business = workFlowDefineService.getBusiness(wfd.getBusinessId());
        String url = workFlowDetailServerUrlMap.get(StringUtils.isNotBlank(business.getBusinessCode()) ? business.getBusinessCode() : "system");
        if (StringUtils.isBlank(url)) {
            String xml = parseWorkFlowVo(wfi);
            logger.info("--getWorkFlowInstanceDetailXml------" + xml);
            return xml;
        }
        String detailUri = wfd.getDetailUrl();
        if (detailUri == null)
            detailUri = "workFlowDetail.action";
        GetMethod get = new GetMethod(url +
                (url.endsWith("/") ? "" : "/") + detailUri +
                (detailUri.indexOf("?") > -1 ? "&" : '?') +
                "id=" + wfi.getProId());
        try {
            httpClient.executeMethod(get);
            if (get.getStatusCode() == HttpStatus.SC_OK) {
                logger.info("--getWorkFlowInstanceDetailXml------" + get.getResponseBodyAsString());
                return get.getResponseBodyAsString();
            }
        } catch (Exception e) {
            logger.error("get workFlowInstance:[{}] xml detail error,detail:[{}]", workflowIntanceId, e);
        }
        logger.error("get workFlowInstance:[{}] xml detail error", workflowIntanceId);
        return null;
    }

    /**
     * 统计全部待办任务信息，返回map对象，key是用户ID,value是超期任务数目。
     *
     * @param paraMap 可以写入查询的起始日期和结束日期
     * @return
     */
    public Map<String, Integer> statTaskCountMap(HashMap<String, String> paraMap) {
        return workFlowInstanceDao.statTaskCountMap(paraMap);
    }

    /**
     * 统计指定工作流的活动
     *
     * @param wiid
     * @return
     */
    public int statTaskCountByWiid(String wiid) {
        return workFlowInstanceDao.statTaskCountByWiid(wiid);
    }

    public PfUserVo getWorkFlowLastUser(String wiid) {
        return workFlowInstanceDao.getWorkFlowLastUser(wiid);
    }

    public List<PfWorkFlowInstanceVo> getWorkFlowsInstanceByDefine(String wdId, int state) {
        return workFlowInstanceDao.getWorkFlowsInstanceByDefine(wdId, state);
    }

    @Transactional
    public void UpdateWorkFlowInstanceMonitor(String wiid,String monitorId){
        workFlowInstanceDao.UpdateWorkFlowInstanceMonitor(wiid, monitorId);
    }

    /**
     * 更新工作流紧急程度
     * @param wiid
     * @param priority
     */
    public void updateWorkFlowIntancePriority(String wiid,String priority){
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo=new PfWorkFlowInstanceVo();
        pfWorkFlowInstanceVo.setPriority(priority);
        pfWorkFlowInstanceVo.setWorkflowIntanceId(wiid);
        workFlowInstanceDao.updateWorkFlowIntancePriority(pfWorkFlowInstanceVo);
    }

    /**
     * 工作流统计
     * @param map
     * @return
     */
    public List<HashMap> getWorkflowStatusList(HashMap<String,String> map){
       return workFlowInstanceDao.getWorkflowStatusList(map);
    }
}
