package com.gtis.plat.service.impl;

import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.service.SysUserRandomCheck;
import com.gtis.plat.vo.PfUserVo;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Random;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 12-2-21
 * Time: 下午8:20
 * To change this template use File | Settings | File Templates.
 */
public class SysUserRandomCheckImpl implements SysUserRandomCheck {

    private static HashMap<String,String> mapRandom=new HashMap<String, String>();
    private SysSmsService smsService;
    private SysUserServiceImpl userService;

    public void setSmsService(SysSmsService smsService) {
        this.smsService = smsService;
    }

    public void setUserService(SysUserServiceImpl userService) {
        this.userService = userService;
    }

    /**
     * 发送短信验证码
     * @param userId
     */
    public String sendRandom(String userId) throws Exception{
        String code=generateRandomNum();
        mapRandom.put(userId,code);
        PfUserVo userVo=userService.getUserVo(userId);
        if (userVo!=null){
            smsService.sendMsg("","",userVo.getMobilePhone(),userVo.getUserName() + ",欢迎使用移动办公系统，您本次登录系统的验证码为："+code);
        }
        return code;
    }

    /**
     * 检查验证码是否正确
     * @param userId
     * @param code
     * @return
     */
    public boolean checkRandom(String userId,String code){
        if (StringUtils.isNotBlank(code) &&  code.equals(mapRandom.get(userId))){
            return true;
        }else{
            return false;
        }
    }
    
    /**
     * 生成一个随机数
     * @return
     */
    public static String generateRandomNum(){
        String code="";
        Random random = new Random();
        for (int i = 0; i < 4; i++) {
            String rand = String.valueOf(random.nextInt(10));
            code += rand;
        }
        return code;
    }

    public static void main(String[] param) {
        System.out.println(generateRandomNum());
        System.out.println(generateRandomNum());
        System.out.println(generateRandomNum());
        System.out.println(generateRandomNum());
    }
}
