package com.gtis.plat.service.impl;

import com.google.common.collect.Maps;
import com.gtis.plat.dao.SysTaskDao;
import com.gtis.plat.dao.SysTaskHistoryDao;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.WorkFlowEnum;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Transactional(readOnly = true)
public class SysTaskServiceImpl implements SysTaskService {

    SysTaskDao taskDao;

    SysTaskHistoryDao taskHistoryDao;
    SysCalendarService sysCalendarService;
    SysActivityService activityService;


    public void setActivityService(SysActivityService activityService) {
        this.activityService = activityService;
    }

    public void setSysCalendarService(SysCalendarService sysCalendarService) {
        this.sysCalendarService = sysCalendarService;
    }

    public SysTaskHistoryDao getTaskHistoryDao() {
        return taskHistoryDao;
    }

    public void setTaskHistoryDao(SysTaskHistoryDao taskHistoryDao) {
        this.taskHistoryDao = taskHistoryDao;
    }

    @Transactional
    public void createActivity(PfActivityVo activityVo) {
        // /避免创建相同的活动
        PfActivityVo aVo = taskDao.getActivityBywIdandadId(activityVo
                .getWorkflowInstanceId(), activityVo.getActivityDefinitionId());
        if (aVo == null) {
            activityVo.setBeginTime(Calendar.getInstance().getTime());
            taskDao.createActivity(activityVo);
        } else {
            this.updateActivityStadus(activityVo.getActivityId(),
                    activityVo.getActivityState());
        }
    }

    @Transactional
    public void createTask(PfTaskVo taskVo) {
        // 不要创建重复的任务
        List<PfTaskVo> lstTasks = taskDao.getTaskListByUserIdAndActivity(taskVo
                .getActivityId(), taskVo.getUserVo().getUserId());
        if (lstTasks == null || lstTasks.size() == 0) {
            Date beginDate = Calendar.getInstance().getTime();
            if (taskVo.getBeginTime()==null) {
                taskVo.setBeginTime(beginDate);
            }
            if (taskVo.getOverTime()==null) {
                //获得截至时间
                PfActivityVo activityVo = activityService.getActivityById(taskVo.getActivityId());
                if(activityVo!=null)
                    taskVo.setOverTime(sysCalendarService.getOverTime(beginDate, activityVo.getTimeLimit()));
            }
            taskDao.createTask(taskVo);
        } else {
            /////这里需要更新taskbefore
            if (!StringUtils.isBlank(taskVo.getTaskBefore())) {
                for (PfTaskVo aTask : lstTasks) {
                    taskDao.updateTasksByBefore(aTask.getTaskId(), taskVo.getTaskBefore());
                    //更新截至时间
                    PfActivityVo activityVo = activityService.getActivityById(aTask.getActivityId());
                    if(activityVo!=null&&aTask.getOverTime()==null)
                        taskDao.updateTaskOverTime(aTask.getTaskId(),sysCalendarService.getOverTime(aTask.getBeginTime(), activityVo.getTimeLimit()));
                }
            }
        }
    }

    /**
     * 批量创建任务
     *
     * @param tasklist
     */
    @Transactional
    public void createTasks(final List<PfTaskVo> tasklist) {
        for (PfTaskVo taskVo : tasklist) {
            this.createTask(taskVo);
        }
//		taskDao.createTasks(tasklist);
    }

    public List<PfActivityVo> getActivityByBefore(
            String activityId) {
        return this.taskDao.getActivityByBefore(activityId);
    }

    /**
     * 更新历史任务
     */
    @Transactional
    public void updateHistoryTask(PfTaskVo taskVo) {
        this.taskHistoryDao.updateTaskHistory(taskVo);
    }

    @Transactional
    public void updateTaskHistoryOverTime(String taskId,Date overTime) {
        this.taskHistoryDao.updateTaskHistoryOverTime(taskId,overTime);
    }



    @Transactional
    public void deleteActivityTask(String activityId) {
        taskDao.deleteActivityTask(activityId);
    }

    @Transactional
    public void deleteTask(String taskId) {
        taskDao.deleteTask(taskId);
    }

    @Transactional
    public void updateTaskOverTime(String taskId,Date overTime){
        taskDao.updateTaskOverTime(taskId,overTime);
    }

    public PfActivityVo getActivity(String activityId) {
        return taskDao.getActivity(activityId);
    }

    public PfActivityVo getActivityBywIdandadId(String workflowInstanceId,
                                                String activityDefinitionId) {
        return taskDao.getActivityBywIdandadId(workflowInstanceId,
                activityDefinitionId);
    }

    public List<PfTaskVo> getTaskListByActivity(String activityId) {
        return taskDao.getTaskListByActivity(activityId);
    }

    public List<PfTaskVo> getHistoryTasks(String activityId) {
        return taskHistoryDao.getHistoryTasksListByActivity(activityId);
    }

    public int getAllTaskCountByActivityId(String activityId){
        return taskDao.getAllTaskCountByActivityId(activityId);
    }

    public PfTaskVo getTask(String taskId) {
        return taskDao.getTask(taskId);
    }

    public PfTaskVo getTaskAll(String taskId) {
        return taskDao.getTaskAll(taskId);
    }

    public List<PfActivityVo> getWorkFlowInstanceActivityList(
            String workflowInstanceId) {
        return taskDao.getWorkFlowInstanceActivityList(workflowInstanceId);
    }

    @Transactional
    public void insertTaskHistory(String taskId) {
        PfTaskVo taskVo=taskDao.getTask(taskId);
        if (taskVo!=null) {
            taskVo.setFinishTime(Calendar.getInstance().getTime());
            taskHistoryDao.insertTaskHistory(taskVo);
        }
    }

    @Transactional
    public void updateActivityBackStadus(String activityId, boolean isBack) {
        if (isBack)
            taskDao.updateActivityBack(activityId);
        else
            taskDao.updateActivityForword(activityId);
    }

    @Transactional
    public void updateActivityRemark(String activityId, String remark) {
        taskDao.updateActivityRemark(activityId, remark);
    }

    /**
     * 更新活动状态
     *
     * @param activityId
     * @param stadus
     */
    @Transactional
    public void updateActivityStadus(String activityId, int stadus) {
        PfActivityVo activityVo = new PfActivityVo();
        activityVo.setActivityId(activityId);
        switch (stadus) {
            case WorkFlowEnum.ACTIVITY_START:
                activityVo.setBeginTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(WorkFlowEnum.ACTIVITY_START);
                break;
            case WorkFlowEnum.ACTIVITY_END:
                activityVo.setFinishTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(WorkFlowEnum.ACTIVITY_END);
                break;
            case WorkFlowEnum.ACTIVITY_BACK:
                activityVo.setFinishTime(Calendar.getInstance().getTime());
                activityVo.setActivityState(WorkFlowEnum.ACTIVITY_BACK);
                break;
            default:
                activityVo.setActivityState(stadus);
                break;
        }
        taskDao.updateActivityStadus(activityVo);
    }

    @Transactional
    public void updateActivityHandlesDay(String activityId, int handlesDay) {
        PfActivityVo activityVo = new PfActivityVo();
        activityVo.setActivityId(activityId);
        activityVo.setHandlesDay(handlesDay);
        taskDao.updateActivityHandlesDay(activityVo);
    }
    @Transactional
    public void updateCooperateStateDown(String activityId) {
        taskDao.updateCooperateStateDown(activityId);
    }

    @Transactional
    public void updateCooperateStateUp(String activityId) {
        taskDao.updateCooperateStateUp(activityId);
    }

    public SysTaskDao getTaskDao() {
        return taskDao;
    }

    public void setTaskDao(SysTaskDao taskDao) {
        this.taskDao = taskDao;
    }

    public List<PfTaskVo> getHistoryTaskListByInstance(String workFlowInstanceId) {
        List<PfTaskVo> result=new ArrayList<PfTaskVo>();
        List<PfActivityVo> activityList= taskDao.getWorkFlowInstanceAllActivityList(workFlowInstanceId);
        for(PfActivityVo activityVo:activityList){
            //List<PfTaskVo> tasks=taskDao.getTaskListByActivity(activityVo.getActivityId());
            List<PfTaskVo> tasksHistory=taskHistoryDao.getHistoryTasksListByActivity(activityVo.getActivityId());
            //result.addAll(tasks);
            result.addAll(tasksHistory);
        }
        return result;
    }

    public List<PfTaskVo> getHistoryTaskListByDefineId(String workFlowInstanceId, String activityDefineId) {
        List<PfTaskVo> result=new ArrayList<PfTaskVo>();
        PfActivityVo activityVo=taskDao.getActivityBywIdandadId(workFlowInstanceId,activityDefineId);
        if (result!=null){
            List<PfTaskVo> tasksHistory=taskHistoryDao.getHistoryTasksListByActivity(activityVo.getActivityId());
            result.addAll(tasksHistory);
        }
        return result;
    }

    public List<PfTaskVo> getTaskListByInstance(String workFlowInstanceId) {
        return taskDao.getTaskListByInstance(workFlowInstanceId);
    }

    public List<PfActivityVo> getWorkFlowInstanceAllActivityList(
            String workFlowInstanceId) {
        return taskDao.getWorkFlowInstanceAllActivityList(workFlowInstanceId);
    }

    /**
     * 根据task去获取流程所经历的所有活动，因此这个返回结果中可能会出现重复的活动，因为存在退回和取回的情况
     *
     * @param workflowInstanceId
     * @return
     */
    @Override
    public List<PfActivityVo> getWorkflowInstanceActivityByTask(String workflowInstanceId) {
        return taskDao.getWorkflowInstanceActivityByTask(workflowInstanceId);
    }

    public PfTaskVo getHistoryTask(String taskId) {
        return taskHistoryDao.getHistoryTask(taskId);
    }

    /**
     * 前一个办理人
     * @param taskVo
     * @return
     */
    public List<PfTaskVo> getHistoryTaskByBefore(PfTaskVo taskVo){
        List<PfTaskVo> lstResult=new ArrayList<PfTaskVo>();
        if (!StringUtils.isBlank(taskVo.getTaskBefore())){
            String[] taskIds= StringUtils.split(taskVo.getTaskBefore(),",");
            for(String taskId:taskIds){
                if (!StringUtils.isBlank(taskId)){
                    PfTaskVo taskHisVo=this.getHistoryTask(taskId);
                    if (taskHisVo==null)
                        taskHisVo=this.getTask(taskId);
                    if (taskHisVo!=null)
                        lstResult.add(taskHisVo);
                }
            }
        }
        return lstResult;
    }
    @Transactional
    public void deleteWorkFlowInstanceActivity(String workflowIntanceId) {
        taskDao.deleteWorkFlowInstanceActivity(workflowIntanceId);
    }

    @Transactional
    public void deleteHistoryTaskByActivityId(String activityId) {
        List<PfTaskVo> tasks=taskHistoryDao.getHistoryTasksListByActivity(activityId);
        if (tasks!=null){
            for(PfTaskVo task:tasks)
                taskHistoryDao.deleteHistoryTask(task);
        }
        //taskDao.deleteHistoryTaskByActivityId(activityId);
    }

    @Transactional
    public void updateTask(PfTaskVo taskVo) {
        taskDao.updateTask(taskVo);
    }

    @Transactional
    public void updateTempTask(String activityId) {
        taskDao.updateTempTask(activityId);
    }

    public List<PfTaskVo> getTasksByBefore(String taskId) {
        return taskDao.getTasksByBefore(taskId);
    }

    @Transactional
    public void createTaskByHistroy(String taskId) {
        HashMap<String,Object> mapParam=Maps.newHashMap();
        mapParam.put("taskId",taskId);
        mapParam.put("beginTime",Calendar.getInstance().getTime());
        taskDao.createTaskByHistroy(mapParam);
    }

    @Transactional
    public void deleteHistoryTask(String taskId) {
        PfTaskVo task=taskHistoryDao.getHistoryTask(taskId);
        if (task!=null)
            taskHistoryDao.deleteHistoryTask(task);
    }

    @Transactional
    public void deleteActivity(String activityId) {
        taskDao.deleteActivity(activityId);
    }

    @Transactional
    public void updateTaskStadus(String taskId) {
        //更新ISACCEPTED
        String acceptTaskId=taskDao.selectIsAcceptedTask(taskId);
        //判断是否已经接受过了
        if (StringUtils.isBlank(acceptTaskId))
            taskDao.updateTaskStadus(taskId);
    }

    public List<PfTaskVo> getHistoryTaskListByActivity(String activityId){
        return  taskHistoryDao.getHistoryTasksListByActivity(activityId);
    }

    @Transactional
    public void deleteOtherTasks(String taskId){
        taskDao.deleteOtherTasks(taskId);
    }

    @Transactional
    /**
     * 设置历史任务为重复历史任务
     */
    public void updateAssignmentHistoryRepeat(String assignmentId){
        PfTaskVo taskVo=taskHistoryDao.getHistoryTask(assignmentId);
        taskVo.setRepeat(true);
        taskHistoryDao.updateTaskHistory(taskVo);
    }

    
    
}