package com.gtis.plat.service.impl;

import java.util.HashMap;
import java.util.List;

import com.gtis.plat.dao.SysSupervisorDAO;
import com.gtis.plat.service.SysSupervisorService;
import com.gtis.plat.vo.EcSupervisorVo;

public class SysSupervisorServiceImpl implements SysSupervisorService {
	private SysSupervisorDAO supervisorDAO;

	public boolean updateSuperviseExplain(EcSupervisorVo supervisor) {
		boolean isUpdate = false;
		
		supervisorDAO.updateSuperviseExplain(supervisor);
		isUpdate = true;
		
		return isUpdate;
	}

	public SysSupervisorDAO getSupervisorDAO() {
		return supervisorDAO;
	}

	//保存督办信息
	public EcSupervisorVo saveEcSupervisorVo(EcSupervisorVo supervisor) {
		return this.supervisorDAO.saveEcSupervisorVo(supervisor);
	}
	//根据 ExceptionID 获取 督办信息
	public EcSupervisorVo queryEcSupervisorVoByExceptionId(String exceptionID){
		return this.supervisorDAO.queryEcSupervisorVoByExceptionId(exceptionID);
	};
	//更新督办信息
	public void updateEcSupervisorVo(HashMap map){
		this.supervisorDAO.updateEcSupervisorVo(map);
	};
	
	public List<HashMap> getSupervisorDetailList(HashMap condition) {
		return this.supervisorDAO.getSupervisorDetailList(condition);
	}
	//根据督办ID 获取督办
	public HashMap queryEcSupervisorById(HashMap condition) {
		return this.supervisorDAO.queryEcSupervisorById(condition);
	}
	
	public int fillEcSuperExplain(EcSupervisorVo supervisorVo) {
		return this.supervisorDAO.fillEcSuperExplain(supervisorVo);
	}
	//保存领导督办信息
	public void saveEcSupervisorVoByLeader(HashMap map) {
		this.supervisorDAO.saveEcSupervisorVoByLeader(map);
	}
	public List<HashMap> getExceptionInfo(String workflowInstanceId) {
		return supervisorDAO.getExceptionInfo(workflowInstanceId);
	}
	//根据项目ID 获得其所有督办
	public List<HashMap> statSupervisorByInstanceId(String instanceId){
		return this.supervisorDAO.statSupervisorByInstanceId(instanceId);
	}
	public void setSupervisorDAO(SysSupervisorDAO supervisorDAO) {
		this.supervisorDAO = supervisorDAO;
	}

	public List<EcSupervisorVo> getUnansweredSupervisorVoListByActivityId(String activityId){
		return supervisorDAO.getUnansweredSupervisorVoListByActivityId(activityId);
	}
}
