package com.gtis.plat.service.impl;

import com.gtis.plat.service.SysSubProcessService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;

/**
 * 关于子流程的服务
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/2
 */
public class SysSubProcessServiceImpl implements SysSubProcessService {
    private SysTaskService sysTaskService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;

    public SysTaskService getSysTaskService() {
        return sysTaskService;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    @Override
    public Boolean isSubProcess(String wiid) {
        PfTaskVo parentWorkflowTaskVo=sysTaskService.getTask(wiid);
        return parentWorkflowTaskVo!=null?true:false;
    }

    @Override
    public Boolean isSubProcessFinishing(String taskId) {
        PfActivityVo activityVo = sysTaskService.getActivity(sysTaskService.getTask(taskId).getActivityId());
        WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(sysWorkFlowInstanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId()));
        ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
        Boolean isSubProcess = isSubProcess(activityVo.getWorkflowInstanceId());
        if ("结束活动".equals(aModel.getActivityDescription())&&isSubProcess){
            return true;
        }else{
            if (aModel.getDefineId().equals(xmlModel.getEndActivityDefine()) && aModel.getTransitionsList().size()==0 &&isSubProcess)
                return true;
        }
        return false;
    }
}
