package com.gtis.plat.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.plat.rss.RssBuilder;
import com.gtis.plat.vo.PfMessageAcceptVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import org.apache.struts2.ServletActionContext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SysMessageRssBuilder extends ActionSupport implements RssBuilder {

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private SyndFeed  feed;
	private List<PfMessageAcceptVo> acceptListRss;

	public SyndFeed getFeed(int arg0, int arg1) {
		 SyndFeed feed = new SyndFeedImpl();

	        // 设置必填项
	        if (feed.getTitle() == null){
	            feed.setTitle("");
	        }
	        if (feed.getDescription() == null){
	            feed.setDescription("");
	        }
	        if (feed.getAuthor() == null){
	            feed.setAuthor("");
	        }
	        if (feed.getLink() == null){
	            feed.setLink("");
	        }
	        if (feed.getImage() != null) {
	            feed.getImage().setUrl("");
	        }
	        HashMap<String,String> paramsMap = new HashMap<String,String>();
	        SysMessageServiceImpl messageServiceImpl=(SysMessageServiceImpl) Container.getBean("SysMessageServiceImpl");
	        UserInfo userInfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
	        paramsMap.put("mesageStadus", "1");
	        if(userInfo.isAdmin()){
	        	acceptListRss=messageServiceImpl.getAcceptMsgListRss(paramsMap);
			}else{
				paramsMap.put("acceptUserId",userInfo.getId());
				acceptListRss=messageServiceImpl.getAcceptMsgListRss(paramsMap);
			}        
	        List<SyndEntry> entries = new ArrayList<SyndEntry>();   
	        for(PfMessageAcceptVo vo : acceptListRss){
	            entries.add(convert(vo));
	        }
	        feed.setEntries(entries);
	        
	        return feed;
	}

	public String getUrl(String... params) {
		return AppConfig.getPlatFormUrl() + "/message!detail.action?flag=accept&msgAcceptVo.messageAcceptId=" + params[0];
	}

	public SyndEntry convert(Object param) {
		PfMessageAcceptVo vo=(PfMessageAcceptVo)param;
		SyndEntry entry = new SyndEntryImpl();
        entry.setTitle(vo.getMessageSendVo().getMessageSendTitle());
        entry.setLink(this.getUrl(vo.getMessageAcceptId()));
        entry.setPublishedDate(vo.getMessageSendVo().getMessageSendDate());
        return entry;
	}

	public SyndFeed getFeed() {
		return feed;
	}

	public void setFeed(SyndFeed feed) {
		this.feed = feed;
	}

	public List<PfMessageAcceptVo> getAcceptListRss() {
		return acceptListRss;
	}

	public void setAcceptListRss(List<PfMessageAcceptVo> acceptListRss) {
		this.acceptListRss = acceptListRss;
	}

}
