package com.gtis.plat.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.plat.dao.SysCalendarDAO;
import com.gtis.plat.service.SysCalendarService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Pattern;


public class SysCalendarServiceDefaultImpl implements SysCalendarService {
    static Logger logger = LoggerFactory.getLogger(SysCalendarServiceDefaultImpl.class);

    SysCalendarDAO calendarDAO;
    static List<String> specialHolidays=new ArrayList<String>();
    static List<String> specialWorkdays=new ArrayList<String>();
    static SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat simpleDateFullFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static SimpleDateFormat simpleDateTimeFormat=new SimpleDateFormat("HH:mm");
    static String SYS_MAX_DATE="2999-12-31";
    String workDayAMStartTime="08:30";
    String workDayAMEndTime="12:00";
    String workDayPMStartTime="13:00";
    String workDayPMEndTime="17:30";
    double workDayHours=8.0;   //计算每天的上班小时数

    public void setCalendarDAO(SysCalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }

    /**
     * 初始化，只取去年、今年和明年的数据,3年的数据
     */
    public void init(){

        //从配置文件读取信息
        if (StringUtils.isNotBlank(AppConfig.getProperty("WorkDayAMStartTime")))
            workDayAMStartTime=AppConfig.getProperty("WorkDayAMStartTime");
        if (StringUtils.isNotBlank(AppConfig.getProperty("WorkDayAMEndTime")))
            workDayAMStartTime=AppConfig.getProperty("WorkDayAMEndTime");
        if (StringUtils.isNotBlank(AppConfig.getProperty("WorkDayPMStartTime")))
            workDayAMStartTime=AppConfig.getProperty("WorkDayPMStartTime");
        if (StringUtils.isNotBlank(AppConfig.getProperty("WorkDayPMEndTime")))
            workDayAMStartTime=AppConfig.getProperty("WorkDayPMEndTime");

        Calendar ca=Calendar.getInstance();
        int yearInt=Calendar.getInstance().get(Calendar.YEAR);
        //Date beginDate=ca.set(Calendar.ye);
        ca.set(Calendar.YEAR,yearInt-1);
        ca.set(Calendar.DAY_OF_YEAR, 1);//本年第一天
        Date beginDate=ca.getTime();
        ca.set(Calendar.YEAR,yearInt+2);
        ca.set(Calendar.DAY_OF_YEAR, 1);//本年第一天
        ca.add(Calendar.DAY_OF_YEAR, -1);
        Date endDate=ca.getTime();
        List<Map> specialDates=calendarDAO.getSpecialDateList(beginDate,endDate);
        for(Map sDate:specialDates){
            if (sDate.get("CAL_TYPE").equals("工作日"))
                specialWorkdays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
            else
                specialHolidays.add(simpleDateFormat.format((Date)sDate.get("CAL_DATE")));
        }
        ///计算一天的工作小时
        try{
            workDayHours=
                    getDateDiffHour(simpleDateFullFormat.parse("2014-01-01 " + workDayAMStartTime),simpleDateFullFormat.parse("2014-01-01 " +workDayAMEndTime ))
                    +getDateDiffHour(simpleDateFullFormat.parse("2014-01-01 " + workDayPMStartTime),simpleDateFullFormat.parse("2014-01-01 " + workDayPMEndTime));
        }catch (Exception ex){
            logger.error(ex.getMessage());
        }

    }

    /**
     * 得到两个时间的差多少小时
     * @param beginDate
     * @param endDate
     * @return
     */
    private static double getDateDiffHour(Date beginDate,Date endDate){
        long time=   endDate.getTime() -beginDate.getTime();
        return time*1.0/(1000*60*60);
    }

    /**
     * 判断是否非工作日(节假日)
     * @param bDate
     * @return
     */
    public boolean IsHoliday(Date bDate){
        Calendar ca=Calendar.getInstance();
        ca.setTime(bDate);
        String dateStr= simpleDateFormat.format(bDate);
        if (ca.get(Calendar.DAY_OF_WEEK)==1 || ca.get(Calendar.DAY_OF_WEEK)==7){
            return !specialWorkdays.contains(dateStr);
        }else{
            return specialHolidays.contains(dateStr);
        }
    }

    /**
     * 得到下一个工作日
     * @param bDate
     * @return
     */
    public Date getNextWorkDay(Date bDate){
        Calendar ca=Calendar.getInstance();
        ca.setTime(bDate);
        ca.add(Calendar.DAY_OF_YEAR,1);
        while(IsHoliday(ca.getTime())){
            ca.add(Calendar.DAY_OF_YEAR,1);
        }
        try{
            ca.setTime(simpleDateFullFormat.parse(simpleDateFormat.format(ca.getTime()) + " " + workDayAMStartTime));
        }catch (Exception ex){
            logger.error(ex.getMessage());
        }
        return ca.getTime();
    }

    @Override
    public void reloadWorkdaysAndHolidays() {
        init();
    }

    @Override
    public int getTimeLeft(Date overDate) {
        return 0;
    }

    @Override
    public Date getMaxDate() {
        try {
            return simpleDateFormat.parse(SYS_MAX_DATE);
        }catch (Exception ex){
            logger.error(ex.getMessage());
            return null;
        }
    }

    /**
     * 判断是否为double类型
     * @param str
     * @return
     */
    public static boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("[-+]?[0-9]+(\\.[0-9]+)?");
        return pattern.matcher(str).matches();
    }

    @Override
    public Date getOverTime(Date beginDate, String timeLimit) {
        if (StringUtils.isNotBlank(timeLimit)){
            if(isNumeric(timeLimit)){
                double days = Double.parseDouble(timeLimit);
                //按工作日计算
                return getOverTime(beginDate,days*workDayHours);

            }else{
                double hours = Double.parseDouble(timeLimit.substring(0,timeLimit.length()-1));
                //按工作小时计算
                return getOverTime(beginDate,hours);
            }
        }
        return getMaxDate();
    }

    public Date getOverTime(Date beginDate, double hours){
        Date bDate=beginDate;
        if (hours>0 && beginDate!=null){
            if(IsHoliday(bDate))
                //判断开始时间是否不是工作日
                bDate=getNextWorkDay(beginDate);
            else{
                //判断开始时间是否工作日的非工作时间
                if (bDate.before(buildDate(bDate, workDayAMStartTime))){
                    bDate=buildDate(bDate,workDayAMStartTime);
                }else if (bDate.after(buildDate(bDate,workDayAMEndTime)) && bDate.before(buildDate(bDate,workDayPMStartTime))){
                    bDate=buildDate(bDate,workDayPMStartTime);
                }else if (bDate.after(buildDate(bDate,workDayPMEndTime))){
                    bDate=getNextWorkDay(bDate);
                }
            }
            //开始计算时间
            Date overDate=bDate;
            int days=(int)Math.floor(hours/workDayHours);
            for(int i=0;i<days;i++){
                overDate=getNextWorkDay(overDate);
            }
            overDate=buildDate(overDate,simpleDateTimeFormat.format(bDate));
            //开始计算小时
            double otherHours= hours % workDayHours;
            overDate=addWorkHoursToDate(overDate, otherHours);
            return overDate;
        }
        return getMaxDate();
    }

    @Override
    public double getWorkDayHours(Date beginDate,Date endDate){
        double result=0;
        Date bDate=beginDate;
        if(IsHoliday(bDate))
            //判断开始时间是否不是工作日
            bDate=getNextWorkDay(beginDate);
        else{
            //判断开始时间是否工作日的非工作时间
            if (bDate.before(buildDate(bDate, workDayAMStartTime))){
                bDate=buildDate(bDate,workDayAMStartTime);
            }else if (bDate.after(buildDate(bDate,workDayAMEndTime)) && bDate.before(buildDate(bDate,workDayPMStartTime))){
                bDate=buildDate(bDate,workDayPMStartTime);
            }else if (bDate.after(buildDate(bDate,workDayPMEndTime))){
                bDate=getNextWorkDay(bDate);
            }
        }

        //计算天
        Calendar ca=Calendar.getInstance();
        int days=0;
        while(bDate.before(endDate)) {
            ca.setTime(bDate);
            ca.add(Calendar.DAY_OF_YEAR, 1);
            if (ca.getTime().before(endDate) && !IsHoliday(ca.getTime())){
                days++;
                bDate=ca.getTime();
            }else{
                break;
            }
        }
        return days*workDayHours+calWorkDayHoursDiff(bDate,endDate);
    }

    private double calWorkDayHoursDiff(Date beginDate,Date endDate){
        Date bDate=beginDate;
        double result=0;

        Date amDate=buildDate(bDate, workDayAMEndTime);
        if (bDate.before(amDate) && endDate.after(amDate)){
            if (endDate.after(amDate)) {
                result = result + getDateDiffHour(bDate, amDate);
                return result + calWorkDayHoursDiff(buildDate(bDate, workDayPMStartTime), endDate);
            }else {
                return  getDateDiffHour(bDate, endDate);
            }
        }
        Date pmDate=buildDate(bDate, workDayPMEndTime);
        if (bDate.before(pmDate) ){
            if (endDate.after(pmDate)) {
                result = result + getDateDiffHour(bDate, pmDate);
                return result + calWorkDayHoursDiff(getNextWorkDay(bDate), endDate);
            }else{
                return getDateDiffHour(bDate, endDate);
            }
        }
        return 0;
    }


    private Date addWorkHoursToDate(Date endDate,double hours){
        Date amEndTime=buildDate(endDate,workDayAMEndTime);
        if (endDate.before(amEndTime)){
            Date oDate=addHoursToDate(endDate,hours);
            if (oDate.before(amEndTime))
                return oDate;
            else{
                double diffHour=getDateDiffHour(endDate,amEndTime);
                return addWorkHoursToDate(buildDate(endDate,workDayPMStartTime),hours-diffHour);
            }
        }
        Date pmEndTime=buildDate(endDate,workDayPMEndTime);
        if (endDate.before(pmEndTime)){
            Date oDate=addHoursToDate(endDate,hours);
            if (oDate.before(pmEndTime))
                return oDate;
            else{
                double diffHour=getDateDiffHour(endDate,pmEndTime);
                return addWorkHoursToDate(getNextWorkDay(endDate),hours-diffHour);
            }
        }
        return endDate;
    }

    private Date buildDate(Date cDate,String timeStr){
        try{
            return simpleDateFullFormat.parse(simpleDateFormat.format(cDate) + " " +timeStr);
        }catch (Exception ex){
            logger.error(ex.getMessage());
            return null;
        }
    }

    private Date addHoursToDate(Date cDate,double hours){
        int hour=(int)Math.floor(hours);
        int min=(int)Math.round((hours-hour)*60);
        Calendar ca=Calendar.getInstance();
        ca.setTime(cDate);
        ca.add(Calendar.HOUR_OF_DAY,hour);
        ca.add(Calendar.MINUTE,min);
        return ca.getTime();
    }

    public static void main(String[] arg) throws Exception{
//        String workDayAMStartTime="08:30";
//        String workDayAMEndTime="12:00";
//        String workDayPMStartTime="13:00";
//        String workDayPMEndTime="17:30";
//        SimpleDateFormat simpleDateFullFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm");
//        double dd=getDateDiffHour(simpleDateFullFormat.parse("2014-01-01 " + workDayAMEndTime),simpleDateFullFormat.parse("2014-01-01 " + workDayAMStartTime))
//                +getDateDiffHour(simpleDateFullFormat.parse("2014-01-01 " + workDayPMEndTime),simpleDateFullFormat.parse("2014-01-01 " + workDayPMStartTime));
//        System.out.println(dd);

        SysCalendarServiceDefaultImpl calendarService=new SysCalendarServiceDefaultImpl();
//        System.out.println(simpleDateFullFormat.format(calendarService.getOverTime(simpleDateFullFormat.parse("2014-10-09 04:30 "),"2")));
//        System.out.println(simpleDateFullFormat.format(calendarService.getOverTime(simpleDateFullFormat.parse("2014-10-09 08:30 "),"3")));
//        System.out.println(simpleDateFullFormat.format(calendarService.getOverTime(simpleDateFullFormat.parse("2014-10-09 09:30 "),"1")));
//        System.out.println(simpleDateFullFormat.format(calendarService.getOverTime(simpleDateFullFormat.parse("2014-10-09 04:30 "),"1h")));
//        System.out.println(simpleDateFullFormat.format(calendarService.getOverTime(simpleDateFullFormat.parse("2014-10-09 15:33 "),"6h")));
//        System.out.println(simpleDateFullFormat.format(calendarService.getOverTime(simpleDateFullFormat.parse("2014-10-09 15:33 "),"17h")));

        System.out.println(calendarService.getWorkDayHours(simpleDateFullFormat.parse("2014-10-09 04:30 "),simpleDateFullFormat.parse("2014-10-10 09:30 ")));
    }

    @Override
    public List<Date> getWorkDateList(Date beginDate, Date endDate) {
        List<Date>  workDateList=new ArrayList<Date>();
        List<Map> specialDates=calendarDAO.getSpecialDateList(beginDate,endDate);
        for(Map sDate:specialDates){
            if (sDate.get("CAL_TYPE").equals("工作日"))
                workDateList.add((Date)sDate.get("CAL_DATE"));
        }
        if(workDateList==null||workDateList.size()==0)
            workDateList=null;
        return workDateList;
    }

    @Override
    public List<Date> getHolidayList(Date beginDate, Date endDate) {
        List<Date>  holidayList=new ArrayList<Date>();
        List<Map> specialDates=calendarDAO.getSpecialDateList(beginDate,endDate);
        for(Map sDate:specialDates){
            if (!sDate.get("CAL_TYPE").equals("工作日"))
                holidayList.add((Date)sDate.get("CAL_DATE"));
        }
        if(holidayList==null||holidayList.size()==0)
            holidayList=null;
        return holidayList;
    }
}
