package com.gtis.plat.service.impl;

import com.gtis.plat.vo.PfSmsVo;
import com.gtis.sp.SmsSender;

import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 13-9-24
 */
public class SpSysSmsServiceImpl extends SysSmsServiceImpl {
    private SmsSender smsSender;

    public void setSmsSender(SmsSender smsSender) {
        this.smsSender = smsSender;
    }

    @Override
    public String sendMsg(PfSmsVo sms) throws Exception {
        if (isMobileNum(sms.getReceive()))
            smsSender.send(null, sms.getContent(), Collections.singletonList(sms.getReceive()));
        else if(isMobileNum(sms.getMobileNo()))
            smsSender.send(null, sms.getContent(), Collections.singletonList(sms.getMobileNo()));
        else
            return "手机号码不正确，请核实！";
        String result = super.sendMsg(sms);
        return result;
    }

    /** 用于判断手机号段是否合法 */
    public static boolean isMobileNum(String num){
        //String str= "^((13[0-9])|(15[0-9])|(18[0-9]))\d{8}$";
        String str = "^[+86]*[1]([0-9][0-9]{1}|59|58|88|89)[0-9]{8}$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(num);
        return m.matches();
    }
    public static void main(String[] args) {
        if (isMobileNum("18118845234"))
            System.out.println("OK");
        else
            System.out.println("NO");
    }


}
