package com.gtis.plat.service.impl;



import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.AttendanceService;
import com.opensymphony.xwork2.Action;


public class AttendanceServiceImpl implements AttendanceService{
	
	private String serviceUrl;
	
	@Override
	public String goWork(String userName) {
		// TODO Auto-generated method stub
		try {			
			if(StringUtils.isNotBlank(AppConfig.getProperty("goServiceUrl"))){
				serviceUrl = AppConfig.getProperty("goServiceUrl");
				HttpPost request = new HttpPost(serviceUrl);
				List<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
	            params.add(new BasicNameValuePair("userName", userName));
	            request.setEntity(new UrlEncodedFormEntity(params, HTTP.UTF_8));
	            HttpResponse httpResponse = new DefaultHttpClient().execute(request);
	            if (httpResponse.getStatusLine().getStatusCode() == 404){
	            	System.out.println("打卡异常");
	            }
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return Action.NONE;
	}

	@Override
	public String goOffWork(String userName) {
		// TODO Auto-generated method stub
		try {
			if(StringUtils.isNotBlank(AppConfig.getProperty("goOffServiceUrl"))){
				serviceUrl = AppConfig.getProperty("goOffServiceUrl");
				HttpPost request = new HttpPost(serviceUrl);
				List<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
	            params.add(new BasicNameValuePair("userName", userName));
	            request.setEntity(new UrlEncodedFormEntity(params, HTTP.UTF_8));
	            HttpResponse httpResponse = new DefaultHttpClient().execute(request);
	            if (httpResponse.getStatusLine().getStatusCode() == 404){
	            	System.out.println("打卡异常");
	            }
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return Action.NONE;
	}





}
