package com.gtis.plat.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.gtis.plat.dao.RequireFieldDaoImpl;

/**
 * @文件名 RequireFieldService.java
 * @作者 卢向伟
 * @创建日期 2013-8-13
 * @创建时间 下午3:50:10 
 * @版本号 V 1.0
 */
public interface RequireFieldService {
	/**
	 * 获取单个对象
	 * @param param
	 * @return
	 */
	public <T> T getObject(HashMap param);
	/**
	 * 获取单个对象
	 * @proid 项目id
	 * @idFieldName 主键id名称
	 * @return
	 */
	public <T> T getObject(String proid);
	/**
	 * 根据id和id对应的字段名称获取单个对象
	 * @param主键ID
	 * @param主键名称
	 * @return
	 */
	public <T> T getObject(String proid,String idFieldName);
	/**
	 * 获取对象List
	 * @param param
	 * @return
	 */
	public <T> List<T> getObjectList(HashMap param);
	public boolean insertObject(Object obj);
	public boolean updateObject(Object obj);
	/**
	 * 删除对象，包含文件中心信息
	 * @param参数
	 */
	public boolean deleteObject(HashMap param);
	/**
	 * 删除对象
	 * @proid 项目id
	 * @idFieldName 主键id名称
	 * @return
	 */
	public boolean deleteObject(String proid);
	/**
	 * 根据参数和ibatis配置id获取对象
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public <T> T getObjectByIbatisStr(HashMap param,String ibatisStr);
	/**
	 * 根据参数和ibatis配置id获取对象集合
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public <T> List<T> getObjectListByIbatisStr(HashMap param,String ibatisStr);
	/**
	 * 根据参数和ibatis配置id获取对象
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public HashMap getHashMapByIbatisStr(HashMap param,String ibatisStr);
	/**
	 * 根据参数和ibatis配置id获取对象集合
	 * @param param
	 * @param ibatisStr
	 * @return
	 */
	public List<HashMap> getHashMapListByIbatisStr(HashMap param,String ibatisStr);
	/**
	 * 根据对象和ibatis配置进行插入数据
	 * @param obj
	 * @param ibatisStr
	 */
	public boolean insertObjectByIbatisStr(Object obj,String ibatisStr);
	/**
	 * 根据对象和ibatis配置进行更新数据
	 * @param obj
	 * @param ibatisStr
	 */
	public boolean updateObjectByIbatisStr(Object obj,String ibatisStr);
	/**
	 * 删除对象，根据对象和ibatis配置
	 * @param参数
	 */
	public boolean deleteObjectByIbatisStr(HashMap param,String ibatisStr);
}
