/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: PortletEntityAction.java
 *
 * LastModified: 2009-12-02 10:56:03
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.portal.web;

import com.gtis.plat.portal.PortalManager;
import com.gtis.plat.portal.model.PortletApp;
import com.gtis.plat.portal.model.PortletEntity;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-12-2
 */
public class PortletEntityAction implements Action {

    private String id;

    private PortletEntity entity;

    private List<String> preferenceName;

    private List<String> preferenceValue;

    private Collection<PortletEntity> entities;

    private List<PortletApp> portletApps;

    private PortalManager portalManager;

    private SysUserService sysUserService;

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PortletEntity getEntity() {
        return entity;
    }

    public void setEntity(PortletEntity entity) {
        this.entity = entity;
    }

    public void setPreferenceName(List<String> preferenceName) {
        this.preferenceName = preferenceName;
    }

    public void setPreferenceValue(List<String> preferenceValue) {
        this.preferenceValue = preferenceValue;
    }

    public Collection<PortletEntity> getEntities() {
        return entities;
    }

    public List<PortletApp> getPortletApps() {
        return portletApps;
    }

    public List<PfRoleVo> getRoles() {
        return sysUserService.getRoleList();
    }

    public void setPortalManager(PortalManager portalManager) {
        this.portalManager = portalManager;
    }

    public String execute() throws Exception {
        entities = portalManager.getPortletEntities();
        return SUCCESS;
    }

    public String list() throws Exception {
        entities = portalManager.getPortletEntities();
        return "list";
    }

    public String edit() throws Exception {
        entity = portalManager.getPortletEntity(id);
        portletApps = portalManager.getPortletApps();
        return "edit";
    }

    public String save() throws Exception {
        if (!StringUtils.isBlank(entity.getName())) {
            HashMap<String, String> preferences = new LinkedHashMap<String, String>();
            for (int i = 0; i < preferenceName.size(); i++) {
                if (StringUtils.isBlank(preferenceName.get(i)))
                    continue;
                preferences.put(preferenceName.get(i), preferenceValue.get(i));
            }
            entity.setPreferences(preferences);
            entity.setCreator(SessionUtil.getUserId(ServletActionContext.getRequest()));
            entity.setUpdateTime(new Date());
            portalManager.savePortletEntity(entity);
        }
        return "toEdit";
    }

    public String remove() throws Exception {
        portalManager.removePortletEntity(id);
        return "toIndex";
    }

    public String reset() throws Exception {
        portalManager.resetUserSite();
        return "toIndex";
    }
}
