/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: PortalAction.java
 *
 * LastModified: 2009-12-02 10:56:35
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.portal.web;

import com.gtis.plat.portal.PortalManager;
import com.gtis.plat.portal.model.Page;
import com.gtis.plat.portal.model.Site;
import com.gtis.plat.service.CountProvider;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.SessionAware;
import org.apache.struts2.json.JSONUtil;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-12-2
 */
public class PortalAction implements Action, SessionAware {

    public static final String PORTAL_SITE = "portal_site";

    private String owner;

    private String page;

    private PortalManager portalManager;

    private Map<String, Object> session;

    /**
     * 业务菜单的业务单元数量
     */
    private Map<String, Integer> counts;

    public Map<String, Integer> getCounts() {
        return counts;
    }

    private static Mapper mapper = new DozerBeanMapper();

    public void setOwner(String owner) {
        if (StringUtils.isNotBlank(owner))
            this.owner = owner;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setPortalManager(PortalManager portalManager) {
        this.portalManager = portalManager;
    }

    public Site getSite() {
        Site site;
        if (owner == null) {
            site = (Site) session.get(PORTAL_SITE);
            if (site == null) {
                site = portalManager.getSite(SessionUtil.getCurrentUserId());
                session.put(PORTAL_SITE, site);
            }
        } else {
            site = portalManager.getSite(owner);
        }
        return site;
    }

    public String execute() throws Exception {
        return SUCCESS;
    }

    public String count() throws Exception {
        List<CountProvider> countProviders = portalManager.getCountProviders();
        counts = new HashMap<String, Integer>();
        for (CountProvider countProvider : countProviders) {
            counts.put(countProvider.getName(), countProvider.getCount());
        }
        return "count";
    }

    public String site() throws Exception {
        return "site";
    }

    public String save() throws Exception {
        Page p = mapper.map(JSONUtil.deserialize(page), Page.class);
        Site site = getSite();
        site.getPages().set(site.getPages().indexOf(p), p);
        portalManager.saveSite(site);
        return NONE;
    }

    public String reset() throws Exception {
        portalManager.removeSite(owner == null ? SessionUtil.getCurrentUserId() : owner);
        if (owner == null)
            session.remove(PORTAL_SITE);
        return NONE;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }
}
