/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: Portlet.java
 *
 * LastModified: 2009-11-30 04:42:35
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.plat.portal.model;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-11-30
 */
public class Portlet implements Serializable, Cloneable {

    private String name;
    private String entityId;
    private transient PortletEntity entity;
    private Date createTime;
    private Map<String, String> preferences = new HashMap<String, String>();
    private static final long serialVersionUID = -3396321171759413850L;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEntityId() {
        return entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public PortletEntity getEntity() {
        return entity;
    }

    public void setEntity(PortletEntity entity) {
        this.entity = entity;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Map<String, String> getPreferences() {
        return preferences;
    }

    public void setPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public Portlet clone() throws CloneNotSupportedException {
        return (Portlet) super.clone();
    }
}
