package com.gtis.plat.form.print.xmlutil;


import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import javax.naming.InitialContext;
import javax.sql.DataSource;

public class SqlStrXml {

	private String sqlstr=null;
	private String jndi=null;
	private String datatype=null;
	private Connection conn = null;
	
	public SqlStrXml(String sqlstr,String jndi,String datatype) {
		this.sqlstr=sqlstr;
		this.jndi=jndi;
		this.datatype=datatype;
		getConnection();
	}

	public String getXMLData()
	{
		String retvalue="";
		try
		{
			Statement st=conn.createStatement();
			ResultSet rs= st.executeQuery(sqlstr);
			ResultSetXml rsx=new ResultSetXml(rs,datatype);
			retvalue=rsx.getXMLData();
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		return retvalue;
	}
	
	private Connection getConnection()
	{
		try
		{
			if (conn == null) {
				InitialContext ctx = new InitialContext();
				DataSource ds = (DataSource) ctx.lookup("java:/"+jndi);
				conn = ds.getConnection();
		}
		}catch(Exception e)
		{
			e.printStackTrace();
			
		}
		return conn;
	}


	protected void finalize() throws Throwable {
		super.finalize();
		if (conn!=null)
		{
			conn.close();
			conn=null;
		}
		
	}
}
