package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.cache.annotation.Cacheable;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;

public class SysWorkFlowDefineDao extends SqlMapClientDaoSupport {

	/**
	 * 获取所有的业务
	 * 
	 * @return
	 */
	public List<PfBusinessVo> getBusinessList() {
		return super.getSqlMapClientTemplate().queryForList("getBusinessList");
	}

    /**
     * 获取所有的列表,简单列表
     * @return
     */
    @Cacheable(value="WorkFlowDefineCache",key="'AllBusinessSimpleList'")
    public List<PfBusinessVo> getBusinessSimpleList() {
        return super.getSqlMapClientTemplate().queryForList("getBusinessSimpleList");
    }

	/**
	 * 获取业务详细信息
	 * 
	 * @param bId
	 * @return
	 */
	public PfBusinessVo getBusiness(String bId) {
		return (PfBusinessVo) super.getSqlMapClientTemplate().queryForObject(
				"getBusiness", bId);
	}

	/**
	 * 根据资源获取业务
	 * 
	 * @param resId
	 * @return
	 */
	public PfBusinessVo getBusinessByResId(String resId) {
		return (PfBusinessVo) super.getSqlMapClientTemplate().queryForObject(
				"getBusinessByResId", resId);
	}

	/**
	 * 根据业务获取该业务下的流程定义
	 * 
	 * @param bId
	 * @return
	 */
	public List<PfWorkFlowDefineVo> getWorkFlowDefineByBusiness(String bId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getWorkFlowDefineByBusiness", bId);
	}

	/**
	 * 获取所有的流程定义
	 * 
	 * @return
	 */
    @Cacheable(value="WorkFlowDefineCache",key="'AllWorkFlowDefineList'")
	public List<PfWorkFlowDefineVo> getWorkFlowDefineList() {
		return super.getSqlMapClientTemplate().queryForList(
				"getWorkFlowDefineList");
	}

	/**
	 * 获取流程定义的详细信息
	 * 
	 * @param workDefineId
	 * @return
	 */
	public PfWorkFlowDefineVo getWorkFlowDefine(String workDefineId) {
		return (PfWorkFlowDefineVo) super.getSqlMapClientTemplate()
				.queryForObject("getWorkFlowDefine", workDefineId);
	}

	/**
	 * 获取流程定义，根据用户的所有的角色
	 * 
	 * @param roleIds
	 * @param resourceId
	 * @param bId
	 * @return
	 */
	public List<PfWorkFlowDefineVo> getWorkFlowDefineListByRole(String roleIds,
			String resourceId, String bId) {
		HashMap<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("roleIds", roleIds);
		paramMap.put("resourceId", resourceId);
		paramMap.put("bId", bId);
		return super.getSqlMapClientTemplate().queryForList(
				"getWorkFlowDefineListByRole", paramMap);
	}


    public Object getWorkFlowDefineCountByRole(String roleIds,
                                                                String resourceId, String bId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("roleIds", roleIds);
        paramMap.put("resourceId", resourceId);
        paramMap.put("bId", bId);
        return super.getSqlMapClientTemplate().queryForObject("getWorkFlowDefineCountByRole", paramMap);
    }

	/**
	 * 获取定义XML
	 * 
	 * @param workDefineId
	 * @return
	 */
	public String getWorkFlowDefineXml(String workDefineId) {
		return super.getSqlMapClientTemplate().queryForObject(
				"getWorkFlowDefineXml", workDefineId).toString();
	}

	/**
	 * 工作流事件xml
	 * 
	 * @param workDefineId
	 * @return
	 */
	public String getWorkFlowDefineEventXml(String workDefineId) {
		Object result = super.getSqlMapClientTemplate().queryForObject(
				"getWorkFlowDefineEventXml", workDefineId);
		if (result != null)
			return result.toString();
		else
			return "";
	}

	public String getWorkFlowDefineLocation(String workDefineId) {
		Object result = super.getSqlMapClientTemplate().queryForObject(
				"getWorkFlowDefineLocation", workDefineId);
		if (result != null)
			return result.toString();
		else
			return "";
	}

	/**
	 * 流程图
	 * 
	 * @param workDefineId
	 * @return
	 */
	public PfWorkFlowDefineVo getWorkFlowImage(String workDefineId) {
		return (PfWorkFlowDefineVo) super.getSqlMapClientTemplate()
				.queryForObject("getWorkFlowImage", workDefineId);
	}

	/**
	 * 根据工作流定义编号查找
	 * 
	 * @param definitionNo
	 *            工作流定义编号
	 * @return
	 */
	public PfWorkFlowDefineVo getWorkFlowByDefinitionNo(String definitionNo) {
		return (PfWorkFlowDefineVo) super.getSqlMapClientTemplate()
				.queryForObject("getWorkFlowDefineByNo", definitionNo);
	}

	/**
	 * 获得需要监察的项目定义列表
	 * @return
	 */
	public List<PfWorkFlowDefineVo> getECWorkFlowDefineList(){
		return super.getSqlMapClientTemplate().queryForList("getECWorkFlowDefineList");
	}
}
