package com.gtis.plat.dao;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.WorkFlowUtil;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import org.apache.commons.collections.MapUtils;
import org.springframework.orm.ibatis.SqlMapClientCallback;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import java.sql.SQLException;
import java.util.*;

public class SysTaskDao extends SqlMapClientDaoSupport {

    /**
     * 根据主健获取活动
     *
     * @param activityId
     * @return
     */
    public PfActivityVo getActivity(String activityId) {
        return (PfActivityVo) super.getSqlMapClientTemplate().queryForObject(
                "getActivity", activityId);
    }



    /**
     * 根据流程实例和活动定义获取活动
     *
     * @param workflowInstanceId
     * @param activityDefinitionId
     * @return
     */
    public PfActivityVo getActivityBywIdandadId(String workflowInstanceId,
                                                String activityDefinitionId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("workflowInstanceId", workflowInstanceId);
        paramMap.put("activityDefinitionId", activityDefinitionId);
        return (PfActivityVo) super.getSqlMapClientTemplate().queryForObject(
                "getActivityBywIdandadId", paramMap);
    }

    /**
     * 获取实例中处于活动状态的活动
     *
     * @param workflowInstanceId
     * @return
     */
    public List<PfActivityVo> getWorkFlowInstanceActivityList(
            String workflowInstanceId) {
        return super.getSqlMapClientTemplate().queryForList(
                "getWorkFlowInstanceActivityList", workflowInstanceId);
    }

    public List<PfActivityVo> getWorkFlowInstanceAllActivityList(
            String workflowInstanceId) {
        return super.getSqlMapClientTemplate().queryForList(
                "getWorkFlowInstanceAllActivityList", workflowInstanceId);
    }

    /**
     * 根据task去获取流程所经历的所有活动，因此这个返回结果中可能会出现重复的活动，因为存在退回和取回的情况
     * @param workflowInstanceId
     * @return
     */
    public List<PfActivityVo> getWorkflowInstanceActivityByTask(
            String workflowInstanceId) {
        return super.getSqlMapClientTemplate().queryForList(
                "getWorkflowInstanceActivityByTask", workflowInstanceId);
    }

    /**
     * 根据任务主键获取任务
     *
     * @param taskId
     * @return
     */
    public PfTaskVo getTask(String taskId) {
        return (PfTaskVo) super.getSqlMapClientTemplate().queryForObject(
                "getTask", taskId);
    }

    /**
     * 在查找任务记录
     * @param taskId
     * @return
     */
    public PfTaskVo getTaskAll(String taskId){
        return (PfTaskVo) super.getSqlMapClientTemplate().queryForObject("getTaskAll", taskId);
    }

    /**
     * 根据活动获取任务
     *
     * @param activityId
     * @return
     */
    public List<PfTaskVo> getTaskListByActivity(String activityId) {
        return super.getSqlMapClientTemplate().queryForList(
                "getTaskListByActivity", activityId);
    }

    public List<PfTaskVo> getTaskListByUserIdAndActivity(String activityId, String userId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activityId", activityId);
        paramMap.put("userId", userId);
        return super.getSqlMapClientTemplate().queryForList(
                "getTaskListByUserIdAndActivity", paramMap);
    }



    /**
     * 获得该活的任务个数（包括历史）
     * @param activityId
     * @return
     */
    public int getAllTaskCountByActivityId(String activityId){
        return (Integer)super.getSqlMapClientTemplate().queryForObject("getAllTaskCountByActivityId",activityId);
    }

    /**
     * 获取活动下的历史任务
     *
     * @param workFlowInstanceId
     * @return
     */
//    public List<PfTaskVo> getHistoryTaskListByInstance(String workFlowInstanceId) {
//        return super.getSqlMapClientTemplate().queryForList(
//                "getHistoryTaskListByInstance", workFlowInstanceId);
//    }

//    /**
//     * 根据活动的定义获取任务
//     *
//     * @param workFlowInstanceId,activityDefineId
//     * @return
//     */
//    public List<PfTaskVo> getHistoryTaskListByDefineId(String workFlowInstanceId, String activityDefineId) {
//        HashMap<String, String> paramMap = new HashMap<String, String>();
//        paramMap.put("workFlowInstanceId", workFlowInstanceId);
//        paramMap.put("activityDefineId", activityDefineId);
//        return super.getSqlMapClientTemplate().queryForList(
//                "getHistoryTaskListByDefineId", paramMap);
//    }

    public List<PfTaskVo> getTaskListByInstance(String workFlowInstanceId) {
        return super.getSqlMapClientTemplate().queryForList(
                "getTaskListByInstance", workFlowInstanceId);
    }



    /**
     * 设置活动的退回状态
     *
     * @param activityId
     */
    public void updateActivityBack(String activityId) {
        super.getSqlMapClientTemplate().update("updateActivityBack", activityId);
    }

    /**
     * 设置活动的非退回状态
     *
     * @param activityId
     */
    public void updateActivityForword(String activityId) {
        super.getSqlMapClientTemplate().update("updateActivityForword", activityId);
    }

    /**
     * 根据活动备注
     *
     * @param activityId
     * @param remark
     */
    public void updateActivityRemark(String activityId, String remark) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activityId", activityId);
        paramMap.put("remark", remark);
        super.getSqlMapClientTemplate().update("updateActivityRemark", paramMap);
    }

    /**
     * 更新活动相关信息
     * ACTIVITY_STATE（必选）
     * ACTIVITY_BEFORE（以下可选）
     * begin_time
     * finish_time
     * REMARK
     *
     * @param activityVo
     */
    public void updateActivityStadus(PfActivityVo activityVo) {

        super.getSqlMapClientTemplate().update("updateActivityStadus", activityVo);
    }

    public void updateActivityHandlesDay(PfActivityVo activityVo){
        super.getSqlMapClientTemplate().update("updateActivityHandlesDay", activityVo);
    }
    /**
     * 更新协办标识+
     *
     * @param activityId
     */
    public void updateCooperateStateUp(String activityId) {
        super.getSqlMapClientTemplate().update("updateCooperateStateUp", activityId);
    }

    /**
     * 更新协办标识-
     *
     * @param activityId
     */
    public void updateCooperateStateDown(String activityId) {
        super.getSqlMapClientTemplate().update("updateCooperateStateDown", activityId);
    }

    /**
     * 删除一个活动下的任务
     *
     * @param activityId
     */
    public void deleteActivityTask(String activityId) {
        super.getSqlMapClientTemplate().delete("deleteActivityTask", activityId);
    }

    public void deleteTask(String taskId) {
        super.getSqlMapClientTemplate().delete("deleteTask", taskId);
    }


    /**
     * 删除一个工作流实例下的活动
     */
    public void deleteWorkFlowInstanceActivity(String workflowIntanceId) {
        super.getSqlMapClientTemplate().delete("deleteWorkFlowInstanceActivity", workflowIntanceId);
    }

    /**
     * 创建活动
     *
     * @param activityVo
     */
    public void createActivity(PfActivityVo activityVo) {
        super.getSqlMapClientTemplate().insert("createActivity", activityVo);
    }

    /**
     * 创建任务
     *
     * @param taskVo
     */
    public void createTask(PfTaskVo taskVo) {


        super.getSqlMapClientTemplate().insert("createTask", taskVo);
    }

    public void createTaskByHistroy(HashMap<String,Object> mapParam) {

        super.getSqlMapClientTemplate().insert("insertTaskByHistory", mapParam);
    }

    /**
     * 批量创建任务
     *
     * @param tasklist
     */
    public void createTasks(final List<PfTaskVo> tasklist) {
        super.getSqlMapClientTemplate().execute(new SqlMapClientCallback() {
            public Object doInSqlMapClient(SqlMapExecutor executor)
                    throws SQLException {
                executor.startBatch();
                for (int i = 0; i < tasklist.size(); i++) {
                    PfTaskVo pftask = tasklist.get(i);
                    executor.insert("createTask", pftask);
                }
                executor.executeBatch();
                return null;
            }
        });
    }

    public void updateTaskOverTime(String taskId,Date overTime) {
        Map paramMap = new HashMap();
        paramMap.put("taskId",taskId);
        paramMap.put("overTime",overTime);
        super.getSqlMapClientTemplate().update("updateTaskOverTime",
                paramMap);
    }

    public void updateTask(PfTaskVo taskVo) {
        super.getSqlMapClientTemplate().update("updateTask", taskVo);
    }

    public void updateTempTask(String activityId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activityId", activityId);
        paramMap.put("tempActivityId", WorkFlowUtil.buildTEMPActivityId(activityId));
        super.getSqlMapClientTemplate().update("updateTempTask", paramMap);
    }

    public List<PfActivityVo> getActivityByBefore(
            String activityId) {
        List lstObjs = super.getSqlMapClientTemplate().queryForList(
                "getActivityByBefore", activityId);

        return lstObjs;
    }

    public List<PfTaskVo> getTasksByBefore(
            String taskId) {
        List lstObjs = super.getSqlMapClientTemplate().queryForList(
                "getTasksByBefore", taskId);
        return lstObjs;
    }

    public void deleteActivity(String activityId) {
        super.getSqlMapClientTemplate().delete("deleteActivity", activityId);
    }

    public void updateTaskStadus(String taskId){
        super.getSqlMapClientTemplate().update("updateTaskStadus", taskId);
    }

    public String selectIsAcceptedTask(String taskId){
        List result=
                super.getSqlMapClientTemplate().queryForList("selectIsAcceptedTask", taskId);
        if (result!=null && result.size()>0)
            return result.get(0).toString();
        else
            return null;
    }

    public void updateTasksByBefore(String taskId,String taskBeforeId){
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("taskBeforeId", taskBeforeId);
        paramMap.put("taskId", taskId);
        super.getSqlMapClientTemplate().update("updateTasksByBefore", paramMap);
    }

    public void deleteOtherTasks(String taskId){
        super.getSqlMapClientTemplate().delete("deleteOtherTasks",taskId);
    }


}
