package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.plat.vo.PfOpinionVo;


public class SysOpinionDao  extends SqlMapClientDaoSupport {
	
	/**
     * 根据UserID获得默认意见列表
     * @param UserId
	 */
	public List<PfOpinionVo> getOpinionListByUserId(String UserId){
		return  super.getSqlMapClientTemplate().queryForList("getOpinionListByUserId",UserId);
	}

    public List<PfOpinionVo> getOpinionListByUserIdAndDefault(String UserId){
		return  super.getSqlMapClientTemplate().queryForList("getOpinionListByUserIdAndDefault",UserId);
	}

	/**
     * 新增默认意见
     * @param vo
	 */
	public void insertOpinion (PfOpinionVo vo){
		
		super.getSqlMapClientTemplate().insert("insertOpinion", vo);
	}

    /**
     * 更新默认意见
     * @param vo
     */
    public void updateOpinion(PfOpinionVo vo){
        super.getSqlMapClientTemplate().update("updateOpinion",vo);    
    }

	/**
     * 删除默认意见
	 */
	public void deleteOpinion (String opinId){
		
		super.getSqlMapClientTemplate().delete("deleteOpinion", opinId);
	}
	
	/**
     * 根据OPIN_ID查询意见
     * @param OpinId 
	 */
	public PfOpinionVo getOpinionByOpinId(String OpinId){
		return  (PfOpinionVo)super.getSqlMapClientTemplate().queryForObject("getOpinionByOpinId",OpinId);
	}


    /**
     * 根据OPIN_ID更新意见是否 
     * @param map
     */
	public void updateIsUseByOpinId(HashMap<String, String> map){
		super.getSqlMapClientTemplate().update("updateIsUse", map);
	}

    /**
     * 根据条件集合查找意见列表
     * @param params
     * @return
     */
    public List<PfOpinionVo> getOpinionList(HashMap params) {
        return super.getSqlMapClientTemplate().queryForList("getOpinionlist",params);
    }
}
