package com.gtis.plat.dao;

import java.util.HashMap;
import java.util.List;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.gtis.plat.vo.PfPartitionInfoVo;

public class SysAuthorDao extends SqlMapClientDaoSupport {
	/**
	 * 任务列表进入资源权限,只读列表,元素列表
	 * 
	 * @param wdId
	 * @param aId
	 * @param rId
	 * @return
	 */
	public List<PfPartitionInfoVo> getTaskFormAuthorList(String wdId,
			String aId, String rId) {
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("wdId", wdId);
		mapParam.put("aId", aId);
		mapParam.put("rId", rId);
		mapParam.put("oprType", ">0"); // 表示只读

		return super.getSqlMapClientTemplate().queryForList(
				"queryTaskAuthorList", mapParam);
	}

    /**
     * 判断一个特定元素的权限
     * @param wiid
     * @param taskid
     * @param rId
     * @param eleName
     * @return
     */
    public boolean queryTaskElement(String wiid,
			String taskid, String rId,String eleName) {
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("wiid", wiid);
		mapParam.put("taskid", taskid);
		mapParam.put("rId", rId);
        mapParam.put("eleName", eleName);
		List<HashMap> mapresult=super.getSqlMapClientTemplate().queryForList(
				"queryTaskElement", mapParam);
        if (mapresult!=null && mapresult.size()>0){
            return true;
        }
        return false;
	}

	/**
	 * 任务列表进入资源权限,可用列表,功能列表
	 * 
	 * @param wdId
	 * @param aId
	 * @param rId
	 * @return
	 */
	public List<PfPartitionInfoVo> getTaskFormFunAuthorList(String wdId,
			String aId, String rId) {
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("wdId", wdId);
		mapParam.put("aId", aId);
		mapParam.put("rId", rId);
		mapParam.put("oprType", "=0"); // 表示可用
		return super.getSqlMapClientTemplate().queryForList(
				"queryTaskFunAuthorList", mapParam);
	}

	/**
	 * 从系统主界面进入的资源权限,只读列表
	 * 
	 * @param rId
	 * @param rolesId
	 * @return
	 */
	public List<PfPartitionInfoVo> getSystemResrouceAuthorList(String rId,
			String rolesId) {
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("rolesId", rolesId);
		mapParam.put("rId", rId);
		mapParam.put("oprType", ">0"); // 表示只读
		return super.getSqlMapClientTemplate().queryForList(
				"querySystemResourceAuthorList", mapParam);
	}
	
	
	public List<PfPartitionInfoVo> getSystemResrouceEnableList(String rId,
			String rolesId) {
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("rolesId", rolesId);
		mapParam.put("rId", rId);
		mapParam.put("oprType", "=0"); 
		return super.getSqlMapClientTemplate().queryForList(
				"querySystemResourceAuthorList", mapParam);
	}
	
	public List<PfPartitionInfoVo> getPartitionList(String pId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getPartitionList", pId);
	}

    public List<PfPartitionInfoVo> getPartitionFunList(String pId) {
		return super.getSqlMapClientTemplate().queryForList(
				"getPartitionFunList", pId);
	}

	/**
	 * 从项目列表进入资源的权限,只读列表
	 * 
	 * @param rId
	 * @param rolesId
	 * @return
	 */
	// public List<PfPartitionInfoVo> getProjectResrouceAuthorList(String
	// rId,String rolesId){
	// HashMap<String, String> mapParam=new HashMap<String, String>();
	// mapParam.put("rolesId", rolesId);
	// mapParam.put("rId", rId);
	// mapParam.put("oprType", ">0"); //表示只读
	// return
	// super.getSqlMapClientTemplate().queryForList("queryProjectAuthorList",mapParam);
	// }
	/**
	 * 从项目列表进入资源的权限,可用列表,返回xml
	 * <?xml version="1.0" ?>
	 * <Partitions>
	 * <Partition Id="D44CCF86EEC544D5B5C8192FDA12D5BC" OperType="0"/>
	 * </Partitions>
	 * @param rId
	 * @param rolesId
	 * @return
	 */
	public Object getIntanceAuthorXML(String wdid,
			String rId, String rolesId) {
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("rolesId", rolesId);
		mapParam.put("rId", rId);
		mapParam.put("wdid", wdid);
        try{
            return super.getSqlMapClientTemplate().queryForObject(
				"getIntanceAuthorXML", mapParam);    
        }catch(Exception ex){
            return null;
        }

	}

	/**
	 * 从系统主界面进入的资源权限 功能元素,可用列表
	 * 
	 * @param rId
	 * @param rolesId
	 * @return
	 */
	public List<PfPartitionInfoVo> getSystemResrouceFunList(String rId,
			String rolesId) {
		HashMap<String, String> mapParam = new HashMap<String, String>();
		mapParam.put("rolesId", rolesId);
		mapParam.put("rId", rId);
		mapParam.put("oprType", "=0"); // 表示只读
		return super.getSqlMapClientTemplate().queryForList(
				"querySystemFunList", mapParam);
	}

	public String getProjectSByUser(String userIds) {
		List<HashMap> lstResult = super.getSqlMapClientTemplate().queryForList(
				"queryUserProjects", userIds);
		StringBuffer strBuffer = new StringBuffer();
		for (int i = 0; i < lstResult.size(); i++) {
			HashMap map = lstResult.get(i);
			strBuffer.append("'" + map.get("WORKFLOW_DEFINITION_ID") + "',");
		}
		strBuffer.append("'-1'");
		return strBuffer.toString();
	}

	public String getProjectSByUser(String userIds, String workflowDefineId) {
		List<HashMap> lstResult = super.getSqlMapClientTemplate().queryForList(
				"queryUserProjects", userIds);
		StringBuffer strBuffer = new StringBuffer();
		for (int i = 0; i < lstResult.size(); i++) {
			HashMap map = lstResult.get(i);
			if (workflowDefineId.equals(map.get("WORKFLOW_DEFINITION_ID"))) {
				strBuffer
						.append("'" + map.get("WORKFLOW_DEFINITION_ID") + "',");
				break;
			}
		}
		strBuffer.append("'-1'");
		return strBuffer.toString();
	}
}
