package com.gtis.plat.dao;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfStuffFileVo;
import com.gtis.plat.vo.PfStuffInfoVo;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

public class StuffDao extends SqlMapClientDaoSupport {

    public PfStuffInfoVo getStuffInfo(String infoid){
        return (PfStuffInfoVo)super.getSqlMapClientTemplate().queryForObject("getStuffInfo",infoid);
    }

    public PfStuffInfoVo getStuffInfoByProId(String proid){
        return (PfStuffInfoVo)super.getSqlMapClientTemplate().queryForObject("getStuffInfoByProId",proid);
    }

    public PfStuffFileVo getStuffFile(String infoid){
        return (PfStuffFileVo)super.getSqlMapClientTemplate().queryForObject("getStuffFile",infoid);
    }

    public PfStuffInfoVo insertStuffInfo(PfStuffInfoVo info){
        info.setInfoId(UUIDGenerator.generate());
        PfStuffInfoVo temp = (PfStuffInfoVo)super.getSqlMapClientTemplate().insert("insertStuffInfo",info);
        if(info.getFileList() != null){
            for(PfStuffFileVo file : info.getFileList()){
                file.setInfoId(info.getInfoId());
                file = insertStuffFile(file);
            }
        }
        return temp;
    }

    public PfStuffFileVo insertStuffFile(PfStuffFileVo file){
        file.setFileId(UUIDGenerator.generate());
        return (PfStuffFileVo)super.getSqlMapClientTemplate().insert("insertStuffFiles",file);
    }

    public PfStuffFileVo updateStuffFile(PfStuffFileVo file){
        int i = super.getSqlMapClientTemplate().update("updateStuffFileAttr",file);
        return file;
    }

    public void deleteStuffInfo(String infoid){
        super.getSqlMapClientTemplate().delete("deleteStuffInfo",infoid);
    }

    public void deleteStuffFile(String infoid){
        super.getSqlMapClientTemplate().delete("deleteStuffFile",infoid);
    }
}