/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: Rss.js
 *
 * LastModified: 2009-12-03 09:20:44
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Portal.app.Rss = function(config) {
    Ext.apply(this, config);
    var prfs = this.preferences;
    if (prfs['moreUrl']) {
        this.title = ['<a href="',prfs['moreUrl'],'" target="_blank" title="更多"',(prfs['tabId'] ? ' onclick="parent.openMenu(\'' + prfs['tabId'] + '\',\'' + prfs['tabText'] + '\',this.href);return false;"' : ''),'>',this.title,'<img src="',this.basePath,'/portal/images/s.gif" class="portlet-link"/></a>'].join('');
    }

    this.store = new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({
            url: this.preferences['url']
        }),
        reader: new Ext.data.XmlReader({record: 'item'},
                ['title', 'author', 'img',{
                    name:'pubDate',
                    type:'date'
                }, 'link', 'description', 'content']
        )
    });

    var self = this;
    this.dataView = new Ext.DataView({
        monitorResize:true,
        cls:'portlet-rss',
        store: this.store,
        tpl: this.preferences['tpl'] ? new Ext.XTemplate(this.preferences['tpl']) : this.tpls['list'],
        autoHeight:true,
        overClass:'x-view-over',
        itemSelector:'div.item',
        prepareData: function(data, index) {
            data.index = index;
            data.rid = self.id;
            if (!data.img)
                data.img = self.icon;
            return data;
        },
        collectData : function(records, startIndex) {
            var r = [];
            var count = parseInt(prfs['count']);
            for (var i = 0, len = Math.min(records.length, count); i < len; i++) {
                r[r.length] = this.prepareData(records[i].data, startIndex + i, records[i]);
            }
            return r;
        }
    });

    this.store.on('load', function() {
        if (this.linkItems) {
            this.linkItems = null;
        }
        this.contentResize();
    }, this);

    if (prfs['height']) {
        this.height = parseInt(prfs['height']);
    }

    Portal.app.Rss.superclass.constructor.call(this, {
        items:this.dataView
    });

    this.on('bodyresize', this.contentResize, this);
};

Portal.app.Rss.open = function(a) {
    var p = Ext.getCmp(a.getAttribute('rid'));
    var openParams = p.preferences['openParams'];
    var modal = p.preferences['modal'];
    var reload = p.preferences['reload'];
    var maxWindow = p.preferences['maxWindow'];
    var refresh = function() {
        if (reload == 'page') {
            location.replace(location.href);
        } else if (reload = 'app') {
            p.onRefresh();
        }
    };
    if (modal == 'true') {
        if (maxWindow == 'true')
            openParams += 'dialogLeft:0;dialogTop:0;dialogWidth=' + screen.availWidth + 'px;dialogHeight=' + screen.availHeight + 'px';
        showModalDialog(a.href, null, openParams);
        refresh();
    } else if (modal == 'false') {
        var win = window.open(a.href, 'new', openParams);
        if (maxWindow == 'true') {
            win.moveTo(0, 0);
            win.resizeTo(screen.availWidth, screen.availHeight);
        }
        var timer = setInterval(function() {
            try {
                if (!win.document) {
                    refresh();
                    clearInterval(timer);
                }
            } catch(e) {
                refresh();
                clearInterval(timer);
            }
        }, 3000);
    } else {
        return true;
    }
    return false;
};

Ext.extend(Portal.app.Rss, Portal.Portlet, {
    tpls:{
        list:new Ext.XTemplate('<tpl for=".">' +
                '<div class="item no-break clearfix" title="{description:stripTags}">' +
                '<a class="ellipsis" href="{link}" rid="{rid}" target="_blank" onclick="return Portal.app.Rss.open(this)"><img src="portal/images/s.gif" class="arrow"/>{title}</a>' +
                '<div class="date">{pubDate:date("Y-m-d H:i")}</div>' +
                '</div>' +
                '</tpl>'),
        listDate:new Ext.XTemplate('<tpl for=".">' +
                '<div class="item no-break clearfix" title="{description:stripTags}">' +
                '<a class="ellipsis" href="{link}" rid="{rid}" target="_blank" onclick="return Portal.app.Rss.open(this)"><img src="portal/images/s.gif" class="arrow"/>{title}</a>' +
                '<div class="date">{pubDate:date("Y-m-d")}</div>' +
                '</div>' +
                '</tpl>'),
        detail:new Ext.XTemplate('<tpl for=".">' +
                '<div class="item">' +
                '<img src="portal/images/s.gif" class="arrow"/>' +
                '<a href="{link}" rid="{rid}" target="_blank" onclick="return Portal.app.Rss.open(this)">{title}</a>' +
                '&nbsp;{pubDate:date("Y-m-d H:i")}<div class="desc">{description}</div></div>' +
                '</tpl>'),
        pic:new Ext.XTemplate('<tpl for=".">' +
                '<tpl if="index == 0">' +
                '<div>' +
                '<a href="{link}" rid="{rid}" target="_blank" onclick="return Portal.app.Rss.open(this)"><img src="{img}" alt="{title}" class="icon"></a>' +
                '<h3 class="title"><a href="{link}" rid="{rid}" target="_blank" onclick="return Portal.app.Rss.open(this)">{title}</a></h3>' +
                '<p class="desc1">{description}</p>' +
                '</div>' +
                '</tpl>' +
                '<tpl if="index &gt; 0">' +
                '<div class="item"><img src="portal/images/s.gif" class="arrow"/><a href="{link}" rid="{rid}" target="_blank" onclick="return Portal.app.Rss.open(this)">{title}</a></div>' +
                '</tpl>' +
                '</tpl>')
    },
    onRender : function(ct, position) {
        Portal.app.Rss.superclass.onRender.call(this, ct, position);
        this.onRefresh();
        if (this.preferences['autoRefresh']) {
            this.timer = setInterval(this.onRefresh.createDelegate(this), parseInt(this.preferences['autoRefresh']) * 1000 + parseInt(Math.random() * 2000));
        }
    },
    destroy:function() {
        if (this.timer) {
            clearInterval(this.timer);
        }
        Portal.app.Rss.superclass.destroy.call(this);
    },
    onRefresh:function() {
        var style = this.preferences['style'];
        if (style)
            this.dataView.tpl = this.tpls[style];
        this.store.load();
    },
    contentResize:function() {
        if (!this.dataView.rendered)
            return;
        if (!this.linkItems) {
            this.linkItems = this.dataView.el.select('a.ellipsis');
        }
        var w = this.dataView.getWidth();
        this.linkItems.each(function(item) {
            var wh = w - item.next().getWidth() - 30;
            if (wh > 50)
                item.setWidth(w - item.next().getWidth() - 30);
        });
    },
    onConfig:function() {
        if (!this.configWin) {
            this.form = new Ext.FormPanel({
                labelWidth: 60,
                border: false,
                bodyStyle:'padding:10px;',
                defaultType: 'textfield',
                items: [
                    {
                        xtype:'combo',
                        fieldLabel: '显示条数',
                        name: 'count',
                        anchor:'100%',
                        displayField: 'count',
                        mode: 'local',
                        triggerAction: 'all',
                        store: new Ext.data.ArrayStore({
                            fields: ['count'],
                            data: [
                                [1],
                                [2],
                                [3],
                                [4],
                                [5],
                                [8],
                                [10],
                                [12],
                                [15],
                                [20],
                                [25],
                                [30]
                            ]
                        })
                    },
                    {
                        xtype:'combo',
                        fieldLabel:'展示风格',
                        name:'style',
                        anchor:'100%',
                        valueField:'value',
                        displayField:'text',
                        hiddenName:'style',
                        editable:false,
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection:true,
                        store: new Ext.data.ArrayStore({
                            fields: [ 'value', 'text' ],
                            data: [
                                ['list', '列表'],
                                ['listDate', '列表(无分钟)'],
                                ['detail', '详细'],
                                ['pic', '图片']
                            ]
                        })
                    }/*,
                     {
                     style:{paddingTop:'2px'},
                     fieldLabel: '选项',
                     xtype:'checkbox',
                     boxLabel: '模态打开，关闭后刷新',
                     name: 'modal'
                     }*/
                ]
            });
            this.configWin = new Ext.Window({
                cls:'portlet-cfg',
                title:this.title + ' 设置',
                layout:'fit',
                width:320,
                height:170,
                closeAction:'hide',
                modal: true,
                plain: true,
                items:this.form,
                buttons: [
                    {
                        text:'保存',
                        handler: function() {
                            this.saveConfig();
                        },
                        scope:this
                    },
                    {
                        text: '关闭',
                        handler: function() {
                            this.configWin.hide();
                        },
                        scope:this
                    }
                ]
            });
        }
        this.configWin.show(this);
        this.form.form.findField('count').setValue(this.preferences['count']);
        this.form.form.findField('style').setValue(this.preferences['style'] || 'list');
        //this.form.form.findField('modal').setValue(this.preferences['modal']);
    },
    saveConfig:function() {
        var values = this.form.form.getValues();
        /*        if (!values['modal'])
         values['modal'] = '';*/
        Ext.apply(this.preferences, values);
        Ext.apply(this.Personalpreferences, values);
        this.configWin.hide();
        this.onRefresh();
        this.site.setSaveTipVisible(true);
    }
});

