/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: Iframe.js
 *
 * LastModified: 2009-12-09 03:54:48
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

Portal.app.Iframe = function(config) {
    Ext.apply(this, config);
    Portal.app.Iframe.superclass.constructor.call(this, {

    });
};

Ext.extend(Portal.app.Iframe, Portal.Portlet, {
    onRender : function(ct, position) {
        Portal.app.Iframe.superclass.onRender.call(this, ct, position);
        this.onRefresh();
    },
    onRefresh:function() {
        this.body.update('<iframe width="100%" height="' + (this.preferences['height'] || 200) + 'px" frameborder="0" scrolling="auto" src="' + this.preferences['url'] + '"></iframe>');
    },
    onConfig:function() {
        if (!this.configWin) {
            this.form = new Ext.FormPanel({
                labelWidth: 40,
                border: false,
                bodyStyle:'padding:10px;',
                defaultType: 'textfield',
                items: [
                    {
                        fieldLabel:'高度',
                        name: 'height',
                        anchor:'100%'
                    }
                ]
            });
            this.configWin = new Ext.Window({
                cls:'portlet-cfg',
                title:this.title + ' 设置',
                layout:'fit',
                width:320,
                height:120,
                closeAction:'hide',
                modal: true,
                plain: true,
                items:this.form,
                buttons: [
                    {
                        text:'保存',
                        handler: function() {
                            this.saveConfig();
                        },
                        scope:this
                    },
                    {
                        text: '关闭',
                        handler: function() {
                            this.configWin.hide();
                        },
                        scope:this
                    }
                ]
            });
        }
        this.configWin.show(this);
        this.form.form.findField('height').setValue(this.preferences['height'] || 200);
    },
    saveConfig:function() {
        var values = this.form.form.getValues();
        if (!/^[0-9]*[1-9][0-9]*$/.test(values['height'])) {
            Ext.QuickTips.init();
            this.form.form.findField('height').markInvalid('请输入正整数值');
            return;
        }
        Ext.apply(this.preferences, values);
        Ext.apply(this.Personalpreferences, values);
        this.configWin.hide();
        this.onRefresh();
        this.site.setSaveTipVisible(true);
    }
});

