/*
 * Author: xyang
 *
 * Project: egov
 *
 * File: Portlet.js
 *
 * LastModified: 2009-12-03 04:57:07
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
Portal.Portlet = function(config) {
    Ext.apply(this, config);

    if (this.draggable) {
        this.tools = [
            {
                id:'gear',
                scope: this,
                handler: function() {
                    this.onConfig();
                }
            },
            {
                id:'close',
                scope: this,
                handler: function(e, target, panel) {
                    Ext.MessageBox.confirm('确认', '确定要删除这个应用吗?', function(btn) {
                        if (btn != 'yes')
                            return;
                        this.onClose();
                    }, this);
                }
            }
        ];
    }
    Portal.Portlet.superclass.constructor.call(this, {
        cls:'portlet',
        autoScroll:true,
        collapsible:true,
        frame:true
    });
};

Ext.extend(Portal.Portlet, Ext.Panel, {
    onRender:function(ct, position) {
        Portal.Portlet.superclass.onRender.call(this, ct, position);
        this.el.select('.x-tool').setOpacity(.4);
        this.el.hover(function() {
            this.el.select('.x-tool').setOpacity(1);
        }, function() {
            this.el.select('.x-tool').setOpacity(.4);
        }, this);
    },
    onClose:function() {
        this.site.removePortlet(this.id);
    },
    onConfig:function() {
    },
    onRefresh:function() {

    },
    createGhost:function(cls, useShim, appendTo) {
        return Portal.Portlet.superclass.createGhost.call(this, 'portlet', useShim, appendTo);
    },
    serialize:function() {
        return {
            entityId:this.entityId,
            preferences:this.Personalpreferences
        };
    }
});




