<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<!DOCTYPE HTML>
<html>
<head>
<title>工作流统计</title>
<script src="${pageContext.request.contextPath}/global/highcharts/highcharts.js"></script>
<script src="${pageContext.request.contextPath}/global/ext/ext-base.js"></script>
<script src="${pageContext.request.contextPath}/global/ext/ext-all.js"></script>
<script src="${pageContext.request.contextPath}/global/ext/ext-lang-zh_CN.js"></script>
</head>
<body style="padding:0px; margin:0px">
	<ul class="in_menu clearfix" style="margin: 8px;">
		<li style="display: inline; float:left; font-weight: bold;"><a href="#" onclick="changeTabChart('week', this)">本周</a></li>
		<li style="display: inline; float:left; margin-left: 5px; font-weight: bold;"><a href="#" onclick="changeTabChart('month', this)">本月</a></li>
		<li style="display: inline; float:left; margin-left: 5px; font-weight: bold;"><a href="#" onclick="changeTabChart('quarter', this)">本季度</a></li>
	</ul>
	<div id="workflow_chart"></div>
    <script type="text/javascript">
    (function( $, ctx ){
        var categories = ${categories};//['土地登记', '建设用地预审', '地块内部审查', '分批次报件', '独立选址'];
        var series = ${series};//[{name: '总数量',data: [107, 31, 635, 203, 2]}, {name: '正在办理',data: [133, 156, 947, 408, 6]}, { name: '已办结',data: [973, 914, 4054, 732, 34]}];
        $('#workflow_chart').highcharts({
            chart: {
                type: 'bar',
                backgroundColor :null,
                width:220,
                height:300
            },
            title: {
                text: '工作流统计',
                style: {
                    fontSize: '16px',
                    color: '#2F4F4F',
                    fontWeight:'bold',
                    display: 'none'
                }
            },
            xAxis: {
                categories: categories,
                title: {
                    style : {
                        'color' : '#e70731'
                    }
                }
            },
            yAxis: {
                min: 0,
                title: {
                    //text: '办理数量(个)',
                    style : {
                        'color' : '#0364D1'
                    }
                },
                labels: {
                    overflow: 'justify',
                    formatter: function(){
                        var yValue = Math.abs(this.value);
                        if(yValue>=10000){
                                return (yValue/10000)+"万";
                        }else if(yValue>=1000){
                                return (yValue/10000)+"千";
                        }else{
                                return ""+yValue;
                        }
                    }
                }
            },
            tooltip: {
                style:{
                    'color':'#e70731'
                },
                valueSuffix: '个'
            },
            plotOptions: {
                bar: {
                    dataLabels: {
                        enabled: true
                    }
                }
            },
            legend: {
                x: 0,
                y: 10,
                floating: true,
                borderWidth: 1,
                backgroundColor: '#FFFFFF',
                reversed: true
            },
            credits: {
                enabled: false
            },
            series: series
        });

        /**
         * 根据tab类型和页面id进行数据的切换
         * @param type
         * @param pageId
         */
        ctx.changeTabChart = function(type, dom){
            // if(!type){
            //     type = "week";//默认是json文件的第一个数据
            // }
            type = type || 'week';
            if( $(dom).parent().hasClass('active') ){
                return;
            }
            $(dom).parent().addClass('active').siblings().removeClass('active');
            var url = "${pageContext.request.contextPath}/workflowstat!getWFChartDate.action?countType="+type;
            $.post(url, function(data) {
                if (data != "") {
                    data= $.trim(data);
                    var responseJson = Ext.util.JSON.decode(data);
                    if(responseJson.result == 'true'){
                        var categories_temp = Ext.util.JSON.decode(responseJson.categories);
                        var series_temp = Ext.util.JSON.decode(responseJson.series);
                        // console.debug(categories_temp);
                        // console.debug(series_temp);
                        var theChart = $('#workflow_chart').highcharts();
                        theChart.xAxis[0].setCategories(categories_temp);
                        for(var i=0;i<theChart.series.length;i++){
                            theChart.series[i].setData(series_temp[i]['data']);
                        }
                    }
                }
                Ext.Msg.hide();
            });
        }
        $(".in_menu").children('li:first-child').children().click();
        // $(".in_menu").children('li').children().click(in_load.changeTabChart);
        // var date = new Date();
        // in_load.changeTabChart.apply($(".in_menu").children('li:first-child').children());

        // in_load.changeTabChart();
        // console.debug('执行时间:' + (new Date().getTime() - date.getTime()));
    }(jQuery, window));
    </script>
</body>
</html>
