<%@ page language="java" pageEncoding="utf-8"%>
<%@ taglib prefix="g" uri="/gtis-tags" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
  <head>
    <title>已办任务列表</title>
    <g:head useFlash="false" useExt="true" cookie="false" useJQuery="true"/>
    <style type="text/css">
        .x-grid3-cell-inner{
            padding-bottom: 0px;
        }
        .row-ul li {
            list-style: none;
            color: #666666;
        }
        .row-ul li span {
            color: #888888;
            position:relative;
            top:-3px;
            left:2px;
        }

    </style>

    <script type="text/javascript" src="${pageContext.request.contextPath}/global/xdate/xdate.js"></script>
    <script type="text/javascript" src="${pageContext.request.contextPath}/global/artTemplate/template.js"></script>
    <script id="Img_Template" type="text/html">
        <ul class="row-ul">
            {{if ISEND}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/over.gif' title="结束"/>
            </li>
            {{/if}}
            {{if ISACTIVE}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/active.gif' title="活动"/>
            </li>
            {{/if}}
            {{if PRIORITY==3}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/star3.png' title="紧急"/>
            </li>
            {{/if}}
            {{if PRIORITY==2}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/star2.png' title="特急"/>
            </li>
            {{/if}}
            {{if POST}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/post.gif' title="挂起"/>
            </li>
            {{/if}}
            {{if OVER}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/chaoqi.png' title="超期"/>
            </li>
            {{/if}}

            {{if ISBACK}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/back.png' title="退回"/>
            </li>
            {{/if}}

            {{if MONITOR}}
            <li style="float: left;margin-right:2px">
                <img src='${pageContext.request.contextPath}/common/images/duban.png' title="督办"/>
            </li>
            {{/if}}
        </ul>
    </script>
    <script id="Title_Template" type="text/html">
      <ul class="row-ul">
          <li>
          <b>{{WORKFLOW_INSTANCE_NAME}}</b>
          </li>
          <li style="padding-top: 2px;">
              <div style="overflow: hidden;float:left;margin-right:5px">
                  <img src="${pageContext.request.contextPath}/common/images/flow.gif" border="0" style="cursor:pointer" onclick="window.open('${pageContext.request.contextPath}/showchart.action?wiid={{WORKFLOW_INSTANCE_ID}}','流程图','toolbar=no,scrollbars=yes, location=no,directories=no, menubar=no,resizable=yes,top=0,left=0,width='+(screen.availWidth-10)+',height='+(screen.availHeight-30));"/>
              </div>{{WORKFLOW_NAME}}&nbsp;&nbsp;&nbsp;&nbsp;[当前活动：{{ACTIVITY_NAME}}] &nbsp;&nbsp;&nbsp;&nbsp;
              {{if REMARK!=""}}
              [{{REMARK}}]
              {{/if}}
          </li>
      </ul>
    </script>
      <script id="FinishTime_Template" type="text/html">
          <ul class="row-ul">
              <li>
                  {{FINISH_TIME}}
              </li>
              <li style="padding-top: 2px;">
                 {{FINISH_TIME_COUNT}}
              </li>
          </ul>
      </script>
      <script id="Turn_Template" type="text/html">
          <ul class="row-ul">
              <li>
                  <span type="turn" taskid="{{ASSIGNMENT_ID}}"></span>
              </li>
              <li style="padding-top: 2px;">
                  {{CREATE_TIME}}
              </li>
          </ul>
      </script>
	<script type="text/javascript">
        //状态
        function statafunction(val, p, record){

            var postStat=false;
            var isEnd=false;
            var isActive=true;
            if (val==3)
                postStat=true;
            else if(val==1){
                isEnd=false;
                isActive=true;
            }else if(val==2){
                isEnd=true;
                isActive=false;
            }


            var ISBACK=false;
            if (record.data.ISBACK*1.0>0 ) ISBACK=true;

            var MONITOR=false;
            if(record.data.MONITOR_ID && record.data.MONITOR_ID!="" ) MONITOR=true;

            var OVER=false;

            var cDate=new XDate(record.data.FINISH_TIME);
            if (record.data.TASK_OVER_TIME && record.data.TASK_OVER_TIME!="") {
                var taskOverTime = new XDate(record.data.TASK_OVER_TIME);
                if (taskOverTime.valueOf()<cDate.valueOf()) OVER=true;
            }
            return template('Img_Template', {
                PRIORITY:record.data.PRIORITY,
                POST:postStat,
                ISBACK:ISBACK,
                MONITOR:MONITOR,
                OVER:OVER,
                ISEND:isEnd,
                ISACTIVE:isActive
            });

            var monitor="";

            var sup="";
            if(record.data.MONITOR_ID && record.data.MONITOR_ID!="" ){
                var workflowInstanceId = record.data.WORKFLOW_INSTANCE_ID;
                var workflowInstanceName=record.data.WORKFLOW_INSTANCE_NAME;
                var workflowName = record.data.WORKFLOW_INSTANCE_NAME;
                var activityId=record.data.ACTIVITY_ID;
                var userId = record.data.USER_ID;
                sup = "<img ext:qtip='督办' src='${pageContext.request.contextPath}/common/images/supd.png' style=\"cursor : hand\" onclick=\"javascript:detailHandler(\'" + workflowInstanceId + "\',\'" + activityId + "\',\'" + workflowInstanceName + "\',\'" + userId + "\')\"/>";
            }

        }


        function dateformat(val, p, record){
            if (val && val!=''){
                if (val.length==19)
                    return val.substring(0,10);
            }
        }

        function rowdbclick(gridobj,rowindex,event){
            var gdata=gridobj.store;
            if(gdata.getAt(rowindex).data.WORKFLOW_STATE != 3) {
                var taskId=gdata.getAt(rowindex).data.ASSIGNMENT_ID;
                var w_width=screen.availWidth-10;
                var w_height= screen.availHeight-32;
                var url='${pageContext.request.contextPath}/taskoverhandle.action?taskid=' + taskId;
                window.open(url, "_task", "left=1,top=0,height="+w_height+",width="+w_width+",resizable=yes,scrollbars=yes");
            }else {
                alert("文件挂起中，请解挂后再查看！");
            }
        }

        function showHandler(val,p,record){
            if(val != null){
                return "<div ext:qtip='" + val + "'>" + val + "</div>";
            }
        }

        //刷新任务
        function refreshTask(){
            var gridobj=Ext.getCmp("gridobj");
            if (gridobj)
                gridobj.refresh();
        }

        function BusinessChange(value){
            Ext.Ajax.request({
                url: '${pageContext.request.contextPath}/tasklist!getWorkFlowDefineList.action',
                success: function(r){
                    var selectCmb=Ext.getCmp("cmb_WORKFLOW_DEFINITION_ID");
                    selectCmb.store.loadData(eval(r.responseText));
                },
                method:'POST',
                params: {businessid:value}
            });
        }


        function titleHandler(val,p,record){
            var remark="";
            if (record.data.REMARK && record.data.REMARK!="")
                remark= record.data.REMARK;
            return template('Title_Template', {
                WORKFLOW_INSTANCE_NAME:record.data.WORKFLOW_INSTANCE_NAME,
                WORKFLOW_NAME:record.data.WORKFLOW_NAME,
                ACTIVITY_NAME:record.data.ACTIVITY_NAME,
                ASSIGNMENT_ID:record.data.ASSIGNMENT_ID,
                WORKFLOW_INSTANCE_ID:record.data.WORKFLOW_INSTANCE_ID,
                REMARK:remark
            });
        }

        function finishHandler(val,p,record){
            var finishTime="";
            var finishTimeCount="";
            if (val && val!=""){
                var curDate = new XDate(record.data.BEGIN_TIME);
                var rdate = new XDate(val);
                var hours=rdate.diffHours(curDate);
                var days= Math.floor((Math.abs(hours)/24));
                hours=Math.ceil(Math.abs(hours)-days*24,0);
                if (hours==24){
                    days++;
                    hours=0;
                }else if (hours==0){
                    hours=1;
                }

                if (days>0)
                    finishTimeCount=finishTimeCount +days + "天";
                if (hours>0)
                    finishTimeCount=finishTimeCount +hours + "小时";
                finishTime=rdate.toString("yyyy年MM月dd日 HH:mm");
            }
            return template('FinishTime_Template', {
                FINISH_TIME:finishTime,
                FINISH_TIME_COUNT:finishTimeCount
            });
        }

        function senderHandler(val,p,record){
            var sdate=new XDate(record.data.BEGIN_TIME);
            var senderTime = sdate.toString("yyyy年MM月dd日 HH:mm");
            return template('Turn_Template', {
                CREATE_TIME:senderTime,
                ASSIGNMENT_ID:record.data.ASSIGNMENT_ID
            });
        }

        function overHandler(val,p,record){
            if (val && val!="") {
                var rdate = new XDate(val);
                return rdate.toString("yyyy年MM月dd日 HH:mm");
            }else{
                return "-";
            }
        }

        function _GridLoadEvent(){

            //通过ajax获取转发人
            $("span[type='turn']").each(function(){
                var taskid=$(this).attr("taskid")
                if (taskid)
                    $(this).load("taskhandle!getSenderUsers.action?taskid=" + taskid);
            });
            //通过ajax取得退回信息
        }
	</script>
  </head>
  
  <body>
    <g:list id="gridobj" width="100%" checkbox="true" keyField="ASSIGNMENT_ID" splitInfo="splitParam"
            gridHeightOffset="-1" contentHeightOffset="-100" rowdbclick="rowdbclick" remoteSort="true" rowHeight="32">
    	<g:query>
    		<g:queryItem label="项目名称"  name="WORKFLOW_INSTANCE_NAME"/>
            <g:queryItem label="创建人" name="CREATE_USERNAME" />
    		<g:queryItem label="备注" name="REMARK" />
            <g:queryItem label="流程类型" itemType="combo" name="WORKFLOW_DEFINITION_ID"
    		showFieldName="workflowName" valueFieldName="workflowDefinitionId" 
    		source="lstWorkFlowDefine"/>
    		<g:queryItem label="开始时间(从)"  itemType="datefield" name="BEGIN_TIME" defaultValue="${lastDate}"/>
            <g:queryItem label="开始时间(至)" itemType="datefield" name="FINISH_TIME" />
    	</g:query>
        <g:toolbar>
            <g:tool text="请选择业务..." itemType="combo" name="BUSINESS_ID" showFieldName="businessName" valueFieldName="businessId" width="120"
                    source="businessList" change="BusinessChange"/>
            <g:tool text="编号查询" name="PROID"  itemType="trigger" width="100" icon="${pageContext.request.contextPath}/pf/images/smq.png" visible="${barCodeQuery}"  />
        </g:toolbar>
    	<g:field fieldname="WORKFLOW_STATE"  header="状态" width="44" renderer="statafunction" sortable="false"/>
    	<g:field fieldname="WORKFLOW_INSTANCE_NAME" header="任务描述" width="-1" renderer="titleHandler" sortable="false"/>
        <g:field fieldname="FINISH_TIME" header="任务完成时间" width="140" renderer="finishHandler" sortable="true"/>
        <g:field fieldname="BEGIN_TIME" header="转发信息" width="160" renderer="senderHandler" sortable="true"/>
        <g:field fieldname="TASK_OVER_TIME" header="任务截止时间" width="150" renderer="overHandler" sortable="true"/>
    	<%--<g:field fieldname="CREATE_TIME" header="收件信息" width="82" renderer="dateformat" sortable="true" hidden="true"/>--%>
        <g:field fieldname="OVER_TIME" onlyRead="true"/>
        <g:field fieldname="ACTIVITY_NAME" onlyRead="true"/>
        <g:field fieldname="BUSINESS_ID" onlyRead="true" />
        <g:field fieldname="ASSIGNMENT_ID"  onlyRead="true"/>
        <g:field fieldname="REMARK" onlyRead="true"/>
        <g:field fieldname="IS_RISK" onlyRead="true"/>
        <g:field fieldname="WORKFLOW_NAME"  onlyRead="true"/>
        <g:field fieldname="WORKFLOW_INSTANCE_ID" onlyRead="true" />
        <g:field fieldname="CREATE_USERNAME" onlyRead="true"/>
    </g:list>
  </body>
</html>
