/*! gtmap-platform - 2013-10-09 */
// Avoid `console` errors in browsers that lack a console.
(function() {
    var method;
    var noop = function () {};
    var methods = [
        'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
        'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
        'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
        'timeStamp', 'trace', 'warn'
    ];
    var length = methods.length;
    var console = (window.console = window.console || {});

    while (length--) {
        method = methods[length];
        // Only stub undefined methods.
        if (!console[method]) {
            console[method] = noop;
        }
    }
}());
// stop default link behavior
$(document).on('click', '[href="#"],.disabled', function(e) {
  e.preventDefault();
});
// jquery ajax quick usage
var ajax = function(url, success, error) {
  $.ajax({
    url : url,
    dataType : 'json',
    type : 'get',
    cache : false,
    success : success,
    error : function(){
      console.error(arguments);
    }
  });
};
/*
 * 加载左侧的菜单树并显示
 */
(function($){
  // 获得submenu模板
  var getMenuString = function( menu ){
    var back = '<ul class="m2u">';
    for( var i in menu ){
      back += '<li>';
      if( menu[i].children ){
        back += '<a href="#" class="m2t" data-id="'+menu[i].id+'" data-link="'+menu[i].link+'" data-name="'+ menu[i].text +'" onclick="openPage.apply(this);">'+ menu[i].text +'</a>';
        for(var j in menu[i].children){
            back += '<a href="#" class="m2a" data-id="'+menu[i].children[j].id+'" data-link="'+menu[i].children[j].link+'" data-name="'+ menu[i].children[j].text +'" onclick="openPage.apply(this);">'+ menu[i].children[j].text +'</a>';
        }
      }else{
        back += '<a data-id="'+menu[i].id+'" data-link="'+menu[i].link+'" data-name="'+ menu[i].text +'">'+ menu[i].text +'</a>';
      }
      back += '</li>';
    }
    back += '</ul>';
    return back;
  }

  //手风琴插件
  $.fn.accordion = function( url ){
    var $menu = this;

    url && $.ajax({
      url : url,
      dataType : 'json',
      type : 'post',
      cache : false,
      success : function( resp ){
        var menu = resp;
        var back = '';
        var item, cssIcon;
        for( var i in menu ){
          item = menu[i];
          cssIcon = item.icon ? 'background-image: url('+ item.icon +');' : '';
          back += '<li class="m1">';
          back += '<a class="root-toggle m1a" style="'+cssIcon+'" data-link="'+ item.link +'" data-name="'+ item.text +'" data-id="'+ item.id +'">'+ item.text +'</a>';

          if( item.children && item.children.length > 0 ){
            back += getMenuString(item.children);
          }
          back += '</li>';
        }
          $menu.html(back);
          $menu.find('.m1').hover(function () {
              $(this).addClass('m1-active');
              var ct = $('ul.m2u', this);
              if (ct[0]) {
                  var i = $(document).height() - ct.height() - ct.offset().top;
                  console.log(i);
                  if (i < 0) {
                      console.log(ct.position().top);
                      ct.css({top: ct.position().top + i - 20});
                      console.log(ct.position().top);
                  }
              }
          }, function () {
              $(this).removeClass('m1-active');
          })
      },
      error : function(){
       alert('加载主菜单失败');
      }
    });

  };
}(jQuery));
/*
 * tab页组件
 */
(function($){
  $('.J_tabs').on('click', 'a', function(){
     var $self = $(this);

     if( $self.hasClass('active') ) return false;

     var $tabs = $self.siblings()
        , itemId = $self.attr('href') || $self.data('href')
        , $item = $(itemId)
        , $items = $item.siblings();

     $items.css('display','none');
     $item.css('display', 'block');
     $tabs.removeClass('active');
     $self.addClass('active');
     return false;
  });

  $('.J_tabs').children('.active').each(function(){
    $( $(this).attr('href') ).css('display', 'block');
  });
}(jQuery));
/*
 * 工作区自适应组件
 */
(function($){
  $.fn.workbench = function( opts ){
    var defaults = {
      topElems : [],
      fixHeight : 0
    }
    var options = $.extend(true, defaults, opts);
    var elemsSelectors = options.topElems.length && options.topElems;
    var $win = $(window);
    var self = this;

    function resize(){
      var height = 0;
      for( var i in elemsSelectors ){
        height = $(elemsSelectors[i]).height();
      }
      self.height( $win.height() - height - options.fixHeight);
    }
    resize();
    $win.resize(resize);

    return this;
  }
}(jQuery));
/*
 * Tab页管理(依赖tab页组件)
 */
(function($, global){
  var $pageTab = $('#J_tab');// 页眉tab
  var $pageNav = $('#J_pageTabNav');// 页眉tab外层容器
  var $tabRelWrap = $('#J_tabRelWrap');// tabs按钮外层
  var $tabCtn = $('#J_tab_content');// tab items
  var $lrToggles = $pageNav.children('.lrtoggle');//左右移动按钮
  //检查tab按钮的个数进行相应操作
  var checkTabNumber = function(){
    //根据tabs个数显示、隐藏pageNav
    $pageTab.children().length <= 1 ? $pageNav.css('display', 'none') : $pageNav.css('display', 'block');
    //pageTab.width > tabRelWrap 显示 toggles
    if( $pageTab.width() < $tabRelWrap.width() ){
      $lrToggles.css('display', 'none');
      $pageTab.css('left', 0);
    }else{
      $lrToggles.css('display', 'block');
    }
  };
  checkTabNumber();

  //滚动tabs
  var intervalFunc;
  var moveTabs = function( isNext ){
    if( isNext ){
      intervalFunc = setInterval(function(){
        var currentLeft = parseInt( $pageTab.css('left') );
        var chazhi = $pageTab.width() - $tabRelWrap.width();
        if( chazhi < 0 || 0-currentLeft > chazhi + 5 ){
          clearInterval(intervalFunc);
          return;
        }
        currentLeft = currentLeft - 5;
        $pageTab.css('left', currentLeft);
      }, 16);
    }else{
      intervalFunc = setInterval(function(){
        var currentLeft = parseInt( $pageTab.css('left') );
        if( currentLeft > 0 ){
          clearInterval(intervalFunc);
          return;
        }
        currentLeft = currentLeft + 5;
        $pageTab.css('left', currentLeft);
      }, 16);
    }
  }
  //pageNav点击next, prev滑动
  $lrToggles.bind('mousedown', function(){
    moveTabs( $(this).hasClass('next') );
  });
  //释放鼠标清除定时函数
  $(document).bind('mouseup', function(){
    intervalFunc && clearInterval(intervalFunc);
  });
  //window resize时
  $(window).resize(function(){
    //重设tabRelWrap的宽度
    $tabRelWrap.width( parseInt($(window).width()) - 380 - 360 );
    checkTabNumber();
  });
  $tabRelWrap.width( parseInt($(window).width()) - 380 - 360 );
  //tab点击后显示到视野中
  $pageTab.on('click', 'a', function(){
    var $self = $(this);
    var offsetL = $self.offset().left;
    var ptOffsetL = $tabRelWrap.offset().left;
    var ptW = $tabRelWrap.outerWidth();
    var tabsLeft = $pageTab.css('left');
    var tabsOffsetL = $pageTab.offset().left;
    if( offsetL < ptOffsetL ){
      $pageTab.css('left','-' + (offsetL - tabsOffsetL - 4) + 'px');
    }else if( (offsetL + $self.outerWidth()) > (ptW + ptOffsetL) ){
      $pageTab.css('left','-' + (offsetL + $self.outerWidth() - ptW - ptOffsetL - parseInt(tabsLeft) + 4) + 'px');
    }
    checkTabNumber();
  });
  // 点击主菜单，或者iframe中的触发器都会进行打开页面操作
  global.openPage = function(){
    var href = $(this).data('link');
    if( href && href !== 'undefined' && href !== 'null' ){
      PageMgr.open( $(this).data('id'), href, $(this).data('name') || $(this).html() );
    }
    return false;
  }

  window.openMenu=function(id, text, url){
    PageMgr.open( id, url, text);
  }

  window.openRes = function (index) {
    if (index == "1") {
      openMenu("9F22AC79323A4BE99283E709CE5856E9", "新建任务", "SysResource.action?rid=7EB5822AFCF0427BBDE1CAAE8FB40AE8");
    } else if (index == "2") {
      openMenu("2213BA9BC38D4F069CCBCD780DE1A1D5", "待办任务", "tasklist.action");
    } else if (index == "3") {
      openMenu("50F3CA1EA7E54D93A2402A5BDD8A0892", "发送消息列表", "SysResource.action?rid=D4628130EAE54C51BDB833192C6010A4");
    } else if (index == "4") {
      openMenu("9ABAE47CCE8645A18D52211F565CC6C7", "工作流统计", "SysResource.action?rid=1A8F8CC0805941ADA2AEC4EB3911FE6F");
    } else if (index == "5") {
      openMenu("D62FF9D48CDE43439A4AF1F46C69BED9", "通知", "SysResource.action?rid=89EE1AD41A4A4178A68D9E62D666C58B");
    } else if (index == "6") {
      openMenu("E778DB87D8E940289A823F5812CD4F76", "项目列表", "SysResource.action?rid=79420540460A4E6FA2F7BA27E46009DA");
    } else if (index == "7") {
      openMenu("7B4E7E7168EF47999F985B42F8BF469F", "意见维护", "SysResource.action?rid=A1E5737BC68A4612A7BA0FC61B0CE9F9");
    } else if (index == "8") {
      openMenu("BF16D75B972947C992115ADDA2F30682", "已办任务", "SysResource.action?rid=0DAFD5F01E4343738920587691B6C399");
    } else if (index == "9") {
      openMenu("68CBBD09037A48F09F93BED6CBB44CC8", "超期任务", "SysResource.action?rid=88CBBD09037A48F09F93BED6CBB44CC8");
    }
  }

  // 点击关闭tab按钮
  $pageTab.on('click', '.close', function(){
    var $prev = $(this).parent('a').prev();
    PageMgr.close( $(this).parent('a').data('id') );
    $prev.click();
    return false;
  });
  //页面管理器
  var PageMgr = {
    pages : {},
    current : null,
    open : function( id, href, name ){
      if( href.length < 5 ){
        return;
      }
      var contains = false;
      for( var i in this.pages ){
        if( i === id && this.pages[id]){
          contains = true;
          break;
        }
      }
      if( !contains ){
        this.pages[id] = new Page( id, href, name );
      } else {
        this.pages[id].$tab.click();
        if( this.pages[id].href !== href ){
          this.pages[id].changePage( href );
        }
      }
    },
    close : function(id){
      this.pages[ id ].close();
      this.pages[ id ] = null;
    }
  };
  //页面对象
  var Page = function(id, href, name){
    this.href=href;
    this.$tab = $('<a data-href="#content'+ id +'" data-id="'+id+'">'+name+'<span class="close">&nbsp;</span></a>');
    $pageTab.append(this.$tab);
    this.$ctn = $('<div id="content'+ id +'" class="item"><iframe src="'+href+'" frameborder="0"></iframe></div>');
    $tabCtn.append(this.$ctn);
    this.$tab.click();
  };
  Page.prototype = {
    close : function(){
      this.$ctn.remove();
      this.$tab.remove();
    },
    changePage : function(href){
      this.href = href;
      this.$ctn.children('iframe').attr('src', href);
    }
  };
}(jQuery, window));