Ext.app.resourceLoad = Ext.extend(Ext.ux.XmlTreeLoader, {
    processAttributes : function(attr) {
        attr.text = attr.Name;
        attr.id = attr.Id;
        attr.loaded = true;
        if (attr.Type == "0") {
            attr.leaf = false;
            attr.expanded = true;
        } else {
            attr.leaf = true;
        }
    }
});

Ext.onReady(function() {
    Ext.QuickTips.init();

    var contentPanel =new Ext.TabPanel({
        id:'content-panel',
        region:'center',
        enableTabScroll:true,
        activeTab:0,
        margins:'2 5 5 0'
    });
    var treePanel = new Ext.tree.TreePanel({
        id: 'tree-panel',
        region:'north',
        split: true,
        height: 250,
        minSize: 150,
        autoScroll: true,
        // tree-specific configs:
        rootVisible: false,
        lines: false,
        singleExpand: true,
        useArrows: true,
        loader: new Ext.app.resourceLoad({
            dataUrl:_menuurl
        }),
        root: new Ext.tree.AsyncTreeNode()
    });
    var menuClickFunction= function(node){
        if (!node.isLeaf()) {
            return false;
        }
        var tabId = 'tab-' + node.id;
        var tabTitle = node.text;
        var tablink = _resourceUrl + node.id;
        var tabJsArray = node.attributes.jsArray;//得到js文件存放的路径
        var tab = contentPanel.getComponent(tabId);//得到tab组建
        if (!tab) {
            var html = '<iframe style="z-index: -1;" id=\'frame_' + node.id + '\' src=\'' + tablink + '\' width="100%" height="100%" frameborder="0"></iframe>';
            tab = contentPanel.add(new Ext.Panel({id:tabId,title:tabTitle,autoScroll:true,layout: 'fit',border:false,closable:true,html:html}));
            contentPanel.setActiveTab(tab);
        } else {
            contentPanel.setActiveTab(tab);
            var ff = document.getElementById('frame_' + node.id);
            if (ff)
                ff.src = tablink;
        }
        return false;
    };
    treePanel.on('click', menuClickFunction);
    contentPanel.on('tabchange', function(tab, newtab){
        if (!newtab)
            return;
        //如果存在相应树节点，就选中,否则就清空选择状态
        var nodeId = newtab.id.replace('tab-', '');
        var node = treePanel.getNodeById(nodeId);
        if (node) {
            treePanel.getSelectionModel().select(node);
        } else {
            treePanel.getSelectionModel().clearSelections();
        }
    });


    var detailsPanel = new Ext.Panel({
        id: 'details-panel',
        region: 'center',
        bodyStyle: 'padding-bottom:15px;background:#eee;padding:6px',
        autoScroll: true,
        items:[{
            id: 'details_info',
            title: '项目信息',
            margins:'10 5 5 10',
            contentEl:'divDetail',
            collapsible: true,
            style:'padding-bottom:15px;',
            tools:[{
                id:"refresh",
                qtip:"刷新关联项目",
                handler:function(){
                    BeginQueryRelatedProj();
                }
            }
            ]
        },{
            id: 'kcdj_info',
            title: '地图数据',
            margins:'10 5 5 10',
            contentEl:'divKcdj',
            collapsible: true,
            style:'padding-bottom:15px;'
        },{
            id: 'details_file',
            title: '附件材料',
            margins:'0 5 5 10',
            contentEl:'fileDetail',

            tools:[{
            	id:'search',
                qtip: '打开附件',
                handler: function(){
                    addFile(_fileCenterRootId);
                }},{
                id:'refresh',
                qtip: '刷新附件',
                // hidden:true,
                handler: function(){
                    BeginQueryFile();
                }},{
                id:'toggle',
                // hidden:true,
                handler: function(event, toolEl, panel){
                    var filePanel= Ext.getCmp("details_file");
                    if (!filePanel.collapsed)
                        filePanel.collapse(true);
                    else
                        filePanel.expand(true);
                }}
            ]
        }]
    });

    treePanel.on('load', function(node, e) {
        var fNode = getFirstRootNode(node);
        if (fNode != null)
            menuClickFunction(fNode);
    });
    new Ext.Viewport({
        layout: 'border',
        items: [{
            xtype: 'box',
            region: 'north',
            applyTo: 'divHeader',
            height: 30
        },{
            title: '项目菜单',
            layout: 'border',
            id: 'layout-browser',
            region:'west',
            border: false,
            split:true,
            margins: '2 0 5 5',
            width: 190,
            minSize: 100,
            maxSize: 500,
            collapsible: true,
            items: [treePanel, detailsPanel]
        },
            contentPanel
        ],
        renderTo: Ext.getBody()
    });
    BeginQueryFile();
    BeginQueryRelatedProj();
    $("#divtools>div").hover(
        function () {
            $(this).attr("style","color: #fff;cursor:pointer;");
            $(this).find("div").attr("style","color: #fff;cursor:pointer;");
        },
        function () {
            $(this).removeAttr("style");
            $(this).find("div").removeAttr("style");
        }
    );
    $("#div_exit").click(function(){
        if (confirm("是否确认退出！")) {
            refreshTask();
        }
    });

    $("#div_back").click(function(){
        if (!confirm("是否确认进行取回！")) {
            return;
        }
        var delUrl = "./task!retrieve.action?taskid=" + _taskId;
        $.post(delUrl, function(data) {
            data = $.trim(data);
            if (data != "") {
                alert(data);
            } else {
                alert("取回成功！");
                Ext.util.Cookies.set('portlet_key','tasklist');
                window.close();
                try {
                    opener.refreshTask(); //刷新父页面
                } catch(ex) {

                }
            }
        });
    });
  //扩展属性中关于勘测定界管理模块的配置属性获取
    if(!_kcdjTypeConfig){
    	$('#kcdj_info').hide();
    }else{
    	_kcdjTypeConfig = parseInt(_kcdjTypeConfig)
    	$('#kcdj_bg').hide();
    	$('#kcdj_jzd').hide();
    	$('#kcdj_map').hide();
        switch (_kcdjTypeConfig) {
    	case 1:
    		// 代码为1时，只显示图形浏览功能
    		$('#kcdj_map').show();
    		break;
    	case 2:
    		// 代码为2时，显示界址点成果和图形浏览功能
    		$('#kcdj_jzd').show();
        	$('#kcdj_map').show();
    		break;
    	case 3:
    		// 代码为3时，显示勘测定界、界址点成果、图形浏览功能
    		Ext.getCmp("kcdj_info").setTitle("勘测定界成果");
    		$('#kcdj_bg').show();
        	$('#kcdj_jzd').show();
        	$('#kcdj_map').show();
    		break;
    	case 8:
    		// 代码为8时，显示界址点成果和图形浏览功能，且界址点成果可编辑
    		$('#kcdj_jzd').show();
        	$('#kcdj_map').show();
    		break;
    	case 9:
    		// 代码为9时，显示勘测定界、界址点成果、图形浏览功能，且勘测定界、界址点成果可编辑
    		Ext.getCmp("kcdj_info").setTitle("勘测定界成果");
    		$('#kcdj_bg').show();
        	$('#kcdj_jzd').show();
        	$('#kcdj_map').show();
    		break;
    	default:
    		//默认不显示勘测定界成果模块
    		$('#kcdj_info').hide();
    	}
    }
});
function showKcdj(type,proid){
	if(type){
		var typeName="勘测定界";
		var url = "";
		if(type == 'kcdj'){
			url = "/buildland/surveybound/kcdj-main!openKcdjMain.action?proid="+proid+"&readOnly=true";
		}else if(type == 'jzd'){
			url = "/buildland/surveybound/kcdj-jzd.action?proid="+proid+"&readOnly=true";
			typeName="界址点查看";
		}else if(type == 'map'){
			url = "/buildland/map/map-config.action?proid="+proid+"&readOnly=true&hideTopBar=true";
			typeName="图形浏览";
		}
		if(url){
			var contentPanel= Ext.getCmp("content-panel");
		    var tab = contentPanel.getComponent(type);//得到tab组建
		    var html="<iframe src='"+url+"' frameborder='0' width='100%' height='100%'></iframe>";
		    if (!tab) {
		        tab = contentPanel.add(
	        		new Ext.Panel({id:type,
						title:typeName,
						autoScroll:true,
						layout: 'fit',
						border:false,
						closable:true,
						html:html})
        		);
		    }
		    contentPanel.setActiveTab(tab);
		}
	}
}
function getFirstRootNode(node) {
    if (node.firstChild == null) {
        return null;
    }
    if (_defaultName != "") {
        return node.findChild('text',_defaultName,true);
//        for (var i = 0; i < node.childNodes.length; i++) {
//            if (node.childNodes[i].text == _defaultName) {
//                return node.childNodes[i];
//            }
//        }
    }
    if (node.firstChild.isLeaf()) {
        if (node.firstChild != null) {
            return node.firstChild;
        } else {
            return null;
        }
    } else {
        return getFirstRootNode(node.firstChild);
    }
}

function ShowRelatedWorkFlowProject(wiid){
    var w_width=screen.availWidth-10;
    var w_height= screen.availHeight-32;
    var url='${pageContext.request.contextPath}/projecthandle.action?wiid=' + wiid;
    window.open(url, "_project", "left=1,top=0,height="+w_height+",width="+w_width+",resizable=yes,scrollbars=yes");
}

function BeginQueryRelatedProj(){
    $("#relatedProjects tr").each(function(){
        $(this).remove();
    });
    $.ajax({
        type: "get",
        dataType: "json",
        url: './projectrelate!getAssociatedWorkflowInstance.action?wiid='+_wiid,
        success: function(msg){//msg为返回的数据，在这里做数据绑定
            for(var i=0;i<msg.length;i++){
                var captionName="<a  title='"+msg[i].workflowIntanceName+"' href='javascript:ShowRelatedWorkFlowProject(\""+msg[i].workflowIntanceId+"\")'>";
                if(msg[i].workflowIntanceName.length>10)
                    captionName +=(msg[i].workflowIntanceName).substr(0,10)+"...";
                else
                    captionName += msg[i].workflowIntanceName;
                captionName += "</a>";
                $("<tr></tr>").append("<td>"+captionName+"</td>").
                        append("<td></td>").
                        appendTo("#relatedProjects");

            }
        }
    });
}

//查文件中心的数据
var _returnData;


function BeginQueryFile(){
    ///
    $("#tblFiles tr").each(function(){
        $(this).remove();
    });
    $.ajax({
        type: "get",
        dataType: "json",
        url: _fileCetnerUrl,
        success: function(msg){//msg为返回的数据，在这里做数据绑定
            //alert(msg);
            _returnData = msg.items;
            $.each(_returnData, function(index, n){
                //var row = $("#tblTrFile").clone();
                var captionName="<a href='javascript:OpenFile(\""+n.id+"\","+index+")'>"+n.name+"</a>";
                if (n.childCount>0){
                    $("<tr></tr>").append("<td><img src='./common/images/folder_pictures.png'/></td>")
                        .append("<td><b>"+captionName+"</b></td>").appendTo("#tblFiles");
                }else{
                    if (n.type==0)
                        $("<tr></tr>").append("<td><img src='./common/images/folder_blank.png'/></td>")
                            .append("<td>"+captionName+"</td>").appendTo("#tblFiles");
                    else
                        $("<tr></tr>").append("<td><img src='./common/images/folder_file.png'/></td>")
                            .append("<td>"+captionName+"</td>").appendTo("#tblFiles");
                }

            });
        }
    });
}

function addFile(nodeId){
	newFileUploadTab(nodeId,"附件管理",null);
}

function OpenFile(nodeId,index){
	var nodeData= _returnData[index];
    if (nodeData.type==0){
    	newFileUploadTab(nodeId,nodeData.name,null);
    }else{
    	var getUrl = function (action) {
            var ss = action.split('?');
            //return [_fileCenterText, ss[0], '', _fileCenterToken].join('');
            return [_fileCenterText+"/", ss[0], '?', (ss.length > 1 ? ss[1] : ''), '&token=' + _fileCenterToken].join('');
        };
    	var fcStoreView = new Fc.FcStore({
            getUrl:getUrl,
            getWebdavUrl:'',
            getFtpUrl:'',
            getSmbUrl:''
        });

        var _previewDialog = new PreviewDialog({
            store:fcStoreView,
            readOnly:true,
            maxPreviewDialog:false,
            maximized:true,
            maximizable:false,
            minimizable:false,
            closable:false,
            header :false,
            pictureFillToDialogSize:true
        });

        fcStoreView.on("load",function(){
            nodeData.url=getUrl('file/get.do?fid='+nodeData.id);
            _previewDialog.show(nodeData);
        });

        newFileUploadTab(nodeId,nodeData.name,_previewDialog);
        _previewDialog.store= fcStoreView;
        _previewDialog.store.loadNode(nodeData.parentId);
    }
}

function newFileUploadTab(nodeId,title,panelFile){
    var contentPanel= Ext.getCmp("content-panel");
    var tab = contentPanel.getComponent(nodeId);//得到tab组建
    if (!tab) {
    	if(panelFile){
    		tab = contentPanel.add(new Ext.Panel({id:nodeId,title:title,autoScroll:true,layout: 'fit',border:false,closable:true,items:panelFile}));
    	}else{
    		var fcBrowser = new Fc.FcBrowser({
            	rootId:nodeId,
            	token:_fileCenterToken,
            	basePath:_fileCenterText,
            	readOnly: true,
            	enablePreview:true,
            	enableCifs:false
            });
    		tab = contentPanel.add(new Ext.Panel({id:nodeId,title:title,autoScroll:true,layout: 'fit',border:false,closable:true,items:fcBrowser}));
    	}
    }
    contentPanel.setActiveTab(tab);
}

function ShowWorkFlow(wiid){
    var contentPanel= Ext.getCmp("content-panel");
    var tab = contentPanel.getComponent(wiid);//得到tab组建
    var html="<iframe src='./showchart.action?wiid="+wiid+"' frameborder='0' width='100%' height='100%'></iframe>";
    if (!tab) {
        tab = contentPanel.add(new Ext.Panel({id:wiid,title:"项目办理信息",autoScroll:true,layout: 'fit',border:false,closable:true,html:html}));
        contentPanel.setActiveTab(tab);
    } else {
        contentPanel.setActiveTab(tab);
    }
}

function refreshTask() {
    Ext.util.Cookies.set('portlet_key', 'tasklist');
    try {
        opener.refreshTask(); //刷新父页面
    } catch(ex) {
    }
    //alert("asdf111");
    window.close();
}

function showwindow(url,title,width,height){
    var ua = navigator.userAgent;
    //var height = document.body.offsetHeight;
    if(ua.lastIndexOf("MSIE 6.0") != -1){
        if(ua.lastIndexOf("Windows NT 5.1") != -1){
            //alert("xp.ie6.0");
            //var height = document.body.offsetHeight;
            height=(height*1.0+102);
        } else if(ua.lastIndexOf("Windows NT 5.0") != -1){
            //alert("w2k.ie6.0");
            //var height = document.body.offsetHeight;
            height=(height*1.0+49);
        }
    }
    return window.showModalDialog(url,title,"dialogHeight="+height+"px;dialogWidth="+width + "px");
}

/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: PreviewDialog.js
 *
 * LastModified: 2009-10-22 04:55:02
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
var PreviewDialog = function (config) {
    Ext.apply(this, config);

    this.previewPanel = new Ext.Panel({
        bodyStyle:'background:#f3f3f3;text-align:center;padding:4px;',
        autoScroll:true,
        tbar:[
            {
                itemId:'new',
                iconCls:'fc-create',
                text:'新窗口',
                scope:this,
                handler:function () {
                    this.open();
                }
            },
            {
                itemId:'edit',
                iconCls:'fc-edit',
                text:'编辑',
                scope:this,
                handler:function () {
                    this.edit();
                }
            },
            {
                itemId:'enlarge',
                iconCls:'fc-enlarge',
                text:'放大',
                scope:this,
                handler:function () {
                    this.zoom(false);
                }
            },
            {
                itemId:'narrow',
                iconCls:'fc-narrow',
                text:'缩小',
                scope:this,
                handler:function () {
                    this.zoom(true);
                }
            },
            {
                itemId: 'rotate-left',
                iconCls: 'fc-rotate-left',
                text: '左旋转',
                scope: this,
                handler: function () {
                    this.rotate(270);
                }
            },
            {
                itemId: 'rotate-right',
                iconCls: 'fc-rotate-right',
                text: '右旋转',
                scope: this,
                handler: function () {
                    this.rotate(90);
                }
            },
            {
                itemId:'download',
                iconCls:'fc-download',
                text:'下载',
                scope:this,
                handler:function () {
                    this.download();
                }
            },

            '->',
            {
                itemId:'left',
                iconCls:'fc-back',
                text:'前一个',
                scope:this,
                handler:function () {
                    this.left();
                }
            },
            {
                itemId:'right',
                iconCls:'fc-forward',
                text:'后一个',
                scope:this,
                handler:function () {
                    this.right();
                }
            }
        ]
    });

    PreviewDialog.superclass.constructor.call(this, {
        layout:'fit',
        width:Ext.lib.Dom.getViewWidth() * 0.7,
        height:Ext.lib.Dom.getViewHeight() * 0.9,
        border:false,

        items:this.previewPanel
    });
    this.on('hide', function () {
        this.setHtml('');
    }, this);
};
function getUrl(action) {
	var ss = action.split('?');
	return [_fileCenterText+"/", ss[0], '?', (ss.length > 1 ? ss[1] : ''), '&token=' + _fileCenterToken].join('');
}
Ext.extend(PreviewDialog, Ext.Window, {
    getDataUrl:function () {
        return this.data.url + (this.data.isDoc ? '&type=preview&' : '') + '&inline=true&_t=' + new Date().getTime();
    },
    show:function (data) {
        this.data = data;
        Fc.PreviewDialog.superclass.show.call(this);
        var index = this.store.indexOfId(this.data.id);
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        this.setBtnState('edit', !data.isDoc || this.readOnly, true);
        this.setBtnState('enlarge', !data.isImage, true);
        this.setBtnState('narrow', !data.isImage, true);
        this.refresh();
        if (this.maxPreviewDialog) {
            this.maximize();
        }
    },
    getExt:function (name) {
        var index = name.lastIndexOf('.');
        if (index > -1)
            return name.substr(index + 1).toLowerCase();
        return null;
    },
    refresh:function () {
        var data = this.data;
        var ext = this.getExt(data.name);
        var url = this.getDataUrl();

        if (data.isImage) {
            this.setHtml('<img src="' + url + '"' + (this.pictureFillToDialogSize ? ' onload="PreviewDialog.resizeImg(this);"' : '') + '/>');
        } else if (data.isDoc) {
            this.setHtml('<iframe src="' + url + '" frameborder="none" style="width:100%;height:100%;border:none;"></iframe>');
        } else if (ext == 'swf') {
            this.setHtml('<object width="100%" height="100%" type="application/x-shockwave-flash" data="' + url + '"><param name="movie" value="' + url + '" /></object>');
        } else if (ext == 'mp3' || ext == 'avi' || ext == 'wma' || ext == 'wmv' || ext == 'asx' || ext == 'asf') {
            this.setHtml('<object width="100%" height="100%" classid="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6"><param name="url" value="' + url + '" /><embed width="100%" height="100%" type="application/x-mplayer2" src="' + url + '>"></embed></object>');
        } else if (data.icon == 'txt.gif' || data.icon == 'xml.gif' || data.icon == 'htm.gif') {
            this.setHtml('<iframe src="' + url + '&type=text" frameborder="none" style="width:100%;height:100%;border:none;"></iframe>');
        } else {
            this.setHtml('<div style="padding-top:10px;color:#666;font-size:14px;">不支持文件 ' + data.name + ' 的查看</div>');
        }
    },
    open:function () {
        window.open(this.getDataUrl());
    },
    download:function () {
        window.open(this.data.url);
    },
    setBtnState:function (btn, flag, isHide) {
        btn = Ext.isString(btn) ? this.previewPanel.getTopToolbar().getComponent(btn) : btn;
        if (isHide) {
            if (btn.hidden != flag)
                btn.setVisible(!flag);
        } else {
            if (btn.disabled != flag)
                btn.setDisabled(flag);
        }
    },
    left:function () {
        var index = this.store.indexOfId(this.data.id);
        this.data = this.store.getAt(--index).data;
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        this.refresh();
    },
    right:function () {
        var index = this.store.indexOfId(this.data.id);
        this.data = this.store.getAt(++index).data;
        this.setBtnState('left', index == 0);
        this.setBtnState('right', index > this.store.getCount() - 2);
        this.refresh();
    },
    setHtml:function (html) {
        this.previewPanel.body.update(html);
    },
    edit:function () {
        var webDavUrl = this.store.getEditUrl(this.data.name);
        if (window.ActiveXObject) {// this is IE
            var ed;
            try {
                ed = new ActiveXObject('SharePoint.OpenDocuments.2');
            } catch (e) {
                window.alert('创建文件编辑对象错误. 请检查您的安全设置.');
                return false;
            }
            if (ed) {
                ed.EditDocument(location.protocol + "//" + location.host + webDavUrl);
                return false;
            } else {
                window.alert('初始化文件编辑对象错误. 请检查您的offce版本.');
                return false;
            }
        } /*else if (window.URLLauncher) {// this means the OC firefox plugin is installed
         var wdFile = new URLLauncher();
         // check and see if they have the function we want.
         wdFile.open(webDavUrl);
         } else if (window.InstallTrigger) {
         if (window.confirm('需要先安装webdav插件， 确认要安装吗?')) {
         InstallTrigger.install({'WebDAV Launcher': 'js/webdavloader.xpi'});
         }
         }*/ else {
            window.alert('只支持ie');
        }
        return false;
    },
    zoom:function (isIn) {
        var data = this.data;
        if (data.isImage) {
            var img = this.previewPanel.body.child('img');
            img.setWidth(img.getWidth() * (isIn ? 0.8 : 1.2))
            img.setHeight(img.getHeight() * (isIn ? 0.8 : 1.2))
        }
    },
    rotate:function (degree) {
        Fc.Ajax.request({
            url:getUrl('node/rotate.do'),
            params:{degree:degree,nid:this.data.id},
            success:function () {
                this.setHtml('<img src="' + this.getDataUrl() + (this.pictureFillToDialogSize ? ' onload="Fc.PreviewDialog.resizeImg(this);"' : '') + '/>');
            },
            scope:this
        });
    }
});

PreviewDialog.resizeImg = function (img) {
    img = Ext.get(img);
    var parent = img.parent();
    var iw = img.getWidth(), ih = img.getHeight(), cw = parent.getWidth(), ch = parent.getHeight(), w, h;
    if (cw < iw || ch < ih) {
        if (cw < iw) {
            w = cw;
            h = cw / iw * ih;
        }
        if (ch < ih) {
            h = ch;
            w = ch / ih * iw;
        }
        img.setWidth(w - 20);
        img.setHeight(h - 20);
    }
};

