// ext实例展示的js文件
//Ext.QuickTips.init();//加载快速提示框
if (top.location !== self.location) {
    top.location = self.location;
}

Ext.namespace('Egov_Ext');//创建名字域

//应用程序主页面
Egov_Ext.app = function () {
    //空函数
};
Ext.override(Ext.tree.TreeLoader, {    runCallback:function (cb, scope, args) {
    if (Ext.isFunction(cb)) {
        cb.apply(scope, args || []);
    }
}});

if(Ext.ux.TabCloseMenu) {
    Ext.ux.TabCloseMenu.prototype.closeTabText = '关闭当前标签页';
    Ext.ux.TabCloseMenu.prototype.closeOtherTabsText='关闭其他标签页';
    Ext.ux.TabCloseMenu.prototype.closeAllTabsText='关闭所有标签页';
}

Ext.extend(Egov_Ext.app, Ext.util.Observable, {
    //顶端
    header:new Ext.BoxComponent({
        region:'north',
        el:'pf-top'
    }),
    //主要显示区
    main:new Ext.TabPanel({
        id:'maintab',
        region:'center',
        enableTabScroll:true,
        activeTab:0,
        el:'lyrmain',
        margins:'0 4 3 0',
        items:[
            {
                id:'pf-portal',
                title:'首 页',
                autoScroll:false,
                layout:'fit',
                border:false,
                closable:false,
                html:'<iframe id="pf-portal-frame" name="pf-portal-frame" width="100%" height="100%" frameborder="0" src=""></iframe>'
            }
        ],
        plugins:new Ext.ux.TabCloseMenu()
    }),
    //初始化菜单树形
    initMenuTree:function () {
        if (this.useSimpleMenu) {
            this.menuTree = new Ext.tree.TreePanel({
                cls:'m-simple',
                title:'系统菜单',
                el:'lyrtree',
                region:'west',
                id:'lyrtree',
                autoScroll:true,
                enableDD:false, //是否支持拖拽效果
                containerScroll:true, //是否支持滚动条
                animate:false,
                split:true,
                width:200,
                minSize:140,
                maxSize:300,
                lines:false,
                border:false,
                rootVisible:false, //是否显示跟节点
                //collapseMode:'mini',//在分割线处出现按钮
                collapsible:true,
                margins:'0 0 3 4',
                root:new Ext.tree.AsyncTreeNode({
                    text:'系统菜单',
                    draggable:false,
                    id:'source'
                }),
                listeners:{
                    'expandnode':function (node) {
                        var id = node.id + "|";
                        var s = Ext.util.Cookies.get('__menu') || '';
                        if (s.indexOf(id) == -1)
                            Ext.util.Cookies.set('__menu', s + id);
                    },
                    'collapsenode':function (node) {
                        var id = node.id + "|";
                        var s = Ext.util.Cookies.get('__menu') || '';
                        if (s.indexOf(id) > -1)
                            Ext.util.Cookies.set('__menu', s.replace(id, ''));
                    },
                    scope:this
                },
                loader:new Ext.tree.TreeLoader({
                    dataUrl:'SysMenu!menu.action',
                    listeners:{
                        'load':function () {
                            var s = Ext.util.Cookies.get('__menu');
                            if (s) {
                                var ids = s.split("|");
                                for (var i = 0; i < ids.length; i++) {
                                    var id = ids[i];
                                    if (!id)
                                        return;
                                    var node = this.menuTree.getNodeById(ids[i]);
                                    if (node) {
                                        node.expand();
                                    }
                                }
                            }
                        },
                        scope:this
                    }
                }),
                tools:[
                    /*
                     {
                     id:'refresh',
                     handler:function() {
                     var tree = Ext.getCmp('lyrtree');
                     tree.root.reload();
                     }
                     }
                     */
                ]
            })
        } else {
            this.menuTree = new Ext.tree.TreePanel({
                title:'系统菜单',
                el:'lyrtree',
                region:'west',
                id:'lyrtree',
                autoScroll:true,
                enableDD:false, //是否支持拖拽效果
                containerScroll:true, //是否支持滚动条
                split:true,
                width:200,
                minSize:140,
                maxSize:300,
                useArrows:true,
                border:false,
                rootVisible:false, //是否显示跟节点
                //collapseMode:'mini',//在分割线处出现按钮
                collapsible:true,
                margins:'0 0 1 6',
                root:new Ext.tree.AsyncTreeNode({
                    text:'系统菜单',
                    draggable:false,
                    id:'source'
                }),
                listeners:{
                    'expandnode':function (node) {
                        if (!node.expandtime) {
                            if (node.getDepth() > 1) {
                                node.collapse();
                                if (node.expandtime) {
                                    node.expandtime++;
                                } else {
                                    node.expandtime = 1;
                                }
                            }
                        }
                    }
                },
                loader:new Ext.tree.TreeLoader({
                    dataUrl:'SysMenu.action'
                }),
                tools:[
                    /*                    {
                     id:'refresh',
                     handler:function () {
                     var tree = Ext.getCmp('lyrtree');
                     tree.root.reload();
                     }
                     }*/
                ]
            });
        }
        this.menuTree.getRootNode().expand();
        //给树形菜单添加事件
        this.menuTree.on('click', this.menuClickAction, this);
        //给main的tab页面添加tabchange事件
        this.main.on('tabchange', this.changeTab, this);
    },
    //初始化构造函数
    init:function () {

        this.useSimpleMenu = Ext.getDom('useSimpleMenu').value == 'true';
        this.initMenuTree();
        var myView = new Ext.Viewport({
            layout:'border',
            border:false,
            items:[this.header, this.main, this.menuTree]
        });
        //新建一个mask
        this.loadMask = new Ext.LoadMask(this.main.body, {msg:"页面加载中……"});
        var portalFrame= document.getElementById("pf-portal-frame");
        var onlyIndexCms=document.getElementById("onlyIndexCms").value;
        if(onlyIndexCms=="true" && portalFrame!=null)
            portalFrame.src="/cms/index.htm";
        else if(portalFrame!=null)
            portalFrame.src="portal.action";

    },
    //属性菜单的点击事件
    menuClickAction:function (node) {
        if (!node.isLeaf()) {
            if (this.useSimpleMenu)
                node.toggle();
            else{
                node.singleClickExpand = true;
                if(node.isExpanded()){
                    node.collapse(true);
                }else{
                    node.expand(node);
                }
            }
            return false;
        }
        var tabId = 'tab-' + node.id;
        var tabTitle = node.text;
        var tablink = node.attributes.link;
        var tabJsArray = node.attributes.jsArray;//得到js文件存放的路径
        var tab = this.main.getComponent(tabId);//得到tab组建
        //alert(tablink);
        if (!tab) {
            var html = '<iframe id=\'frame_' + node.id + '\' src=\'' + node.attributes.link + '\' width="100%" height="100%" frameborder="0"></iframe>';
            tab = this.main.add(new Ext.Panel({id:tabId, title:tabTitle, autoScroll:false, layout:'fit', border:false, closable:true, html:html}));
            this.main.setActiveTab(tab);
            //var loadmask = this.loadMask;
            //var model;//加载模块js预置变量名
            //loadmask.show();
        } else {
            this.main.setActiveTab(tab);
            var ff = document.getElementById('frame_' + node.id);
            if (ff)
                ff.src = node.attributes.link;
        }
        return false;
    },

    //change的实现
    changeTab:function (tab, newtab) {
        if (!newtab)
            return;
        //如果存在相应树节点，就选中,否则就清空选择状态
        var nodeId = newtab.id.replace('tab-', '');
        var node = this.menuTree.getNodeById(nodeId);
        if (node) {
            this.menuTree.getSelectionModel().select(node);
        } else {
            this.menuTree.getSelectionModel().clearSelections();
        }
    }
});

Ext.onReady(function () {

    //    var taskHeight;
    //    if  (document.documentElement.clientHeight==0)
    //        taskHeight=document.body.clientHeight;
    //    else
    //        taskHeight=document.documentElement.clientHeight;
    //   taskHeight=taskHeight-520;
    /*    taskHeight=125;
     Ext.getCmp("tasklist").height=taskHeight;
     var taskWeight;
     if  (document.documentElement.clientWidth==0)
     taskWeight=document.body.clientWidth;
     else
     taskWeight=document.documentElement.clientWidth;
     taskWeight=(taskWeight-217)/2;
     Ext.getCmp("doingtask").width=taskWeight;
     Ext.getCmp("doingtask11").width=taskWeight;
     Ext.getCmp("newlist").width=taskWeight;
     Ext.getCmp("newlist111").width=taskWeight;*/
    //Ext.getCmp("tasklist").html='<iframe width="100%" heigth="'+taskHeight+'" frameborder="0" src="./tasklist.action"></iframe>',
    var app = new Egov_Ext.app();
    app.init();
    ///
    //  var newlist=Ext.getCmp("newlist");
    //    var url="./newslist.action?rr=" + Math.random()*100 ;
    //    newlist.load(url);
    var msgInterval = Ext.getDom('msgInterval');
    if (msgInterval && msgInterval.value > 0) {
        if (msgInterval && msgInterval.value) {
            window.setInterval("openMsgWindow()", 60000 * parseInt(msgInterval.value));
        }
        openMsgWindow();
    }
    initSearch('search-keyword');
    duplicatedLoginAlert();
});

function logout() {
    Ext.Ajax.request({
        url:'./logout.action',
        success:function (r) {
            window.close();
        },
        failure:function () {
            window.close();
        }
    });
}

function exit() {
    Ext.Ajax.request({
        url:'./logout.action',
        success:function (r) {
            var logoutUrl = r.responseText;
            //alert(logoutUrl);
            Ext.Ajax.request({
                url:logoutUrl,
                success:function (r1) {
                    document.location = "/platform";
                }
            });
        }
    });
}
var _count = 0;
function showconfig() {
    _count++;
    var strurl = "sysconfig.action?_id=" + _count;
    //alert(strurl);
    //window.open(strurl);
    var returnstr = window.showModalDialog(strurl, null, "dialogHeight=190px;dialogWidth=360px");
}

function modifypass() {
    var strurl = "sysuser.action";
    var returnstr = window.showModalDialog(strurl, null, "dialogHeight=190px;dialogWidth=360px");
}

//save message
function showMsgSend(sTag) {
    var top, left, Width, Height;
    Width = 740;
    Height = 500;
    left = (window.screen.width - Width) / 2;
    top = (window.screen.height - Height) / 2;
    //alert(Ext.isIE6);
    if (Ext.isIE6) {
        var returnstr = window.showModalDialog(convertURL("sms.action"), null, "dialogHeight=520px;dialogWidth=755px");
    } else {
        var returnstr = window.showModalDialog(convertURL("sms.action"), null, "dialogHeight=475px;dialogWidth=755px");
    }
}

//message manage
function messageManager() {
    var strurl = convertURL("message.action");
    var returnstr = window.showModalDialog(strurl, null, "dialogHeight=560px;dialogWidth=720px");
//   var main = Ext.getCmp("maintab");
//   var tabId = 'tab-69B4B58AB928415D98A7D024327AD0A9';
//   var tabTitle = "消息传递";
//   var tablink = "message!sendList.action";
//   var tab = main.getComponent(tabId);//得到tab组建
//   var html = '<iframe id=\'frame_' + tabId + '\' src=\'' + tablink + '\' width="100%" height="100%" frameborder="0"></iframe>';
//   tab = main.add(new Ext.Panel({id:tabId,title:tabTitle,autoScroll:true,layout: 'fit',border:false,closable:true,html:html}));
//   main.setActiveTab(tab);
//   window.showModalDialog("",null, "dialogHeight=600px;dialogWidth=650px");
}

function convertURL(url) {
    var timstamp = (new Date()).valueOf();
    if (url.indexOf("?") >= 0) {
        url = url + "&t=" + timstamp;
    } else {
        url = url + "?t=" + timstamp;
    }
    return url;
}

function openMsgWindow() {
    var icount = 0;
    Ext.Ajax.request({
        url:'messageprompt.action',
        success:function (r) {
            icount = r.responseText;
            openwin(icount);
        },
        method:'POST'
    });

}

function openwin(icount) {
    var numArray = icount.split(",");
    if (numArray.length > 0) {
        var MSG = new CLASS_MSN_MESSAGE("aa", 180, 120, "消息提示：");
        if($('#msgSound').val()=='true')
            MSG.setMsgSound(true);
        var msg = false;
        for (var i = 0; i < numArray.length; i++) {
            if (numArray[i] > 0) {
                switch (i) {
                    case 0:
                        var notice = "未阅读通知: " + Number(numArray[i]) + "条";
                        var name = "未阅读通知";
                        var url = "./notify!acceptAwokeList.action?notifyStadus=1";
                        MSG.addMessage(url, notice, name);
                        break
                    case 1:
                        var notice = "未阅读消息: " + Number(numArray[i]) + "条";
                        var name = "未阅读消息"
                        var url = "./message!acceptList.action?mesageStadus=1";
                        MSG.addMessage(url, notice, name);
                        break
                    case 2:
                        var name = "待办任务: " + Number(numArray[i]) + "条";
                        //var url = "./tasklist.action";
                        var url = '2';
                        MSG.addMessage(url, name, name);
                        break
                    default:

                }
                msg = true;
            }
        }
        if (msg)
            MSG.show();
    }
}

function openurl(nId) {
    var w_width = screen.availWidth - 10;
    var w_height = screen.availHeight - 32;
    var weburl = './news!viewEnterDetail.action?pnv.id=' + nId;
    window.open(weburl);
}


function openMenu(id, text, url) {
    var tabObj = Ext.getCmp("maintab");
    var tabId = 'tab-' + id;
    var tabTitle = text;
    var tablink = url;
    var tab = tabObj.getComponent(tabId);//得到tab组建
    //alert(tablink);
    if (!tab) {
        var html = '<iframe id=\'frame_' + id + '\' src=\'' + tablink + '\' width="100%" height="100%" frameborder="0"></iframe>';
        tab = tabObj.add(new Ext.Panel({id:tabId, title:tabTitle, autoScroll:true, layout:'fit', border:false, closable:true, html:html}));
        tabObj.setActiveTab(tab);
        //var loadmask = this.loadMask;
        //var model;//加载模块js预置变量名
        //loadmask.show();
    } else {
        tabObj.setActiveTab(tab);
        var ff = document.getElementById('frame_' + id);
        if (ff)
            ff.src = tablink;
    }
}

function openRes(index) {
    if (index == "1") {
        openMenu("9F22AC79323A4BE99283E709CE5856E9", "新建任务", "SysResource.action?rid=7EB5822AFCF0427BBDE1CAAE8FB40AE8");
    } else if (index == "2") {
        openMenu("2213BA9BC38D4F069CCBCD780DE1A1D5", "待办任务", "tasklist.action");
    } else if (index == "3") {
        openMenu("50F3CA1EA7E54D93A2402A5BDD8A0892", "发送消息列表", "SysResource.action?rid=D4628130EAE54C51BDB833192C6010A4");
    } else if (index == "4") {
        openMenu("9ABAE47CCE8645A18D52211F565CC6C7", "工作流统计", "SysResource.action?rid=1A8F8CC0805941ADA2AEC4EB3911FE6F");
    } else if (index == "5") {
        openMenu("D62FF9D48CDE43439A4AF1F46C69BED9", "通知", "SysResource.action?rid=89EE1AD41A4A4178A68D9E62D666C58B");
    } else if (index == "6") {
        openMenu("E778DB87D8E940289A823F5812CD4F76", "项目列表", "SysResource.action?rid=79420540460A4E6FA2F7BA27E46009DA");
    } else if (index == "7") {
        openMenu("7B4E7E7168EF47999F985B42F8BF469F", "意见维护", "SysResource.action?rid=A1E5737BC68A4612A7BA0FC61B0CE9F9");
    } else if (index == "8") {
        openMenu("BF16D75B972947C992115ADDA2F30682", "已办任务", "SysResource.action?rid=0DAFD5F01E4343738920587691B6C399");
    } else if (index == "9") {
        openMenu("68CBBD09037A48F09F93BED6CBB44CC8", "超期任务", "SysResource.action?rid=88CBBD09037A48F09F93BED6CBB44CC8");
    }
}

function goMoreTaskList() {
    var url = "${pageContext.request.contextPath}/tasklist.action";
    window.open(url, "", "toolbar=no,menubar=no,scrollbars=yes,resizable=yes,location=no,status=no,top=0,left=0,width=" + (screen.availWidth - 10) + ",height=" + (screen.availHeight - 30));
}

function goMoreTaskOverList() {
    var url = "${pageContext.request.contextPath}/taskoverlist.action";
    window.open(url, "", "toolbar=no,menubar=no,scrollbars=yes,resizable=yes,location=no,status=no,top=0,left=0,width=" + (screen.availWidth - 10) + ",height=" + (screen.availHeight - 30));
}

function goMoreMessage() {
    var url = "${pageContext.request.contextPath}/acceptmsglist.action";
    window.open(url, "", "toolbar=no,menubar=no,scrollbars=yes,resizable=yes,location=no,status=no,top=0,left=0,width=" + (screen.availWidth - 10) + ",height=" + (screen.availHeight - 30));
}

function goMoreNews() {
    var url = "${pageContext.request.contextPath}/newslist.action";
    window.open(url, "", "toolbar=no,menubar=no,scrollbars=yes,resizable=yes,location=no,status=no,top=" + (screen.availHeight / 4) + ",left=" + (screen.availWidth / 4) + ",width=" + (screen.availWidth / 2) + ",height=" + (screen.availHeight / 2));
}

function goMoreProjectList() {
    var url = "${pageContext.request.contextPath}/projectlist.action";
    window.open(url, "", "toolbar=no,menubar=no,scrollbars=yes,resizable=yes,location=no,status=no,top=0,left=0,width=" + (screen.availWidth - 10) + ",height=" + (screen.availHeight - 30));
}

var defWord = '平台搜索', solrUrl, sInited = false;
function initSearch(id) {
    solrUrl = Ext.getDom('solrUrl').value;
    $('#' + id).autocomplete({
        deferRequestBy:200,
        maxHeight:500,
        width:280,
        fnFormatResult:function (value) {
            return ['<div class="ac-item"><img src="', solrUrl, '/img/icon/', value.icon, '" alt=""/><span>', value.title, '</span><strong>', value.bn, (value.cn ? '&nbsp;›&nbsp;' + value.cn : ''), '</strong></div>'].join('');
        },
        onSelect:function (value, data, keyword) {
            var win = window.open(value.url);
            if (!win) {
                window.alert("请禁用弹出式窗口拦截");
                var s = Ext.util.Format.stripTags(value.title);
                openMenu(s, s, value.url);
            }
            keyword.val(defWord);
            keyword.blur();
        },
        serviceUrl:solrUrl + '/suggest.do'
    });
    Ext.fly(id).on({
        'focus':function () {
            if (Ext.util.Format.trim(this.value) == defWord)
                this.value = '';
            Ext.fly(this).removeClass('search-tip');
            if (!sInited) {
                $('#solr-img').attr('src', solrUrl + '/test.do');
                sInited = true;
            }
        },
        'blur':function () {
            if (Ext.util.Format.trim(this.value) == '') {
                this.value = defWord;
                Ext.fly(this).addClass('search-tip');
            }
        }
    });
    $('#pf-tools').hover(function () {
        $(this).addClass('active');
    }, function () {
        $(this).removeClass('active');
    });
}

function doSearchSubmit(keyword) {
    var s = keyword.value;
    if (s != defWord && !/^ *$/.test(s)) {
        openMenu(s, s, solrUrl + '/?keyword=' + encodeURIComponent(s));
        keyword.value = defWord;
        keyword.blur();
    }
    return false;
}
//提供给cms打开tabpanel
function openPage(){
    openMenu($(this).attr('data-id'),$(this).attr('data-name'),$(this).attr('data-link'));
}

function duplicatedLoginAlert() {
    Ext.Ajax.request({
        url:'online!duplicatedLoginCheck.action',
        success:function (r) {
            var content = r.responseText;
            if(content!=null&&content!=''){
                alert(content);
            }
        },
        method:'POST'
    });

}

