<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<%@ taglib prefix="g" uri="/gtis-tags"%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<title>新闻列表</title>
		<style type="text/css">
			body,html {
				margin-left: 0px;
				margin-top: 0px;
				margin-right: 0px;
				margin-bottom: 0px;
				overflow:hidden;
				height:100%;
			} 
		</style>
		<g:head useExt="true" />
		<script type="text/javascript" src="${pageContext.request.contextPath}/oa/js/common/helper.js"></script>
		<script type="text/javascript">
			var type = <%= request.getParameter("type")%>;
			var win_top = (screen.height - 550)/2;
			var win_lef = (screen.width - 900)/2;
			function newNews() {
				var createNews = new Ext.Window({
					title:'新建新闻',
					width: 270,
					autoHeight:true, 
					minWidth: 200,
					layout: 'fit',
					bodyStyle:'padding:5px;',
					plain:true,
					buttonAlign:'center',
					closeAction:'close',
					items:[{
						xtype:'form',
						autoHeight:true,
						plain:true,
						baseCls: 'x-plain',
						labelWidth: 60,
						items:[{
							id:'newsTypeCombo',
							fieldLabel: '新闻类型',
							emptyText:'新闻类型',
							selectOnFocus:true, 
							xtype:'combo',
							mode: 'local',
                        	triggerAction: 'all',
                        	typeAhead: true,
                        	store: new Ext.data.ArrayStore({
						        id: 0,
						        fields: [
						            'myId',
						            'displayText'
						        ],
						        data: [[1, '通知'], [2, '新闻']]
						    }),
						    valueField: 'myId',
    						displayField: 'displayText',
    						anchor: '100%'
						}]
					}],
					buttons:[{
						text: '创建',
						handler:function(){
							var temp = Ext.getCmp("newsTypeCombo").getValue();
							if(temp == ""){
								Ext.Msg.alert("提示","请选择新闻类型！");
							}else {
								type = temp;
								var url = convertURL("news!entryNews.action?type=" + type + "&flag=new");
								window.open(url,null,'width=900,height = 550, toolbar=no, menubar=no,resizable=yes,location=no, status=no,left=' + win_lef + ',top=' + win_top);
								createNews.close();
							}
						}
					},{
						text: '关 闭',
						handler:function(){createNews.close();} 
					}]
				});
				createNews.show(this);
			}
			function newNewsRecord() {
                var url = convertURL("news!entryNews.action?flag=new&type=${type}");
                window.open(url,null,'width=900,height = 550, toolbar=no, menubar=no,resizable=yes,location=no, status=no,left=' + win_lef + ',top=' + win_top);
            }
			function newsUpdate() {
				var selectRow = getSelectRow();
				if(selectRow.length == 1){
					var url = convertURL("news!entryNews.action?pnv.newsId=" + selectRow[0].data.NEW_ID + "&flag=update");
					window.open(url,null,'width=800,height = 500, toolbar=no, menubar=no,resizable=yes,location=no, status=no,left=' + win_lef + ',top=' + win_top);
				}else {
					Ext.Msg.alert("提示","只能选择一条新闻！");
				}
			}
			
			function newsDelete() {
				var newsIds = new Array();
				var newsTitles = new Array();
				
				var selectRow = getSelectRow();
				
				if(selectRow != null){
					var title = "确实要删除 ";

					Ext.each(selectRow,function(row){
						newsIds.push(row.data.NEW_ID);
						newsTitles.push(row.data.NEW_TITLE);
					});
					
					if(newsTitles.length > 3){
						title += newsTitles[0] + "," + newsTitles[1] + "," + newsTitles[2] + "等" + " " + newsTitles.length + "项吗？";
					}else {
						for(var i = 0; i < newsTitles.length; i++) {
		 					if(i != 0) {
		 						title += ",";
		 					}
		 					title += newsTitles[i];
		 				}
		 				title += " 吗？";
					}
					
					Ext.Msg.confirm("提示",title,function(optional){
						if(optional == 'yes'){
							var params = {
								"newsIds":newsIds
							}
							
							Ext.Ajax.request({
		        				"url":convertURL("news!del.action"),
		        				"params":params,
		        				success:function(response, opts) {
		        					if(response.responseText){
			        					if(Ext.decode(response.responseText) == true){
			        						Ext.Msg.alert("提示","删除成功！");
			        					}else {
			        						Ext.Msg.alert("提示","删除失败！");
			        					}
		        					}
									refurbish();
								},
								failure: function(response, opts) {
									Ext.Msg.alert('提示','删除失败！错误码：' + response.status);
									refurbish();
								}
		        			});
						}
					});
				}
			}
			
			//刷新新闻
			function refurbish(){
				var gridobj=Ext.getCmp("newList");
				if (gridobj)
					//gridobj.getStore().reload();
                    gridobj.refresh();
			}
			
			function getSelectRow() {
				var selectRow = Ext.getCmp("newList").getSelectionModel().getSelections();
				if(selectRow.length == 0){
					Ext.Msg.alert("提示","请勾选需要操作的新闻！");
				}else {
					return selectRow;
				}
			}
			
			function statusHandler(val, p, record) {
				if(record.data.IMAGE_URL != null){
					return "<img ext:qtip='图片' src='${pageContext.request.contextPath}/common/images/pic.png'/>";
				}
			}
			
			function summaryHandler(val,p,record){
				if(val != null){
					return "<div ext:qtip='" + val + "'>" + val + "</div>";
				}
			}
			
			function viewDetail(gridobj,rowindex,event) {
				window.open(convertURL('${pageContext.request.contextPath}/news!viewEnterDetail.action?pnv.newsId=' + gridobj.store.getAt(rowindex).data.NEW_ID));
			}

            function typeHander(val,p,record){
                if(val != null){
                    if(val == 1){
                        return "<div align=\"center\">通知</div>";
                    }else {
                        return "<div align=\"center\">新闻</div>";
                    }
                }
            }
		</script>
	</head>
	<body>
		<g:list id="newList" width="100%" keyField="NEW_ID" splitInfo="splitParam"
			checkbox="true" gridHeightOffset="0" rowdbclick="viewDetail">
			<g:toolbar>
				<g:tool text="新建" handler="newNewsRecord" icon="common/images/drop-add.gif" />
				<g:tool text="编辑" handler="newsUpdate" icon="common/images/over.gif" />
				<g:tool text="删除" handler="newsDelete" icon="common/images/cancel.png" />
			</g:toolbar>
            <g:query>
				<g:queryItem label="名称" name="NEW_TITLE" />
				<g:queryItem label="时间(起)" itemType="datefield" name="NEW_DATE1" />
				<g:queryItem label="时间(止)" itemType="datefield" name="NEW_DATE2" />
			</g:query>
			<g:field fieldname="NEW_ID" header="编号" width="80" hidden="true" />
			<g:field fieldname="STATUS" header="图片" width="35" renderer="statusHandler"/>
			<g:field fieldname="NEW_TITLE" header="标题" width="270" />
			<g:field fieldname="NEW_AUTHOR" header="作者" width="70"/>
            <g:field fieldname="NEW_PUBLISHER" header="发布人" width="70"/>
			<g:field fieldname="NEW_SUMMARY" header="新闻摘要" width="300" renderer="summaryHandler"/>
			<g:field fieldname="NEW_DATE" header="修改日期" width="100" renderer="dateformat"/>
			<%--<g:field fieldname="IMAGE_URL" header="图片路径" width="70" hidden="true"/>--%>
		</g:list>
	</body>
</html>
