Ext.form.FckEditor = Ext.extend(Ext.form.Field, {
    type:'temp',
    toolbar:'ext',
    fckConfig:null,
    defaultAutoCreate : {
        tag: "textarea",
        style:"width:1px;height:1px;",
        autocomplete: "off"
    },
    onRender : function(ct, position) {
        Ext.form.FckEditor.superclass.onRender.call(this, ct, position);
        if (this.grow) {
            this.textSizeEl = Ext.DomHelper.append(document.body, {
                tag: "pre", cls: "x-form-grow-sizer"
            });
            if (this.preventScrollbars) {
                this.el.setStyle("overflow", "hidden");
            }
            this.el.setHeight(this.growMin);
        }
        this.el.dom.style.border = '0 none';
        this.el.dom.setAttribute('tabIndex', -1);
        this.el.addClass('x-hidden');
        if (Ext.isIE) { // fix IE 1px bogus margin
            this.el.applyStyles('margin-top:-1px;margin-bottom:-1px;');
        }
        this.wrap = this.el.wrap({
            cls:'x-html-editor-wrap', cn:{cls:'x-html-editor-tb'}
        });
        var id = this.el.dom.id;
        var div = document.createElement('div');
        var config = Ext.apply({UpdateOnBlur:true}, this.fckConfig);
        var sConfig = '' ;
        for (var o in config) {
            if (sConfig.length > 0) sConfig += '&amp;';
            sConfig += encodeURIComponent(o) + '=' + encodeURIComponent(config[o]);
        }
        div.innerHTML = '<iframe src="common/fckeditor/editor/fckeditor.html?InstanceName=' + id + '&type=' + this.type + '" frameborder="no" scrolling="no"></iframe>' +
                        '<input type="hidden" id="' + id + '___Config" value="' + sConfig + '" style="display:none" />';
        this.wrap.dom.appendChild(div);
        this.iframe = div.firstChild;
    },
    onResize : function(w, h) {
        Ext.form.FckEditor.superclass.onResize.apply(this, arguments);
        if (this.el && this.iframe) {
            if (typeof w == 'number') {
                var aw = w - this.wrap.getFrameWidth('lr');
                //this.el.setWidth(this.adjustWidth('textarea', aw));
                this.iframe.style.width = aw + 'px';
                this.iframe.width = aw;
            }
            if (typeof h == 'number') {
                var ah = h - this.wrap.getFrameWidth('tb');
                //this.el.setHeight(this.adjustWidth('textarea', ah));
                this.iframe.style.height = ah + 'px';
                this.iframe.height = ah;
            }
        }
    },
    getFckEditor:function() {
        return typeof FCKeditorAPI != 'undefined' ? FCKeditorAPI.GetInstance(this.el.dom.id) : null;
    },
    setValue : function(value) {
        Ext.form.FckEditor.superclass.setValue.call(this, value);
        var editor = this.getFckEditor();
        if (editor)
            editor.SetData(value);
    },
    getValue : function() {
        var editor = this.getFckEditor();
        var v = editor ? editor.GetXHTML(true) : this.value;
        this.el.dom.value = v;
        return v;
    },
    getRawValue : function() {
        return this.getValue();
    }
});

Ext.reg('fckeditor', Ext.form.FckEditor);