Gn.GnTab = function (obj) {
    this.news = obj;
    var nTitle=obj.news.newsTitle;
    if(nTitle){
        var arr=nTitle.match(/<span style="color:(\w+);">(.*?)<\/span>/);
        if(arr){
            obj.news.color=arr[1];
            obj.news.newsTitle=arr[2];
        }
    };
    var colorStore = new Ext.data.ArrayStore({
        fields: ['name', 'value'],
        data : [
            [ '无', ''],
            [ '红色',  'red'],
            ['蓝色', 'blue'],
            ['绿色', 'green'],
            ['灰色', 'gray']
            ]
    });
    Gn.GnTab.superclass.constructor.call(this, {
        frame: true,
        layout: 'border',
        region: 'center',
        buttonAlign: 'center',
        listeners: {
            'pageTitleRefurbish': function (title) {
                //设置页面title
                if (title) {
                    if (type == 'new') {
                        title = (title || "新建 ") + "编辑";
                    } else if (type == 'update') {
                        title = (title || "未命名 ") + "编辑";
                    }
                    window.document.title = title;
                }
            }
        },
        items: [
            {
                xtype: 'panel',
                region: 'north',
                height: 120,
                items: [
                    {
                        layout: 'column',
                        items: [
                            {
                                columnWidth: .6,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '标题',
                                        id: 'pnv.newsTitle',
                                        name: 'pnv.newsTitle',
                                        anchor:'99%',
                                        value: Ext.util.Format.undef(obj.news.newsTitle)
                                    }
                                ]
                            },
                            {
                                columnWidth: .4,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'combo',
                                        id: 'color',
                                        mode: 'local',
                                        value: obj.news.color,
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        editable: false,
                                        fieldLabel: '颜色',
                                        name: 'color',
                                        displayField: 'name',
                                        valueField: 'value',
                                        anchor:'90%',
                                        store: colorStore
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        layout: 'column',
                        items: [
                            {
                                columnWidth: .3,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '作者',
                                        id: 'pnv.newsAuthor',
                                        name: 'pnv.newsAuthor',
                                        value: Ext.util.Format.undef(obj.news.newsAuthor)
                                    }
                                ]
                            },
                            {
                                columnWidth: .3,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: '&nbsp;&nbsp;发布人',
                                        id: "pnv.newPublisher",
                                        name: 'pnv.newPublisher',
                                        value: Ext.util.Format.undef(obj.news.newPublisher)
                                    }
                                ]
                            },
                            {
                                columnWidth: .4,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: '&nbsp;&nbsp;修改时间',
                                        id: "pnv.newsDate",
                                        name: 'pnv.newsDate',
                                        format: "Y-m-d H:i:s",
                                        anchor:'90%',
                                        value: longDateformat(Ext.util.Format.undef(obj.news.newsDate))
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        region: 'south',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'textfield',
                                id: 'pnv.imageUrl',
                                name: 'pnv.imageUrl',
                                emptyText: 'http://',
                                fieldLabel: '图片链接',
                                width: '100%',
                                value: Ext.util.Format.undef(obj.news.imageUrl)
                            },
                            {
                                fieldLabel: '摘要',
                                xtype: 'textarea',
                                id: 'pnv.newsSummary',
                                width: '100%',
                                value: Ext.util.Format.undef(obj.news.newsSummary)
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'tabpanel',
                id: 'content',
                region: 'center',
                name: 'content',
                activeTab: 0,
                items: [
                    {
                        title: '新闻编辑',
                        layout: 'border',
                        items: {
                            region: 'center',
                            xtype: "textarea",
                            id: 'pnvnewsContent',
                            value: (obj.news.newsContent || ''),
                            listeners: {
                                'render': function () {
                                    (function () {
                                        this.kEditor = KindEditor.create('#pnvnewsContent', {
                                            uploadJson: '/fileCenter/file/upload.do?client=ke&rename=true&nid=' + obj.nodeId + '&token=' + obj.token
                                        });
                                    }).defer(500, this);
                                },
                                resize: function (el, aw, ah, rw, rh) {
                                    if (this.kEditor) {
                                        this.kEditor.resize(rw, rh);
                                    }
                                },
                                scope: this
                            }
                        }
                    },
                    {
                        xtype: "panel",
                        title: '文件上传',
                        autoScroll: true,
                        items: new Fc.FcList({
                            basePath: fileCenterUrl,
                            "token": obj.token,
                            "nodeId": obj.nodeId
                        })
                    }
                ]
            }
        ],
        buttons: [
            {
                text: '保存',
                scope: this,
                handler: function () {

                    var newsTitle = Ext.getCmp("pnv.newsTitle").getValue().trim();
                    var newsSummary = Ext.getCmp("pnv.newsSummary").getValue();

                    if (newsTitle == "" || newsTitle == null) {
                        Ext.Msg.alert("提示", "新闻标题不能为空！");
                    } else if (newsSummary == '' || newsSummary == null) {
                        Ext.Msg.alert("提示", "新闻摘要不能为空！");
                    } else if (newsSummary.length >= 400) {
                        Ext.Msg.alert("提示", "新闻摘要不能超过200个汉字！");
                    } else {
                        var newsContent = this.kEditor.html();
                        var conf = {};
                        conf.newsTitle = newsTitle;
                        if (Ext.getCmp("pnv.newsDate").getValue() != '') {
                            conf.newsDate = Ext.getCmp("pnv.newsDate").getValue();
                        }
                        conf.newsSummary = newsSummary;
                        conf.imageUrl = Ext.getCmp("pnv.imageUrl").getValue().trim();
                        conf.newsAuthor = Ext.getCmp("pnv.newsAuthor").getValue().trim();
                        conf.newPublisher = Ext.getCmp("pnv.newPublisher").getValue().trim();
                        conf.newsContent = newsContent;
                        conf.type = type;
                        conf.newsId = this.news.news.newsId.trim();
                        var color= Ext.getCmp("color").getValue();
                        if (color) {
                            conf.newsTitle = '<span style="color:' + color + ';">' + conf.newsTitle + '</span>';
                        }
                        var param = {
                            "config": Ext.encode(conf),
                            "flag": flag
                        };
                        Ext.Ajax.request({
                            params: param,
                            method: 'POST',
                            url: 'news!saveNews.action',
                            success: function (response, opts) {
                                var obj = Ext.decode(response.responseText);
                                if (obj == true) {
                                    Ext.Msg.alert("提示", "存储成功！");
                                    this.fireEvent('pageTitleRefurbish', newsTitle);
                                    flag = 'update';
                                }
                            },
                            failure: function (response, opts) {
                                Ext.Msg.alert('错误', '存储失败！错误码：' + response.status);
                            },
                            scope: this
                        });
                    }
                }
            },
            {
                text: '关闭',
                handler: function () {
                    window.close();
                }
            }
        ]
    })
}

Ext.extend(Gn.GnTab, Ext.FormPanel);