<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--
命名模板
用来解释TextArea类型的TextArea控件 
对应type类型为：TextArea
TextArea 只有string类型，长度控制


-->
<xsl:template name="TextAreaTemplate">
	<xsl:param name="Id"/><!--编号-->
	<xsl:param name="Name"/><!--名称-->
	<xsl:param name="DataType"/><!--数据类型-->
	<xsl:param name="Value"/><!--控件值-->
	<xsl:param name="DefaultValue"/><!--控件缺省值-->
	<xsl:param name="Disabled"/><!--控件是否可用-->
	<xsl:param name="Index"/>
	<xsl:param name="Style"/>
	<xsl:param name="ClassName"/>
	<xsl:variable name="TextValue">   <!--得到正式的值-->
			<xsl:choose>
				<xsl:when test="$Value=''">
					<xsl:value-of select="$DefaultValue"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$Value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="Class" select="concat('input_default ',$ClassName)"/> 
		
		<xsl:choose>
				<xsl:when test="$Disabled='true'">
					<textarea name="{$Id}" id="{$Id}"  datatype="String(8000)"  style="{$Style}"  class="{$Class}" readonly="true" >
						<xsl:value-of select="$TextValue"/>
					</textarea>
				</xsl:when>
				<xsl:otherwise>
					<textarea name="{$Id}" id="{$Id}"  datatype="String(8000)" style="{$Style}"  class="{$Class}" onkeypress="formValueChange()"  onchange="formValueChange()" tabindex="{$Index}">
						<xsl:value-of select="$TextValue"/>
					</textarea>
				</xsl:otherwise>
		</xsl:choose>
</xsl:template>
</xsl:stylesheet>