<?xml version='1.0'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
		命名模板
		用来解释Sign类型的签名

		对应type类型为：sign
		Sign没有字段类型,无缺省值

		值value为签名表主健
	-->
	<xsl:template name="SignTemplate">
		<xsl:param name="Id" /><!--编号-->
		<xsl:param name="Name" /><!--名称-->
		<xsl:param name="Value" /><!--控件值-->
		<xsl:param name="Disabled" /><!--控件是否可用-->
		<xsl:param name="DisableTime" /><!--控件是否可用-->
        <xsl:param name="DefaultValue"/><!--控件缺省值-->
        <xsl:param name="ClassName"/>
			<input type="hidden" name="{$Id}" id="{$Id}" value="{$Value}" typeex="sign"/>
            <xsl:choose>
                <xsl:when test="$DefaultValue!=''">
                    <xsl:variable name="divId" select="concat('div',$Id)"/>
                    <div id="{$divId}" style="text-align:left;overflow-y:auto;width:100%;height:100%"></div>
                    <script type="text/javascript">
                    $(document).ready(function() {
                        var proId=$("#hiddenProId").val();
                        var params = {
                            <xsl:if test="$Disabled != ''">
                            'disabled':<xsl:value-of select="$Disabled"/> || false,
                            </xsl:if>
                            <xsl:if test="$Id != ''">
                            'signVo.signKey':'<xsl:value-of select="$Id"/>',
                            </xsl:if>
                            'signVo.proId':proId
                        };
                        var ajaxUrl="../tag/signtag.action" + document.location.search;
                        $.ajax({
                            type: "POST",
                            url: ajaxUrl,
                            data: params,
                            cache: false,
                            success: function(msg){
                                $("#<xsl:value-of select="$divId"/>").html(msg);
                            }
                        });
                    });
                    </script>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes">
                    &lt;div&gt;
                    &lt;iframe frameborder=&quot;0&quot; id=&quot;</xsl:text><xsl:value-of select="$Id"/><xsl:text disable-output-escaping="yes">_frame&quot; src=&quot;../sign.action?id=</xsl:text><xsl:value-of select="$Id"/>
                    <xsl:if test="$Value != ''">
                        <xsl:text disable-output-escaping="yes">&amp;signid=</xsl:text><xsl:value-of select="$Value"/>
                    </xsl:if>
                    <xsl:if test="$DisableTime != ''">
                        <xsl:text disable-output-escaping="yes">&amp;disabletime=</xsl:text><xsl:value-of select="$DisableTime" />
                    </xsl:if>
                    <xsl:if test="$Disabled='true'">&amp;disabled=true</xsl:if>
                    <xsl:text disable-output-escaping="yes">
                    &quot; width=&quot;200&quot; height=&quot;50&quot; scrolling=&quot;no&quot;&gt;
                    &lt;/iframe&gt;
                    &lt;/div&gt;
                    </xsl:text>
                </xsl:otherwise>
            </xsl:choose>
	</xsl:template>
</xsl:stylesheet>