<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--
命名模板
用来解释CheckBox类型的input控件 
对应type类型为：CheckBox
CheckBox没有字段类型
-->
<xsl:template name="CheckBoxTemplate">
	<xsl:param name="Id"/><!--编号-->
	<xsl:param name="Name"/><!--名称-->
	<xsl:param name="Value"/><!--控件值-->
	<xsl:param name="DefaultValue"/><!--控件缺省值-->
	<xsl:param name="Disabled"/><!--控件是否可用-->
    <xsl:param name="Index"/>
    <xsl:param name="Style"/>
    <xsl:param name="ClassName"/>
	<xsl:variable name="TextValue">   <!--得到正式的值-->
		<xsl:choose>
			<xsl:when test="$Value=''">
				<xsl:value-of select="$DefaultValue"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$Value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
    <input type="hidden" name="{@Id}" id="{@Id}"  value="{$TextValue}"  />
	<xsl:choose>
			<xsl:when test="$Disabled='true'">
				<xsl:choose>
					<xsl:when test="$TextValue='1'">
						<input type="checkbox" name="{$Id}_chk" id="{$Id}_chk" inputname="{$Id}" title="{$Name}"  checked="checked" value="1" style="{$Style}" class="{$ClassName}" onclick="event.returnValue=false;"   />
					</xsl:when>
					<xsl:otherwise>
						<input type="checkbox" name="{$Id}_chk" id="{$Id}_chk" inputname="{$Id}" title="{$Name}" value="1" style="{$Style}" class="{$ClassName}"  onclick="event.returnValue=false;"  />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$TextValue='1'">
						<input type="checkbox" name="{$Id}_chk" id="{$Id}_chk" inputname="{$Id}" title="{$Name}" value="1" style="{$Style}" class="{$ClassName}"  checked="checked" tabindex="{$Index}" onclick="chkclick()"  onchange="formValueChange()"   />
					</xsl:when>
					<xsl:otherwise>
						<input type="checkbox" name="{$Id}_chk" id="{$Id}_chk" inputname="{$Id}" title="{$Name}" value="1" style="{$Style}" class="{$ClassName}" onpropertychange="formValueChange()" onclick="chkclick()" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
	</xsl:choose>


</xsl:template>

</xsl:stylesheet>