<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="Element_Select.xsl"/>
<xsl:import href="Element_TextArea.xsl"/>
<xsl:import href="Element_CheckBox.xsl"/>
<xsl:import href="Element_DateText.xsl"/>
<xsl:import href="Element_Password.xsl"/>
<xsl:import href="Element_Text.xsl"/>
<xsl:import href="Element_Sign.xsl"/>
<!--
命名模板
用来解释ElementDefine元素所对应的控件（不解释数值）
控件类型有:Text、Password、DateText、Select、CheckBox、TextArea和sign
这里有以下2种形式: (LineIndex为空为第一种形式，否则第二种)
一种为DataSet/Data/ElementData元素
一种为DataSet/Data/GroupData/LineData/ElementData元素
-->
<xsl:template name="ElementNull" >
	<xsl:param name="Id"/><!--编号-->
	<xsl:variable name="Name" select="//ElementDefine[@Id=$Id]/@Name"/> 
	<xsl:variable name="DefaultValue" select="//ElementDefine[@Id=$Id]/@DefaultValue"/> 
	<xsl:variable name="DataType" select="//ElementDefine[@Id=$Id]/@DataType"/> 
	<xsl:variable name="Type" select="//ElementDefine[@Id=$Id]/@Type"/> 
	<xsl:choose>
		<xsl:when test="$Type='Text'">
			<xsl:call-template name="TextTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="DataType" select="$DataType"/>
				<xsl:with-param name="ClassName">input_noborder</xsl:with-param>
				<xsl:with-param name="Style">height:21px</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='Password'">
			<xsl:call-template name="PasswordTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="ClassName">input_noborder</xsl:with-param>
				<xsl:with-param name="Style">height:21px</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='DateText'">
			<xsl:call-template name="DateTextTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="ClassName">input_noborder</xsl:with-param>
				<xsl:with-param name="Style">height:21px</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='Select'">
			<xsl:call-template name="SelectTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="ClassName">input_noborder</xsl:with-param>
				<xsl:with-param name="Style">height:21px</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='CheckBox'">
			<xsl:call-template name="CheckBoxTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
			</xsl:call-template>
		</xsl:when>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>