<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="Element_Select.xsl"/>
<xsl:import href="Element_TextArea.xsl"/>
<xsl:import href="Element_CheckBox.xsl"/>
<xsl:import href="Element_DateText.xsl"/>
<xsl:import href="Element_Password.xsl"/>
<xsl:import href="Element_Text.xsl"/>
<xsl:import href="Element_Sign.xsl"/>
<!--
命名模板
用来解释ElementDefine元素所对应的控件

控件类型有:Text、Password、DateText、Select、CheckBox、TextArea和sign
这里有以下2种形式: (LineIndex为空为第一种形式，否则第二种)
一种为DataSet/Data/ElementData元素
一种为DataSet/Data/GroupData/LineData/ElementData元素
-->
<xsl:template name="Element">
	<xsl:param name="Id"/><!--编号-->
	<xsl:param name="LineIndex"/><!--行编号-->
	<xsl:param name="Style"/><!--样式-->
	<xsl:param name="ClassName"/><!--自定义CSS-->
	<xsl:variable name="ElementValue">   <!--得到正式的值-->
		<xsl:choose>
			<xsl:when test="$LineIndex=''">
				<xsl:value-of select="//ElementData[@Id=$Id]/text()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="//LineData[@Index=$LineIndex]/ElementData[@Id=$Id]/text()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
   
	<xsl:variable name="Name" select="//ElementDefine[@Id=$Id]/@Name"/> 
	<xsl:variable name="DefaultValue" select="//ElementDefine[@Id=$Id]/@DefaultValue"/> 
	<xsl:variable name="Disabled" select="//ElementDefine[@Id=$Id]/@Disabled"/> 
	<xsl:variable name="DataType" select="//ElementDefine[@Id=$Id]/@DataType"/> 
	<xsl:variable name="Type" select="//ElementDefine[@Id=$Id]/@Type"/> 
	<xsl:variable name="Index" select="//ElementDefine[@Id=$Id]/@Index"/>  
	<xsl:choose>
		<xsl:when test="$Type='Text'">
			<xsl:call-template name="TextTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value" select="$ElementValue"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="DataType" select="$DataType"/>
				<xsl:with-param name="Index" select="$Index"/>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='Password'">
			<xsl:call-template name="PasswordTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="Index" select="$Index"/>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='DateText'">
			<xsl:call-template name="DateTextTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value" select="$ElementValue"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="Index" select="$Index"/>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='Select'">
			<xsl:call-template name="SelectTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value" select="$ElementValue"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="Index" select="$Index"/>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='CheckBox'">
			<xsl:call-template name="CheckBoxTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value" select="$ElementValue"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="Index" select="$Index"/>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='TextArea'">
			<xsl:call-template name="TextAreaTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value" select="$ElementValue"/>
				<xsl:with-param name="DefaultValue" select="$DefaultValue"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="DataType" select="$DataType"/>
				<xsl:with-param name="Index" select="$Index"/>
				<xsl:with-param name="Style" select="$Style"/>
				<xsl:with-param name="ClassName" select="$ClassName"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='Sign'">
			<xsl:call-template name="SignTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value" select="$ElementValue"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="DisableTime" />
				<xsl:with-param name="Index" select="$Index"/>
                <xsl:with-param name="ClassName" select="$ClassName"/>
                <xsl:with-param name="DefaultValue" select="$DefaultValue"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$Type='Sign2'">
			<xsl:call-template name="SignTemplate">
				<xsl:with-param name="Id" select="$Id"/>
				<xsl:with-param name="Name" select="$Name"/>
				<xsl:with-param name="Value" select="$ElementValue"/>
				<xsl:with-param name="Disabled" select="$Disabled"/>
				<xsl:with-param name="DisableTime">true</xsl:with-param>
				<xsl:with-param name="Index" select="$Index"/>
			</xsl:call-template>
		</xsl:when>
        <xsl:when test="$Type='Hidden'">
            <input type="hidden" name="{$Id}" id="{$Id}"  value="{$ElementValue}"  />
		</xsl:when>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>