<%@ page pageEncoding="UTF-8" %>
<%@ include file="/include.jsp" %>
<html>
<head>
    <title></title>
    <link href="common/css/main.css" type="text/css" media="screen" rel="stylesheet"/>
    <link href="common/css/jquery.validationEngine.css" type="text/css" media="screen" rel="stylesheet"/>
    <link href="common/css/jquery.ui.css" type="text/css" media="screen" rel="stylesheet"/>
    <g:head useJQuery="true"/>
    <script src="common/js/jquery.validationEngine.js" type="text/javascript"></script>
    <script src="common/js/jquery.ui.js" type="text/javascript"></script>
    <script src="common/js/datePicker/WdatePicker.js" type="text/javascript"></script>
</head>
<body>
    <div>
        <br/>
        <div class="title">收件单</div>
        <br/>
    </div>
    <div id="container1">
        <div id="block-table">
            <s:hidden name="disable"/>
            <table id="block" class="block-table" style="height:50px">
                <tr>
                    <s:hidden name="info.infoId"/>
                    <td width="15%">
                        <span>交件人</span>
                    </td>
                    <td width="30%">
                         <s:textfield name="info.deliveryMan" cssClass="validate[required,length[0,20]]" size="65" theme="simple"/>
                    </td>
                    <td width="15%">
                        <span>收件人</span>
                    </td>
                    <td>
                        <s:textfield name="info.receiveMan" cssClass="validate[required,length[0,20]]" size="65" theme="simple"/>
                    </td>
                </tr>
                <tr>
                    <s:hidden name="info.infoId"/>
                    <td>
                        <span>收件日期</span>
                    </td>
                    <td>
                        <s:textfield name="info.receiveDate" cssClass="validate[required] Wdate" size="18" theme="simple"/>
                    </td>
                    <td>
                        <span>备注</span>
                    </td>
                    <td>
                        <s:textfield name="info.remark" size="65" theme="simple"/>
                    </td>
                </tr>
            </table>
        </div>
        <div id="auction-list">
            <table class="list-table" cellpadding="0" cellspacing="0">
                <tr>
                    <th width="5%" id="add-line"></th>
                    <th width="40%">材料名称</th>
                    <th width="5%">已收份数</th>
                    <th width="5%">应收份数</th>
                    <th width="10%">录入方式</th>
                    <th width="15%">备注</th>
                    <th width="20%">操作</th>
                </tr>
                <s:iterator value="info.fileList" var="file" status="stat">
                    <tr class="<s:if test="#stat.index%2!=1">ood</s:if><s:else>even</s:else>">
                        <s:hidden name="#file.fileId"/>
                        <td align="right">
                            <s:textfield name="#file.no" cssClass="validate[required,custom[notZero]]" size="5" theme="simple"/>
                        </td>
                        <td>
                            <s:textfield  name="#file.stuffName" cssClass="validate[required]" size="50" theme="simple"/>
                        </td>
                        <td>
                           <s:textfield name="#file.rCopies" onkeyup="replaceNum(this);" size="5" theme="simple"/>
                        </td>
                        <td>
                           <s:textfield name="#file.sCopies" cssClass="validate[required,custom[notZero]]" onkeyup="replaceNum(this);" size="5" theme="simple"/>
                        </td>
                        <td>
                           <s:textfield name="#file.importType" size="30" theme="simple"/>
                        </td>
                        <td>
                           <s:textfield name="#file.remark" size="100" theme="simple"/>
                        </td>
                        <td>
                           <s:if test="!disable">
                               <a onclick="delStuffFile('<s:property value="#file.fileId"/>')">删除</a>
                           </s:if>
                        </td>
                    </tr>
                </s:iterator>
            </table>
        </div>
        <div id="delDialog" class="ui-helper-hidden" title="请确认">确定要删除本类型收件吗？</div>
        <div id="saveDialog" class="ui-helper-hidden">
            <iframe scrolling="no" frameborder="0" style="overflow:hidden;width:100%;height:100%;"></iframe>
        </div>
    </div>
    <script type="text/javascript">
        var tmp = new Array();

        $(function() {
            $("#block").validationEngine();
            $("#auction-list").validationEngine();
            $('#info_receiveDate').click(function(){WdatePicker({dateFmt:'yyyy-MM-dd'});});

            if($("#disable").val()=='false'){
                $("#add-line").attr("class","add-line");
                $("#add-line").click(function(){
                    var html = "<tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr>";
                });
            }

            $(":text").focus(function(){
                $(this).css("background-color","#CBFE9F");

                var key1 = $(this).parent().parent().children()[0].name.split("#")[0]|| $(this).parent().parent().children()[0].name.split("#")[1];
                var value1 = $(this).parent().parent().children()[0].value || "";
                var key2 = $(this).attr("name").split("#")[0] || $(this).attr("name").split("#")[1];
                var value2 = $(this).val() || "";
                pushValue(key1,value1,key2,value2);
            });

            $(":text").blur(function(){
                $(this).css("background-color","");

                var key1 = $(this).parent().parent().children()[0].name.split("#")[0] || $(this).parent().parent().children()[0].name.split("#")[1];
                var value1 = $(this).parent().parent().children()[0].value || "";
                var key2 = $(this).attr("name").split("#")[0] || $(this).attr("name").split("#")[1];
                var value2 = (key2 == "file.rCopies" || key2 == "file.sCopies")?$(this).val()||0:$(this).val()|| "";
                saveFiles(key1,value1,key2,value2);
            });

             $("#add-line").click(function() {
                addStuffFile();
            });
        });

        function saveFiles(key1,value1,key2,value2){
            if(getBeforeValue(key1,value1,key2,value2)){
                $.ajax({
                   type: "POST",
                   url: "fc!attrSave.action",
                   data: key1 + "=" + value1 + "&" + key2 + "=" + value2,
                   success: function(msg){

                   }
                });
            }
        }

        function getBeforeValue(key1,value1,key2,value2){
            if(tmp.length > 0){
                for(var index = 0;index < tmp.length; index ++){
                    if((tmp[index])[key1] == value1){
                        if(tmp[index][key2] != value2){
                            var item = tmp[index];
                            tmp.splice(index,1);
                            return item;
                        }else{
                            tmp.splice(index,1);
                        }
                    }
                }
            }

            return ;
        }

        function pushValue(key1,value1,key2,value2){
            var obj = new Object();
            obj[key1] = value1;
            obj[key2] = value2;
            tmp.push(obj);

            return obj;
        }

        function replaceNum(el) {
            if (el.value)
                el.value = el.value.replace(/[^\d.-]/g, '');
        }

        function delStuffFile(id){
            $("#delDialog").dialog({
                modal: true,
                buttons: {
                    '取 消': function() {
                        $(this).dialog('close');
                    },
                    '删 除': function() {
                        var dialog = $(this);
                        $.ajax({
                            type: "POST",
                            url: "fc!fileDel.action" + document.location.search,
                            data:"&file.fileId=" + id,
                            success: function() {
                                dialog.dialog('close');
                                $("#\\\#file\\_fileId").each(function(o){
                                    if($(this).val() == id){
                                        var tmpTr = $(this).parent().remove();
                                    }
                                });
                            }
                        });
                    }
                }
            });
            return false;
        }

        var iframe = $("#saveDialog iframe");
        function addStuffFile(){
            $("#saveDialog").dialog({
                title: '添加收件类型',
                height: 300,
                width:500,
                modal: true,
                buttons: {
                    '关 闭': function() {
                        $(this).dialog('close');
                    },
                    '保 存': function() {
                        iframe[0].contentWindow.doSubmit();
                    }
                }
            });
            iframe.attr('src', 'fc!addFile.action');
            return false;
        }
    </script>
</body>
</html>