/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web.action;

import com.gtis.common.http.Utf8PostMethod;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.service.SysSjdService;
import com.gtis.plat.service.SysSubProcessService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.util.CalendarUtil;
import com.gtis.web.SessionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultText;

public class TurnWorkFlowAction {
    private static final Log log = LogFactory.getLog(TurnWorkFlowAction.class);
    private WorkFlowCoreService workFlowService;
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    private SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService;
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    private SysSjdService sysSjdService;
    private NodeService nodeService;
    private SysOpinionService opinionService;
    private SysSubProcessService sysSubProcessService;
    private SysTaskService sysTaskService;
    private String turnXml;
    private String taskid;
    private String opinions;
    private String nextWdid;
    private static final String CONTENT_TYPE_IMAGE = "text/xml";
    private static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    private boolean confirmTurnInfo = false;
    private boolean subProcessFinish = false;
    private List<PfWorkFlowDefineVo> nextWorkflowList;

    public boolean isConfirmTurnInfo() {
        return this.confirmTurnInfo;
    }

    public String execute() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = null;
        if (this.sysSubProcessService.isSubProcessFinishing(this.taskid).booleanValue()) {
            this.subProcessFinish = true;
            info = this.workFlowService.getWorkFlowTurnInfo("-1", this.sysTaskService.getActivity(this.sysTaskService.getTask(this.taskid).getActivityId()).getWorkflowInstanceId());
        } else {
            info = this.workFlowService.getWorkFlowTurnInfo(userId, this.taskid);
        }
        this.turnXml = this.turnInfo(info);
        this.opinions = JSONUtil.serialize((Object)this.opinionService.getOpinionList(userId, info.getWorkFlowDefineVo().getWorkflowName()));
        WorkFlowXml workFlowXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = workFlowXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
        if ("true".equals(activityModel.getExtendedAttribute("ConfirmTurnInfo"))) {
            this.confirmTurnInfo = true;
        }
        return "success";
    }

    public String trunXml() throws Exception {
        String userId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
        WorkFlowInfo info = this.workFlowService.getWorkFlowTurnInfo(userId, this.taskid);
        this.turnXml = this.turnInfo(info);
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(this.turnXml);
        return "none";
    }

    public String opinions() throws Exception {
        String userId = SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest());
        WorkFlowInfo info = this.workFlowService.getWorkFlowTurnInfo(userId, this.taskid);
        this.opinions = JSONUtil.serialize((Object)this.opinionService.getOpinionList(userId, info.getWorkFlowDefineVo().getWorkflowName()));
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(this.opinions);
        return "none";
    }

    private String turnInfo(WorkFlowInfo info) throws Exception {
        List lstTrans;
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String filterType = null;
        ArrayList<String> filterStr = null;
        if (StringUtils.isNotBlank((String)activityModel.getFilterInfo())) {
            List organList;
            Document fileDoc = DocumentHelper.parseText((String)activityModel.getFilterInfo());
            String user = fileDoc.getRootElement().valueOf("@type");
            org.dom4j.Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + SessionUtil.getUserId((HttpServletRequest)ServletActionContext.getRequest()) + "']/Correspondence");
            if (corNode != null && (organList = corNode.selectNodes((filterType = corNode.valueOf("@type")) + "/text()")) != null && !organList.isEmpty()) {
                filterStr = new ArrayList<String>();
                for (DefaultText text : organList) {
                    filterStr.add(text.getText());
                }
            }
        }
        WorkFlowTransInfo transInfo = info.getTransInfo();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Activitys");
        if (transInfo.getTransType().equalsIgnoreCase("and")) {
            root.addAttribute("RelType", "and");
        } else {
            root.addAttribute("RelType", "or");
        }
        if (activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")) {
            root.addAttribute("ReqOpinion", "true");
        } else {
            root.addAttribute("ReqOpinion", "false");
        }
        if (activityModel.getIsSendSMS().equalsIgnoreCase("true")) {
            root.addAttribute("SendSMS", "true");
        } else {
            root.addAttribute("SendSMS", "false");
        }
        if (StringUtils.isNotBlank((String)activityModel.getCooperRootId())) {
            root.addAttribute("cooperRootId", activityModel.getCooperRootId());
        }
        if ((lstTrans = transInfo.getTranActivitys()).size() < 2) {
            root.addAttribute("RelType", "or");
        }
        for (ActivityModel aModel : lstTrans) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
            ActivityEle.addAttribute("Id", aModel.getDefineId());
            if (aModel.isMutiSelect()) {
                ActivityEle.addAttribute("MutiSelect", "true");
            }
            if (!aModel.isSelectAll()) {
                ActivityEle.addAttribute("SelectAll", "false");
            } else {
                ActivityEle.addAttribute("SelectAll", "true");
            }
            if (aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName())) {
                ActivityEle.addAttribute("DefaultSelected", "true");
            } else {
                ActivityEle.addAttribute("DefaultSelected", "false");
            }
            String userName = null;
            if (StringUtils.isNotBlank((String)aModel.getExtendedAttribute("DefaultSelectedUser"))) {
                userName = aModel.getExtendedAttribute("DefaultSelectedUser");
            }
            for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if (filterStr != null && userModel.getType().equals(filterType) && !filterStr.contains(userModel.getId())) continue;
                Element User = ActivityEle.addElement("User");
                User.addAttribute("Name", userModel.getName());
                User.addAttribute("Id", userModel.getId());
                for (PfUserVo vo : userModel.getUserList()) {
                    Element UserInfo2 = User.addElement("UserInfo");
                    UserInfo2.addAttribute("Name", vo.getUserName());
                    UserInfo2.addAttribute("Id", vo.getUserId());
                    if (StringUtils.isNotBlank((String)userName) && vo.getUserName().equalsIgnoreCase(userName)) {
                        User.addAttribute("DefaultSelected", "true");
                        UserInfo2.addAttribute("DefaultSelected", "true");
                    }
                    if (!vo.getUserId().equals(SessionUtil.getCurrentUserId())) continue;
                    User.addAttribute("DefaultSelected", "true");
                    UserInfo2.addAttribute("DefaultSelected", "true");
                }
            }
        }
        if (transInfo.isCanFinish()) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", "\u4efb\u52a1\u529e\u7ed3");
            ActivityEle.addAttribute("Id", "-1");
        }
        doc = this.httpFilterXml(doc, activityModel, info);
        return doc.getRootElement().asXML();
    }

    private Document httpFilterXml(Document doc, ActivityModel actModel, WorkFlowInfo info) {
        if (StringUtils.isNotBlank((String)actModel.getTurnInfoUrl())) {
            String url = actModel.getTurnInfoUrl();
            if (!url.startsWith("http")) {
                url = AppConfig.getPlaceholderValue((String)url);
            }
            HttpClient httpClient = new HttpClient();
            Utf8PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("turnInfo", doc.asXML()), new NameValuePair("userId", info.getUserId()), new NameValuePair("proId", info.getWorkFlowIntanceVo() == null ? "" : info.getWorkFlowIntanceVo().getProId())};
            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod((HttpMethod)postMethod);
            }
            catch (IOException e) {
                log.error((Object)"TurnInfo filter url request failer{}", (Throwable)e);
            }
            if (status == 200) {
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if (StringUtils.isNotBlank((String)xml)) {
                        doc = DocumentHelper.parseText((String)xml);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"TurnInfo filter url request success,prase failure{}", (Throwable)e);
                }
            } else {
                log.error((Object)"TurnInfo filter url request failer");
            }
        }
        return doc;
    }

    public String TurnTask() throws Exception {
        try {
            String userId = SessionUtil.getCurrentUserId();
            WorkFlowInfo info = this.workFlowService.getWorkFlowTurnInfo(userId, this.taskid);
            this.workFlowService.turnTask(this.parseTurnInfo(), this.taskid);
            if (StringUtils.isNotBlank((String)this.nextWdid)) {
                this.startNextWorkflow(info.getWorkFlowIntanceVo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printResult(e.getMessage());
        }
        this.printResult(null);
        return "none";
    }

    private Document parseTurnInfo() throws Exception {
        Document doc = null;
        SAXReader reader = new SAXReader();
        doc = reader.read((InputStream)ServletActionContext.getRequest().getInputStream());
        return doc;
    }

    private void printResult(String info) {
        try {
            ServletActionContext.getResponse().setContentType("text/html; charset=utf-8");
            PrintWriter out = ServletActionContext.getResponse().getWriter();
            if (info == null) {
                out.print("true");
            } else {
                out.println(info);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String finishWorkflow() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = this.workFlowService.getWorkFlowTurnInfo(userId, this.taskid);
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String enabledNextWorkflow = activityModel.getEnabledNextWorkflow();
        if (StringUtils.isNotBlank((String)enabledNextWorkflow)) {
            this.nextWorkflowList = new ArrayList();
            List<String> workflowNameList = Arrays.asList(enabledNextWorkflow.split(","));
            List pfWorkFlowDefineVoList = this.sysWorkFlowDefineService.getWorkFlowDefineList();
            for (PfWorkFlowDefineVo pfWorkFlowDefineVo : pfWorkFlowDefineVoList) {
                if (workflowNameList.indexOf(pfWorkFlowDefineVo.getWorkflowName()) <= -1) continue;
                this.nextWorkflowList.add(pfWorkFlowDefineVo);
            }
        }
        return "finish";
    }

    public String hasNextWorkflow() throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = this.workFlowService.getWorkFlowTurnInfo(userId, this.taskid);
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String enabledNextWorkflow = activityModel.getEnabledNextWorkflow();
        if (StringUtils.isNotBlank((String)enabledNextWorkflow)) {
            this.printResult(null);
        } else {
            this.printResult("false");
        }
        return "none";
    }

    private void startNextWorkflow(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) throws Exception {
        String currentWorkflowName = pfWorkFlowInstanceVo.getWorkflowIntanceName();
        PfWorkFlowDefineVo workFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(this.nextWdid);
        boolean isOk = true;
        List voList = this.sysWorkFlowInstanceRelService.getWorkFlowRelList(pfWorkFlowInstanceVo.getWorkflowIntanceId());
        if (voList != null || voList.size() > 0) {
            for (int i = 0; i < voList.size(); ++i) {
                if (!StringUtils.equals((String)((PfWorkFlowInstanceVo)voList.get(i)).getWorkflowDefinitionId(), (String)this.nextWdid)) continue;
                isOk = false;
                break;
            }
        }
        if (isOk) {
            PfTaskVo taskVo;
            Space space = this.nodeService.getWorkSpace(WORK_FLOW_STUFF, true);
            Node curNode = this.nodeService.getNode(space.getId(), pfWorkFlowInstanceVo.getWorkflowIntanceId(), true);
            Integer curNodeId = curNode.getId();
            List curNodeList = this.nodeService.getChildNodes(curNodeId);
            Integer[] curNodes = null;
            if (curNodeList != null && curNodeList.size() > 0) {
                curNodes = new Integer[curNodeList.size()];
                for (int i = 0; i < curNodeList.size(); ++i) {
                    curNodes[i] = ((Node)curNodeList.get(i)).getId();
                }
            }
            String newProid = UUIDGenerator.generate();
            Node newNode = this.nodeService.getNode(space.getId(), newProid, true);
            Integer newNodeId = newNode.getId();
            if (curNodes != null && curNodes.length > 0) {
                this.nodeService.copy(curNodes, newNodeId, true);
            }
            String userid = SessionUtil.getCurrentUserId();
            String username = SessionUtil.getCurrentUser().getUsername();
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
            intanceVo.setWorkflowDefinitionId(this.nextWdid);
            intanceVo.setWorkflowIntanceId(newProid);
            intanceVo.setProId(newProid);
            String remark = "\u5927\u6d41\u7a0b";
            intanceVo.setRemark(remark);
            intanceVo.setTimeLimit(workFlowDefineVo.getTimeLimit());
            intanceVo.setPriority("1");
            intanceVo.setWorkflowIntanceName(currentWorkflowName);
            intanceVo.setCreateUser(userid);
            intanceVo.setCreateTime(CalendarUtil.getCurHMDate());
            intanceVo.setDistrict(pfWorkFlowInstanceVo.getDistrict());
            this.sysWorkFlowInstanceRelService.insertWorkFlowRel(pfWorkFlowInstanceVo.getWorkflowIntanceId(), newProid);
            WorkFlowInfo infoObj = this.workFlowService.createWorkFlowInstance(intanceVo, userid);
            Iterator i$ = infoObj.getTargetTasks().iterator();
            while (i$.hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                if (!taskVo.getUserVo().getUserId().equals(userid)) continue;
                this.taskid = taskVo.getTaskId();
                break;
            }
            if ((this.taskid == null || this.taskid.equals("")) && (i$ = infoObj.getTargetTasks().iterator()).hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                this.taskid = taskVo.getTaskId();
            }
            this.sysSjdService.createSjdByPreviousWorkflow(newProid, username, newNodeId, pfWorkFlowInstanceVo.getWorkflowIntanceId());
        }
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getOpinions() {
        return this.opinions;
    }

    public WorkFlowCoreService getWorkFlowService() {
        return this.workFlowService;
    }

    public void setWorkFlowService(WorkFlowCoreService workFlowService) {
        this.workFlowService = workFlowService;
    }

    public String getTurnXml() {
        return this.turnXml;
    }

    public void setTurnXml(String turnXml) {
        this.turnXml = turnXml;
    }

    public void setOpinionService(SysOpinionService opinionService) {
        this.opinionService = opinionService;
    }

    public SysWorkFlowDefineService getSysWorkFlowDefineService() {
        return this.sysWorkFlowDefineService;
    }

    public void setSysWorkFlowDefineService(SysWorkFlowDefineService sysWorkFlowDefineService) {
        this.sysWorkFlowDefineService = sysWorkFlowDefineService;
    }

    public List<PfWorkFlowDefineVo> getNextWorkflowList() {
        return this.nextWorkflowList;
    }

    public void setNextWorkflowList(List<PfWorkFlowDefineVo> nextWorkflowList) {
        this.nextWorkflowList = nextWorkflowList;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public SysSjdService getSysSjdService() {
        return this.sysSjdService;
    }

    public void setSysSjdService(SysSjdService sysSjdService) {
        this.sysSjdService = sysSjdService;
    }

    public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
        return this.sysWorkFlowInstanceService;
    }

    public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
        this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
    }

    public SysWorkFlowInstanceRelService getSysWorkFlowInstanceRelService() {
        return this.sysWorkFlowInstanceRelService;
    }

    public void setSysWorkFlowInstanceRelService(SysWorkFlowInstanceRelService sysWorkFlowInstanceRelService) {
        this.sysWorkFlowInstanceRelService = sysWorkFlowInstanceRelService;
    }

    public String getNextWdid() {
        return this.nextWdid;
    }

    public void setNextWdid(String nextWdid) {
        this.nextWdid = nextWdid;
    }

    public SysSubProcessService getSysSubProcessService() {
        return this.sysSubProcessService;
    }

    public void setSysSubProcessService(SysSubProcessService sysSubProcessService) {
        this.sysSubProcessService = sysSubProcessService;
    }

    public boolean isSubProcessFinish() {
        return this.subProcessFinish;
    }

    public void setSubProcessFinish(boolean subProcessFinish) {
        this.subProcessFinish = subProcessFinish;
    }

    public SysTaskService getSysTaskService() {
        return this.sysTaskService;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }
}

